/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.blocking;

import hj.lang.Runtime;
import hj.lang.RuntimeAbortException;
import hj.runtime.wsh.blocking.BlockingActivity;

public interface InvocationStrategy {
    public static final InvocationStrategy ASYNC = new DefaultStrategy();
    public static final InvocationStrategy ASYNC_IN_FINISH = new AsyncInFinishStrategy();

    public void invokeHjTask(BlockingActivity var1);

    public static class AsyncInFinishStrategy
    implements InvocationStrategy {
        private AsyncInFinishStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeHjTask(BlockingActivity activityToInvoke) {
            activityToInvoke.startFinish();
            try {
                activityToInvoke.runHjTask();
            }
            catch (Throwable t) {
                activityToInvoke.pushException(t);
            }
            finally {
                activityToInvoke.stopFinish();
            }
        }
    }

    public static class DefaultStrategy
    implements InvocationStrategy {
        private DefaultStrategy() {
        }

        public void invokeHjTask(BlockingActivity activityToInvoke) {
            try {
                activityToInvoke.runHjTask();
            }
            catch (Throwable e) {
                if (e instanceof RuntimeAbortException) {
                    Runtime.runtime.emergencyShutdown((RuntimeAbortException)e);
                } else {
                    activityToInvoke.finalizeTermination(e);
                }
                return;
            }
            activityToInvoke.finalizeTermination();
        }
    }
}

