/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.cooperative;

import hj.lang.PhaserAbst;
import hj.lang.PhaserException;
import hj.lang.accumulator;
import hj.lang.phaser;
import hj.runtime.wsh.cooperative.SuspendableActivity;
import hj.runtime.wsh.cooperative.SuspendableRawPhaser;
import hj.runtime.wsh.cooperative.WshCooperativeRuntime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Accumulator {
    public static AccumulatorAdapter newAccumulator(accumulator.Operator operator, Class type, phaser ph) {
        Accumulator.checkPhaserRegistration(ph);
        SuspendableRawPhaser rawPhaser = (SuspendableRawPhaser)ph.getPhaser();
        if (accumulator.Operator.ANY.equals((Object)operator)) {
            if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
                return new IntAnyAccumulator(rawPhaser);
            }
            if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
                return new DoubleAnyAccumulator(rawPhaser);
            }
            if (Object.class.isAssignableFrom(type)) {
                return new ObjectAnyAccumulator(type, rawPhaser);
            }
        } else if (accumulator.Operator.SUM.equals((Object)operator)) {
            if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
                return new IntSumAccumulator(rawPhaser);
            }
            if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
                return new DoubleSumAccumulator(rawPhaser);
            }
        } else if (accumulator.Operator.MAX.equals((Object)operator)) {
            if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
                return new IntMaxAccumulator(rawPhaser);
            }
            if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
                return new DoubleMaxAccumulator(rawPhaser);
            }
        } else if (accumulator.Operator.MIN.equals((Object)operator)) {
            if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
                return new IntMinAccumulator(rawPhaser);
            }
            if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
                return new DoubleMinAccumulator(rawPhaser);
            }
        }
        throw new PhaserException("Unsupported: newAccumulator(" + (Object)((Object)operator) + ", " + type + ", " + ph + ")");
    }

    private static void checkPhaserRegistration(phaser ph) {
        SuspendableActivity wshActivity = WshCooperativeRuntime.getCurrentWshActivity();
        PhaserAbst phaserAbst = ph.getPhaser();
        PhaserAbst.Mode mode = wshActivity.phaserMode(phaserAbst);
        assert (mode != PhaserAbst.Mode.TRANSMIT);
        if (mode == PhaserAbst.Mode.SIG || mode == PhaserAbst.Mode.WAIT) {
            throw new PhaserException("SIG-ONLY/WAIT-ONLY unsupported in cooperative runtime");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleMinAccumulator
    extends DoubleAccumulator<AtomicReference<Double>> {
        private final AtomicBoolean lock = new AtomicBoolean(false);

        protected DoubleMinAccumulator(SuspendableRawPhaser rawPhaser) {
            super(accumulator.Operator.MIN, Double.class, rawPhaser);
        }

        @Override
        protected AtomicReference<Double> initialValue() {
            return new AtomicReference<Double>((Double)Double.MAX_VALUE);
        }

        @Override
        protected double doubleValue(AtomicReference<Double> resultObj) {
            return resultObj.get();
        }

        @Override
        public void send(final double val) {
            if (this.isValidSend()) {
                this.atomic(new Runnable(){

                    public void run() {
                        AtomicReference accumCell = (AtomicReference)DoubleMinAccumulator.this.getResultCell();
                        double curValue = (Double)accumCell.get();
                        if (curValue > val) {
                            accumCell.set(val);
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleMaxAccumulator
    extends DoubleAccumulator<AtomicReference<Double>> {
        private final AtomicBoolean lock = new AtomicBoolean(false);

        protected DoubleMaxAccumulator(SuspendableRawPhaser rawPhaser) {
            super(accumulator.Operator.MAX, Double.class, rawPhaser);
        }

        @Override
        protected AtomicReference<Double> initialValue() {
            return new AtomicReference<Double>((Double)Double.MIN_VALUE);
        }

        @Override
        protected double doubleValue(AtomicReference<Double> resultObj) {
            return resultObj.get();
        }

        @Override
        public void send(final double val) {
            if (this.isValidSend()) {
                this.atomic(new Runnable(){

                    public void run() {
                        AtomicReference accumCell = (AtomicReference)DoubleMaxAccumulator.this.getResultCell();
                        double curValue = (Double)accumCell.get();
                        if (curValue < val) {
                            accumCell.set(val);
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleSumAccumulator
    extends DoubleAccumulator<AtomicReference<Double>> {
        protected DoubleSumAccumulator(SuspendableRawPhaser rawPhaser) {
            super(accumulator.Operator.SUM, Double.class, rawPhaser);
        }

        @Override
        protected AtomicReference<Double> initialValue() {
            return new AtomicReference<Double>(0.0);
        }

        @Override
        protected double doubleValue(AtomicReference<Double> resultObj) {
            return resultObj.get();
        }

        @Override
        public void send(final double val) {
            if (this.isValidSend()) {
                this.atomic(new Runnable(){

                    public void run() {
                        AtomicReference accumCell = (AtomicReference)DoubleSumAccumulator.this.getResultCell();
                        double oldValue = (Double)accumCell.get();
                        double newValue = oldValue + val;
                        accumCell.set(newValue);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleAnyAccumulator
    extends DoubleAccumulator<AtomicReference<Double>> {
        protected DoubleAnyAccumulator(SuspendableRawPhaser rawPhaser) {
            super(accumulator.Operator.ANY, Double.class, rawPhaser);
        }

        @Override
        protected AtomicReference<Double> initialValue() {
            return new AtomicReference<Double>(0.0);
        }

        @Override
        protected double doubleValue(AtomicReference<Double> resultObj) {
            return resultObj.get();
        }

        @Override
        public void send(double val) {
            if (this.isValidSend()) {
                ((AtomicReference)this.getResultCell()).set(val);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DoubleAccumulator<ResultType>
    extends AbstractAccumulator<ResultType> {
        public DoubleAccumulator(accumulator.Operator operator, Class type, SuspendableRawPhaser rawPhaser) {
            super(operator, type, rawPhaser);
        }

        @Override
        protected abstract ResultType initialValue();

        protected abstract double doubleValue(ResultType var1);

        @Override
        protected ResultType getResultCell() {
            return this.getResultCell(this.getActivityPhase());
        }

        @Override
        protected ResultType getResultCell(int phase) {
            Object resultObj = this.resultMap.get(phase);
            if (resultObj == null) {
                this.resultMap.putIfAbsent(phase, this.initialValue());
                resultObj = this.resultMap.get(phase);
            }
            return (ResultType)resultObj;
        }

        @Override
        public void send(Number val) {
            this.send(val.doubleValue());
        }

        @Override
        public void send(Object obj) {
            if (!(obj instanceof Number)) {
                throw new IllegalArgumentException("DoubleSumAccumulator cannot process " + obj);
            }
            this.send(((Number)obj).doubleValue());
        }

        @Override
        public double doubleResult() {
            int activityPhase = this.getActivityPhase() - 1;
            ResultType resultCell = this.getResultCell(activityPhase);
            return this.doubleValue(resultCell);
        }

        @Override
        public Number result() {
            return this.doubleResult();
        }

        @Override
        public Object objResult() {
            return this.doubleResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntMinAccumulator
    extends IntAccumulator<AtomicInteger> {
        protected IntMinAccumulator(SuspendableRawPhaser rawPhaser) {
            super(accumulator.Operator.MIN, Integer.class, rawPhaser);
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(Integer.MAX_VALUE);
        }

        @Override
        protected int intValue(AtomicInteger resultObj) {
            return resultObj.get();
        }

        @Override
        public void send(final int val) {
            if (this.isValidSend()) {
                this.atomic(new Runnable(){

                    public void run() {
                        AtomicInteger accumCell = (AtomicInteger)IntMinAccumulator.this.getResultCell();
                        int curValue = accumCell.get();
                        if (curValue > val) {
                            accumCell.set(val);
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntMaxAccumulator
    extends IntAccumulator<AtomicInteger> {
        protected IntMaxAccumulator(SuspendableRawPhaser rawPhaser) {
            super(accumulator.Operator.MAX, Integer.class, rawPhaser);
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(Integer.MIN_VALUE);
        }

        @Override
        protected int intValue(AtomicInteger resultObj) {
            return resultObj.get();
        }

        @Override
        public void send(final int val) {
            if (this.isValidSend()) {
                this.atomic(new Runnable(){

                    public void run() {
                        AtomicInteger accumCell = (AtomicInteger)IntMaxAccumulator.this.getResultCell();
                        int curValue = accumCell.get();
                        if (curValue < val) {
                            accumCell.set(val);
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntSumAccumulator
    extends IntAccumulator<AtomicInteger> {
        protected IntSumAccumulator(SuspendableRawPhaser rawPhaser) {
            super(accumulator.Operator.SUM, Integer.class, rawPhaser);
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }

        @Override
        protected int intValue(AtomicInteger resultObj) {
            return resultObj.get();
        }

        @Override
        public void send(int val) {
            if (this.isValidSend()) {
                AtomicInteger accumCell = (AtomicInteger)this.getResultCell();
                accumCell.addAndGet(val);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntAnyAccumulator
    extends IntAccumulator<AtomicInteger> {
        protected IntAnyAccumulator(SuspendableRawPhaser rawPhaser) {
            super(accumulator.Operator.ANY, Integer.class, rawPhaser);
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }

        @Override
        protected int intValue(AtomicInteger resultObj) {
            return resultObj.get();
        }

        @Override
        public void send(int val) {
            if (this.isValidSend()) {
                ((AtomicInteger)this.getResultCell()).set(val);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class IntAccumulator<ResultType>
    extends AbstractAccumulator<ResultType> {
        public IntAccumulator(accumulator.Operator operator, Class type, SuspendableRawPhaser rawPhaser) {
            super(operator, type, rawPhaser);
        }

        protected abstract int intValue(ResultType var1);

        @Override
        public void send(Number val) {
            this.send(val.intValue());
        }

        @Override
        public void send(Object obj) {
            if (!(obj instanceof Number)) {
                throw new IllegalArgumentException("IntSumAccumulator cannot process " + obj);
            }
            this.send(((Number)obj).intValue());
        }

        @Override
        public int intResult() {
            int activityPhase = this.getActivityPhase() - 1;
            Object resultCell = this.getResultCell(activityPhase);
            return this.intValue(resultCell);
        }

        @Override
        public Number result() {
            return this.intResult();
        }

        @Override
        public Object objResult() {
            return this.intResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectAnyAccumulator
    extends AbstractAccumulator<AtomicReference<Object>> {
        public ObjectAnyAccumulator(Class type, SuspendableRawPhaser rawPhaser) {
            super(accumulator.Operator.ANY, type, rawPhaser);
        }

        @Override
        protected AtomicReference<Object> initialValue() {
            return new AtomicReference<Object>(null);
        }

        @Override
        public void send(Object obj) {
            if (this.isValidSend()) {
                if (obj != null && !this.getType().isAssignableFrom(obj.getClass())) {
                    throw new PhaserException("Unsupported type: " + obj.getClass() + ", expecting sub-class of " + this.getType());
                }
                ((AtomicReference)this.getResultCell()).set(obj);
            }
        }

        @Override
        public Object objResult() {
            int activityPhase = this.getActivityPhase() - 1;
            return ((AtomicReference)this.getResultCell(activityPhase)).get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractAccumulator<ResultType>
    extends AccumulatorAdapter {
        protected final ConcurrentHashMap<Integer, ResultType> resultMap = new ConcurrentHashMap();
        private final AtomicBoolean lock = new AtomicBoolean(false);

        public AbstractAccumulator(accumulator.Operator operator, Class type, SuspendableRawPhaser rawPhaser) {
            super(operator, type, rawPhaser);
        }

        protected abstract ResultType initialValue();

        protected ResultType getResultCell() {
            return this.getResultCell(this.getActivityPhase());
        }

        protected ResultType getResultCell(int phase) {
            ResultType resultObj = this.resultMap.get(phase);
            if (resultObj == null) {
                this.resultMap.putIfAbsent(phase, this.initialValue());
                resultObj = this.resultMap.get(phase);
            }
            return resultObj;
        }

        public void atomic(Runnable block) {
            boolean keepLooping = true;
            do {
                boolean success;
                if (!(success = this.lock.compareAndSet(false, true))) continue;
                block.run();
                this.lock.set(false);
                keepLooping = false;
            } while (keepLooping);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AccumulatorAdapter
    extends accumulator {
        protected final accumulator.Operator operator;
        protected final Class<? extends Object> type;
        protected final SuspendableRawPhaser rawPhaser;

        protected AccumulatorAdapter(accumulator.Operator operator, Class<? extends Object> type, SuspendableRawPhaser rawPhaser) {
            this.operator = operator;
            this.type = type;
            this.rawPhaser = rawPhaser;
            rawPhaser.registerAccumulator(this);
        }

        protected void updateResult(int phase) {
        }

        protected final int getActivityPhase() {
            SuspendableActivity sender = WshCooperativeRuntime.getCurrentWshActivity();
            int sigPhase = sender.getSigPhase(this.rawPhaser);
            int waitPhase = sender.getWaitPhase(this.rawPhaser);
            return Math.max(sigPhase, waitPhase);
        }

        @Override
        public void send(Number val) {
            throw new PhaserException("Unsupported: send(Number) in " + this.toString());
        }

        @Override
        public void send(int val) {
            throw new PhaserException("Unsupported: send(int) in " + this.toString());
        }

        @Override
        public void send(double val) {
            throw new PhaserException("Unsupported: send(double) in " + this.toString());
        }

        @Override
        public void send(Object obj) {
            throw new PhaserException("Unsupported: send(Object) in " + this.toString());
        }

        @Override
        public void send(int[] arr) {
            throw new PhaserException("Unsupported: send(int[]) in " + this.toString());
        }

        @Override
        public void send(double[] arr) {
            throw new PhaserException("Unsupported: send(double[]) in " + this.toString());
        }

        @Override
        public void send(Object[] arr) {
            throw new PhaserException("Unsupported: send(Object[]) in " + this.toString());
        }

        @Override
        public void send(Number val, int workerId) {
            throw new PhaserException("Unsupported: finish accumulator: send(Number, int) in " + this.toString());
        }

        @Override
        public void send(int val, int workerId) {
            throw new PhaserException("Unsupported: finish accumulator: send(int, int) in " + this.toString());
        }

        @Override
        public void send(double val, int workerId) {
            throw new PhaserException("Unsupported: finish accumulator: send(double, int) in " + this.toString());
        }

        @Override
        public Number result() {
            throw new PhaserException("Unsupported: result() in " + this.toString());
        }

        @Override
        public final Number result(int offset) {
            throw new PhaserException("Unsupported: bounded phaser: result(int) in " + this.toString());
        }

        @Override
        public int intResult() {
            throw new PhaserException("Unsupported: intResult() in " + this.toString());
        }

        @Override
        public final int intResult(int offset) {
            throw new PhaserException("Unsupported: bounded phaser: intResult(int) in " + this.toString());
        }

        @Override
        public double doubleResult() {
            throw new PhaserException("Unsupported: doubleResult() in " + this.toString());
        }

        @Override
        public final double doubleResult(int offset) {
            throw new PhaserException("Unsupported: bounded phaser: doubleResult(int) in " + this.toString());
        }

        @Override
        public Object objResult() {
            throw new PhaserException("Unsupported: objResult() in " + this.toString());
        }

        @Override
        public final Object objResult(int offset) {
            throw new PhaserException("Unsupported: bounded phaser: objResult(int) in " + this.toString());
        }

        @Override
        public int[] intResultArr() {
            throw new PhaserException("Unsupported: intResultArr() in " + this.toString());
        }

        @Override
        public final int[] intResultArr(int offset) {
            throw new PhaserException("Unsupported: bounded phaser: intResultArr(int) in " + this.toString());
        }

        @Override
        public double[] doubleResultArr() {
            throw new PhaserException("Unsupported: doubleResultArr() in " + this.toString());
        }

        @Override
        public final double[] doubleResultArr(int offset) {
            throw new PhaserException("Unsupported: bounded phaser: doubleResultArr(int) in " + this.toString());
        }

        @Override
        public Object[] objResultArr() {
            throw new PhaserException("Unsupported: objResultArr() in " + this.toString());
        }

        @Override
        public final Object[] objResultArr(int offset) {
            throw new PhaserException("Unsupported: bounded phaser: objResultArr(int) in " + this.toString());
        }

        @Override
        public final Class<? extends Object> getType() {
            return this.type;
        }

        @Override
        public final accumulator.Operator getOperator() {
            return this.operator;
        }

        @Override
        public final int getRound() {
            throw new PhaserException("Unsupported: getRound() in " + this.toString());
        }

        @Override
        public final int getArrsize() {
            return 1;
        }

        protected boolean isValidSend() {
            PhaserAbst.Mode mode = PhaserAbst.pm2rm(this.rawPhaser.getPhaserMode());
            if ((mode == PhaserAbst.Mode.SIG_WAIT || mode == PhaserAbst.Mode.SIG_WAIT_SINGLE) && this.rawPhaser.quiescent()) {
                throw new PhaserException("Accumulator: SIG_WAIT can't perform send after signal.");
            }
            return mode != PhaserAbst.Mode.WAIT;
        }

        public String toString() {
            return "Accumulator{operator=" + (Object)((Object)this.operator) + ", type=" + this.type + ", currentActivityPhase=" + this.getActivityPhase() + '}';
        }
    }
}

