/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.cooperative;

import hj.runtime.wsh.actor.LinkedDdcNode;
import hj.runtime.wsh.cooperative.DataDrivenControl;
import hj.runtime.wsh.cooperative.DataDrivenPauseReason;
import hj.runtime.wsh.cooperative.SuspendableActivity;
import hj.runtime.wsh.cooperative.WshCooperativeRuntime;
import java.util.concurrent.atomic.AtomicBoolean;
import kilim.Fiber;
import kilim.Pausable;
import kilim.State;
import kilim.Task;

public class CooperativeIsolationManager {
    public static final CooperativeIsolationManager ONLY = new CooperativeIsolationManager();
    private final AtomicBoolean currentDdcLock = new AtomicBoolean(false);
    private LinkedDdcNode<Object> currentDdc;
    private LinkedDdcNode<Object> activeDdc;
    private SuspendableActivity activeWshActivity;
    private int nestedIsolationCount;
    public static final boolean $isWoven = true;

    private CooperativeIsolationManager() {
        LinkedDdcNode firstMessageDdc = new LinkedDdcNode();
        this.currentDdc = firstMessageDdc;
        this.activeDdc = firstMessageDdc;
        this.activeWshActivity = null;
        this.nestedIsolationCount = 0;
        firstMessageDdc.value().setValue(Boolean.TRUE);
    }

    private RegistrationResult register() {
        boolean keepLooping = true;
        RegistrationResult result = null;
        do {
            boolean success;
            if (!(success = this.currentDdcLock.compareAndSet(false, true))) continue;
            LinkedDdcNode<Object> oldDdc = this.currentDdc;
            this.currentDdc = oldDdc.next();
            result = new RegistrationResult(this.activeDdc == oldDdc, oldDdc);
            this.currentDdcLock.set(false);
            keepLooping = false;
        } while (keepLooping);
        return result;
    }

    public void startIsolation(Fiber fiber) throws Pausable {
        block9: {
            DataDrivenPauseReason dataDrivenPauseReason;
            Fiber fiber2 = fiber;
            switch (fiber2.pc) {
                default: {
                    fiber2.wrongPC();
                }
                case 1: {
                    fiber = null;
                    Object var2_3 = null;
                    Object var3_5 = null;
                    dataDrivenPauseReason = null;
                    break;
                }
                case 0: {
                    SuspendableActivity currentWshActivity = WshCooperativeRuntime.getCurrentWshActivity();
                    if (this.activeWshActivity == currentWshActivity) {
                        ++this.nestedIsolationCount;
                        return;
                    }
                    RegistrationResult registrationResult = this.register();
                    if (registrationResult.activeRegistration) break block9;
                    DataDrivenControl<Object> dataDrivenControl = registrationResult.ddcNode.value();
                    dataDrivenPauseReason = new DataDrivenPauseReason(dataDrivenControl);
                }
            }
            Task.pause(dataDrivenPauseReason, (Fiber)fiber2.down());
            switch (fiber2.up()) {
                case 2: {
                    State state = new State();
                    state.self = this;
                    state.pc = 1;
                    fiber2.setState(state);
                    return;
                }
                case 3: {
                    return;
                }
            }
        }
        this.activeWshActivity = WshCooperativeRuntime.getCurrentWshActivity();
        ++this.nestedIsolationCount;
    }

    public void startIsolation() throws Pausable {
        Task.errNotWoven();
    }

    public void stopIsolation() {
        boolean keepLooping = true;
        do {
            boolean success;
            if (!(success = this.currentDdcLock.compareAndSet(false, true))) continue;
            --this.nestedIsolationCount;
            if (this.nestedIsolationCount == 0) {
                this.activeWshActivity = null;
                this.activeDdc = this.activeDdc.next();
                this.activeDdc.value().setValue(Boolean.TRUE);
            }
            this.currentDdcLock.set(false);
            keepLooping = false;
        } while (keepLooping);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrationResult {
        final boolean activeRegistration;
        final LinkedDdcNode<Object> ddcNode;

        private RegistrationResult(boolean activeRegistration, LinkedDdcNode<Object> ddcNode) {
            this.activeRegistration = activeRegistration;
            this.ddcNode = ddcNode;
        }
    }
}

