/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.cooperative;

import hj.runtime.wsh.cooperative.Resumable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataDrivenControl<ValueType> {
    private ValueType itemValue = null;
    private boolean valueAvailable = false;
    private final LinkedList<Resumable> awaitingTasks = new LinkedList();
    private final boolean penalizeDuplicatePuts;
    private final AtomicBoolean atomicLock = new AtomicBoolean(false);

    public DataDrivenControl() {
        this(true);
    }

    public DataDrivenControl(boolean penalizeDuplicatePuts) {
        this.penalizeDuplicatePuts = penalizeDuplicatePuts;
    }

    public final boolean setValue(ValueType theValue) {
        boolean keepLooping = true;
        boolean releaseResumables = false;
        do {
            boolean success;
            if (!(success = this.atomicLock.compareAndSet(false, true))) continue;
            if (!this.valueAvailable) {
                this.itemValue = theValue;
                this.valueAvailable = true;
                releaseResumables = true;
            } else if (this.penalizeDuplicatePuts) {
                this.atomicLock.set(false);
                throw new IllegalStateException("attempted duplicate set on DDC!");
            }
            this.atomicLock.set(false);
            keepLooping = false;
        } while (keepLooping);
        if (releaseResumables) {
            Resumable resumable = this.awaitingTasks.poll();
            while (resumable != null) {
                resumable.resume();
                resumable = this.awaitingTasks.poll();
            }
        }
        return releaseResumables;
    }

    public final boolean valueAvailable() {
        return this.valueAvailable;
    }

    public final ValueType getValue() {
        if (this.itemValue != null) {
            return this.itemValue;
        }
        ValueType resultValue = this.itemValue;
        boolean keepLooping = true;
        do {
            boolean success;
            if (!(success = this.atomicLock.compareAndSet(false, true))) continue;
            resultValue = this.itemValue;
            this.atomicLock.set(false);
            keepLooping = false;
        } while (keepLooping);
        return resultValue;
    }

    public final void addResumable(Resumable resumable) {
        if (this.valueAvailable) {
            resumable.resume();
        } else {
            boolean resumeImmediately = true;
            boolean keepLooping = true;
            do {
                boolean success;
                if (!(success = this.atomicLock.compareAndSet(false, true))) continue;
                if (!this.valueAvailable) {
                    this.awaitingTasks.add(resumable);
                    resumeImmediately = false;
                }
                this.atomicLock.set(false);
                keepLooping = false;
            } while (keepLooping);
            if (resumeImmediately) {
                resumable.resume();
            }
        }
    }

    public String toString() {
        return "DataDrivenControl{# awaitingTasks=" + this.awaitingTasks.size() + ", valueAvailable=" + this.valueAvailable + '}';
    }
}

