/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.cooperative;

import hj.lang.PhaserAbst;
import hj.lang.Runtime;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshFuture;
import hj.runtime.wsh.cooperative.DataDrivenControl;
import hj.runtime.wsh.cooperative.DataDrivenPauseReason;
import hj.runtime.wsh.cooperative.ResumableTask;
import hj.runtime.wsh.cooperative.RunnableTask;
import hj.runtime.wsh.cooperative.SuspendableFinishState;
import hj.runtime.wsh.cooperative.SuspendableInvocationStrategy;
import hj.runtime.wsh.cooperative.SuspendablePhaserManager;
import hj.runtime.wsh.cooperative.SuspendableRawPhaser;
import hj.runtime.wsh.cooperative.WshCooperativeRuntime;
import hj.runtime.wsh.phaser.PhaserRegModeImpl;
import java.util.Collections;
import java.util.List;
import kilim.Fiber;
import kilim.Pausable;
import kilim.PauseReason;
import kilim.State;
import kilim.Task;
import kilim.TaskDoneReason;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SuspendableActivity
extends Activity {
    private RunnableTask wrapperTask;
    private SuspendablePhaserManager phaserManager;
    private SuspendableInvocationStrategy invocationStrategy = SuspendableInvocationStrategy.ASYNC;
    public static final boolean $isWoven = true;

    protected SuspendableActivity(String name) {
        this(Collections.emptyList(), name);
    }

    protected SuspendableActivity(PhaserRegModeImpl prm, String name) {
        this(Collections.singletonList(prm), name);
    }

    protected SuspendableActivity(List<PhaserRegModeImpl> phaserRegModes, String name) {
        super(name);
        this.wrapperTask = new RunnableTask(this.invocationStrategy, this);
        this.phaserManager = new SuspendablePhaserManager(this, phaserRegModes);
        this.initializeActivity();
    }

    private void initializeActivity() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, "Activity: initializing " + this);
        }
        this.registerPhasers();
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            this.setResumeTime();
        }
    }

    @Override
    protected void finalizeTerminationCleanup() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            ((Place)Runtime.here()).maxCritPathOps(this.getCritPathOps());
            ((Place)Runtime.here()).addLocalOps(this.getTotalOps());
            ((Place)Runtime.here()).maxOverheads(this.getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                this.updateIdealTime();
                ((Place)Runtime.here()).addUnblockedTime(this.getTotalUnblockedTime());
                ((Place)Runtime.here()).maxCritPathTime(this.getCritPathTime());
            }
        }
        this.deregisterPhasers();
        if (Report.should_report("activity", 5)) {
            Report.report(5, Thread.currentThread() + " " + this + " drops phasers, has rootNode_ " + this.rootNode_);
        }
    }

    @Override
    protected SuspendableFinishState newFinishState() {
        return new SuspendableFinishState(this);
    }

    @Override
    protected void prepareToRunInFinish() {
        this.invocationStrategy = SuspendableInvocationStrategy.ASYNC_IN_FINISH;
        this.wrapperTask = new RunnableTask(this.invocationStrategy, this);
    }

    @Override
    protected WshFuture initializeFuture() {
        WshFuture wshFuture;
        this.future = wshFuture = WshCooperativeRuntime.createFuture();
        return wshFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.prepareToRun();
        try {
            this.restoreExecutionStats();
            this.wrapperTask.resumeExecution();
            this.processPauseReason(this.wrapperTask.getPauseReason());
        }
        catch (Throwable th) {
            this.success = false;
            if (th instanceof Error) {
                throw (Error)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
        }
        finally {
            if (this.wrapperTask.isDone()) {
                this.cleanupAfterRun();
            }
        }
    }

    private void prepareToRun() {
        PoolRunner activityRunner = (PoolRunner)((Object)Thread.currentThread());
        if (Report.should_report("activity", 5)) {
            Report.report(5, activityRunner + " is running " + this);
        }
        activityRunner.setActivity(this);
        activityRunner.setPlace(this.getPlace());
    }

    private void processPauseReason(PauseReason pauseReason) throws Throwable {
        Object exitReason;
        if (pauseReason instanceof DataDrivenPauseReason) {
            DataDrivenControl<Object> ddc = ((DataDrivenPauseReason)pauseReason).getDdc();
            ddc.addResumable(new ResumableTask(this));
            this.storeExecutionStats();
        } else if (pauseReason instanceof TaskDoneReason && (exitReason = ((TaskDoneReason)pauseReason).getExitReason()) instanceof Throwable) {
            throw (Throwable)exitReason;
        }
    }

    private void cleanupAfterRun() {
        if (this.waitList != null) {
            this.waitList.clear();
        }
        this.setFinished();
    }

    public abstract void runHjTask() throws Pausable;

    public void runHjTask(Fiber fiber) {
        Task.errNotWoven();
    }

    public void stopFinish(Fiber fiber) throws Pausable {
        SuspendableFinishState suspendableFinishState;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendableFinishState = (SuspendableFinishState)fiber.getCallee();
                break;
            }
            case 0: {
                this.preWaitForFinishProcessing();
                suspendableFinishState = (SuspendableFinishState)this.finishState_;
            }
        }
        suspendableFinishState.waitForFinish(fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
        this.postWaitForFinishProcessing();
    }

    public void stopFinish() throws Pausable {
        Task.errNotWoven();
    }

    protected final void preWaitForFinishProcessing() {
        if (this.phaserManager != null) {
            SuspendableRawPhaser.dropAllPhasers((SuspendableRawPhaser[])this.finishState_.getPhasers(new SuspendableRawPhaser[0]), this);
        }
        if (Report.should_report("activity", 5)) {
            Report.report(5, this + " enters stopfinish ");
        }
    }

    protected final void storeExecutionStats() {
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            this.updateIdealTime();
        }
    }

    protected final void restoreExecutionStats() {
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            this.setResumeTime();
        }
    }

    protected SuspendablePhaserManager phaserManager() {
        return this.phaserManager;
    }

    protected int getSigPhase(PhaserAbst ph) {
        return this.phaserManager.getSigPhase(ph);
    }

    protected int getWaitPhase(PhaserAbst ph) {
        return this.phaserManager.getWaitPhase(ph);
    }

    public void doNext(Fiber fiber) throws Pausable {
        SuspendablePhaserManager suspendablePhaserManager;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendablePhaserManager = (SuspendablePhaserManager)fiber.getCallee();
                break;
            }
            case 0: {
                suspendablePhaserManager = this.phaserManager;
            }
        }
        suspendablePhaserManager.doNext(fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public void doNext() throws Pausable {
        Task.errNotWoven();
    }

    /*
     * WARNING - void declaration
     */
    public int doNext1(String string, Fiber fiber) throws Pausable {
        String string2;
        SuspendablePhaserManager suspendablePhaserManager;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendablePhaserManager = (SuspendablePhaserManager)fiber.getCallee();
                string2 = null;
                break;
            }
            case 0: {
                void loc;
                suspendablePhaserManager = this.phaserManager;
                string2 = loc;
            }
        }
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return 0;
            }
            case 3: {
                return 0;
            }
        }
        return suspendablePhaserManager.doNextSinglePhase1(string2, fiber.down());
    }

    public int doNext1(String string) throws Pausable {
        Task.errNotWoven();
        return 0;
    }

    public void doNext2(Fiber fiber) throws Pausable {
        SuspendablePhaserManager suspendablePhaserManager;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendablePhaserManager = (SuspendablePhaserManager)fiber.getCallee();
                break;
            }
            case 0: {
                suspendablePhaserManager = this.phaserManager;
            }
        }
        suspendablePhaserManager.doNextSinglePhase2(fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public void doNext2() throws Pausable {
        Task.errNotWoven();
    }

    public void doSignal() {
        this.phaserManager.doSignal();
    }

    public void doWait(Fiber fiber) throws Pausable {
        SuspendablePhaserManager suspendablePhaserManager;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendablePhaserManager = (SuspendablePhaserManager)fiber.getCallee();
                break;
            }
            case 0: {
                suspendablePhaserManager = this.phaserManager;
            }
        }
        suspendablePhaserManager.doWait(fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public void doWait() throws Pausable {
        Task.errNotWoven();
    }

    protected void doSignal(SuspendableRawPhaser ph) {
        this.phaserManager.doSignal(ph);
    }

    /*
     * WARNING - void declaration
     */
    protected void doWait(SuspendableRawPhaser suspendableRawPhaser, Fiber fiber) throws Pausable {
        SuspendableRawPhaser suspendableRawPhaser2;
        SuspendablePhaserManager suspendablePhaserManager;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendablePhaserManager = (SuspendablePhaserManager)fiber.getCallee();
                suspendableRawPhaser2 = null;
                break;
            }
            case 0: {
                void ph;
                suspendablePhaserManager = this.phaserManager;
                suspendableRawPhaser2 = ph;
            }
        }
        suspendablePhaserManager.doWait(suspendableRawPhaser2, fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    protected void doWait(SuspendableRawPhaser suspendableRawPhaser) throws Pausable {
        Task.errNotWoven();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean doWaitForNextSinglePhase1(String string, SuspendableRawPhaser suspendableRawPhaser, Fiber fiber) throws Pausable {
        SuspendableRawPhaser suspendableRawPhaser2;
        String string2;
        SuspendablePhaserManager suspendablePhaserManager;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendablePhaserManager = (SuspendablePhaserManager)fiber.getCallee();
                string2 = null;
                suspendableRawPhaser2 = null;
                break;
            }
            case 0: {
                void ph;
                void loc;
                suspendablePhaserManager = this.phaserManager;
                string2 = loc;
                suspendableRawPhaser2 = ph;
            }
        }
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return false;
            }
            case 3: {
                return false;
            }
        }
        return suspendablePhaserManager.doWaitForNextSinglePhase1(string2, suspendableRawPhaser2, fiber.down());
    }

    protected boolean doWaitForNextSinglePhase1(String string, SuspendableRawPhaser suspendableRawPhaser) throws Pausable {
        Task.errNotWoven();
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void doWaitForNextSinglePhase2(SuspendableRawPhaser suspendableRawPhaser, Fiber fiber) throws Pausable {
        SuspendableRawPhaser suspendableRawPhaser2;
        SuspendablePhaserManager suspendablePhaserManager;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendablePhaserManager = (SuspendablePhaserManager)fiber.getCallee();
                suspendableRawPhaser2 = null;
                break;
            }
            case 0: {
                void ph;
                suspendablePhaserManager = this.phaserManager;
                suspendableRawPhaser2 = ph;
            }
        }
        suspendablePhaserManager.doWaitForNextSinglePhase2(suspendableRawPhaser2, fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    protected void doWaitForNextSinglePhase2(SuspendableRawPhaser suspendableRawPhaser) throws Pausable {
        Task.errNotWoven();
    }

    public List<PhaserRegModeImpl> getPhaserRegModeList() {
        return this.phaserManager.getPhaserRegModeList();
    }

    protected boolean dropPhaser(PhaserAbst ph) {
        return this.phaserManager.dropPhaser(ph);
    }

    protected void deregisterPhasers() {
        this.phaserManager.deregisterPhasers();
    }

    protected boolean registered(PhaserAbst ph) {
        return this.phaserManager.registered(ph);
    }

    protected void register(PhaserRegModeImpl prm) {
        this.phaserManager.registerPhaser(prm);
    }

    public void registerPhasers() {
        this.phaserManager.registerPhasers();
    }

    protected PhaserAbst.Mode phaserMode(PhaserAbst ph) {
        return this.phaserManager.phaserMode(ph);
    }

    protected void resume(PhaserAbst ph, boolean newValue) {
        this.phaserManager.resume(ph, newValue);
    }

    protected boolean resumed(PhaserAbst ph) {
        return this.phaserManager.resumed(ph);
    }
}

