/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.cooperative;

import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.FinishState;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.cooperative.DataDrivenControl;
import hj.runtime.wsh.cooperative.DataDrivenPauseReason;
import hj.runtime.wsh.cooperative.SuspendableActivity;
import hj.runtime.wsh.cooperative.WshCooperativeRuntime;
import java.util.concurrent.atomic.AtomicInteger;
import kilim.Fiber;
import kilim.Pausable;
import kilim.State;
import kilim.Task;

public class SuspendableFinishState
extends FinishState {
    private final AtomicInteger counter = new AtomicInteger(1);
    private final DataDrivenControl<Object> ddc = new DataDrivenControl(false);
    private final String spawningTaskName;
    private long critPathOps = 0L;
    private long overheads = 0L;
    private long curIdealTime = 0L;
    public static final boolean $isWoven = true;

    public SuspendableFinishState(Activity activity2) {
        this.spawningTaskName = activity2.myName();
    }

    public void waitForFinish(Fiber fiber) throws Pausable {
        block10: {
            DataDrivenPauseReason dataDrivenPauseReason;
            Fiber fiber2 = fiber;
            switch (fiber2.pc) {
                default: {
                    fiber2.wrongPC();
                }
                case 1: {
                    boolean bl = false;
                    dataDrivenPauseReason = null;
                    break;
                }
                case 0: {
                    int activeTasks = this.counter.decrementAndGet();
                    if (activeTasks <= 0) break block10;
                    dataDrivenPauseReason = new DataDrivenPauseReason(this.ddc);
                }
            }
            Task.pause(dataDrivenPauseReason, (Fiber)fiber2.down());
            switch (fiber2.up()) {
                case 2: {
                    State state = new State();
                    state.self = this;
                    state.pc = 1;
                    fiber2.setState(state);
                    return;
                }
                case 3: {
                    return;
                }
            }
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            SuspendableActivity currentActivity = (SuspendableActivity)WshCooperativeRuntime.getCurrentActivity();
            currentActivity.maxCritPathOps(this.getCritPathOps());
            currentActivity.maxOverheads(this.getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                currentActivity.maxCritPathTime(this.getIdealTime());
                currentActivity.setResumeTime();
            }
        }
    }

    public void waitForFinish() throws Pausable {
        Task.errNotWoven();
    }

    public void notifySubActivitySpawn() {
        this.counter.incrementAndGet();
        if (Report.should_report("activity", 5)) {
            Report.report(5, " updating " + this.toString());
        }
    }

    public void notifySubActivityTermination() {
        int activeTasks;
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            SuspendableActivity currentActivity = (SuspendableActivity)WshCooperativeRuntime.getCurrentActivity();
            this.maxCritPathOps(currentActivity.getCritPathOps());
            this.maxOverheads(currentActivity.getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                this.maxIdealTime(currentActivity.getCritPathTime());
            }
        }
        if ((activeTasks = this.counter.decrementAndGet()) == 0) {
            this.ddc.setValue(Boolean.TRUE);
        } else if (activeTasks < 0) {
            throw new IllegalStateException("active child activity count is negative!");
        }
    }

    public synchronized String toString() {
        int activeTasks = this.counter.get();
        return "<SuspendableFinishState#" + this.hashCode() + " from " + this.spawningTaskName + " " + activeTasks + "," + this.finish_ + ">";
    }

    public synchronized void maxCritPathOps(long n) {
        this.critPathOps = Math.max(this.critPathOps, n);
    }

    public long getCritPathOps() {
        return this.critPathOps;
    }

    public synchronized void maxOverheads(long n) {
        this.overheads = Math.max(this.overheads, n);
    }

    public long getOverheads() {
        return this.overheads;
    }

    public synchronized void maxIdealTime(long t) {
        this.curIdealTime = Math.max(this.curIdealTime, t);
    }

    public long getIdealTime() {
        return this.curIdealTime;
    }
}

