/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.cooperative;

import hj.lang.PhaserAbst;
import hj.lang.PhaserException;
import hj.lang.accumulator;
import hj.lang.phaserMode;
import hj.runtime.wsh.cooperative.Accumulator;
import hj.runtime.wsh.cooperative.DataDrivenControl;
import hj.runtime.wsh.cooperative.SuspendableActivity;
import hj.runtime.wsh.cooperative.WshCooperativeRuntime;
import hj.runtime.wsh.phaser.PhaserRegModeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kilim.Fiber;
import kilim.Pausable;
import kilim.State;
import kilim.Task;

public class SuspendableRawPhaser
extends PhaserAbst {
    private static final int BUSY_WAIT_COUNT_INIT = 100000;
    private static final AtomicInteger nextId_ = new AtomicInteger(-1);
    private final SuspendableActivity parent = WshCooperativeRuntime.getCurrentWshActivity();
    private final int id = nextId_.incrementAndGet();
    private final String name;
    private final PhaserAbst.Mode phaserMode;
    private ConcurrentHashMap<Integer, PhaseState> phaseMap;
    private List<Accumulator.AccumulatorAdapter> accumulators;
    public static final boolean $isWoven = true;

    public static void dropAllPhasers(SuspendableRawPhaser[] phasers, SuspendableActivity suspendableActivity) {
        for (SuspendableRawPhaser ph : phasers) {
            if (!ph.registered()) continue;
            ph.drop();
            suspendableActivity.dropPhaser(ph);
        }
    }

    public SuspendableRawPhaser() {
        this(PhaserAbst.defaultMode);
    }

    public SuspendableRawPhaser(PhaserAbst.Mode phaserMode2) {
        this(phaserMode2, 100000);
    }

    public SuspendableRawPhaser(PhaserAbst.Mode phaserMode2, int busyWaitCount) {
        this("", phaserMode2, busyWaitCount);
    }

    public SuspendableRawPhaser(String phName, PhaserAbst.Mode phMode, int busyWaitCount) {
        this.name = phName;
        this.phaserMode = phMode;
        this.phaseMap = new ConcurrentHashMap();
        this.accumulators = new ArrayList<Accumulator.AccumulatorAdapter>();
        this.parent.register(new PhaserRegModeImpl(this, this.phaserMode));
        this.parent.registerPhaserToIEF(this);
    }

    public int getSigPhase() {
        SuspendableActivity currentActivity = WshCooperativeRuntime.getCurrentWshActivity();
        return currentActivity.getSigPhase(this);
    }

    public int getWaitPhase() {
        SuspendableActivity currentActivity = WshCooperativeRuntime.getCurrentWshActivity();
        return currentActivity.getWaitPhase(this);
    }

    public phaserMode getPhaserMode() {
        return PhaserAbst.rm2pm(this.phaserMode);
    }

    public void doNext() {
        throw new PhaserException("runtime should call doCooperativeNext() instead!");
    }

    public void doCooperativeNext(Fiber fiber) throws Pausable {
        SuspendableActivity suspendableActivity;
        SuspendableRawPhaser suspendableRawPhaser;
        Fiber fiber2 = fiber;
        switch (fiber2.pc) {
            default: {
                fiber2.wrongPC();
            }
            case 1: {
                fiber = null;
                suspendableRawPhaser = this;
                suspendableActivity = null;
                break;
            }
            case 0: {
                SuspendableActivity currentActivity = WshCooperativeRuntime.getCurrentWshActivity();
                suspendableRawPhaser = this;
                suspendableActivity = currentActivity;
            }
        }
        suspendableRawPhaser.doCooperativeNext(suspendableActivity, fiber2.down());
        switch (fiber2.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber2.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public void doCooperativeNext() throws Pausable {
        Task.errNotWoven();
    }

    /*
     * WARNING - void declaration
     */
    private void doCooperativeNext(SuspendableActivity suspendableActivity, Fiber fiber) throws Pausable {
        SuspendableActivity suspendableActivity2;
        SuspendableRawPhaser suspendableRawPhaser;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendableRawPhaser = this;
                suspendableActivity2 = null;
                break;
            }
            case 0: {
                void activity2;
                if (!activity2.registered(this)) {
                    throw new PhaserException("Activity cannot do next as phaser isn't registered!");
                }
                this.doSignal((SuspendableActivity)activity2);
                suspendableRawPhaser = this;
                suspendableActivity2 = activity2;
            }
        }
        suspendableRawPhaser.doCooperativeWait(suspendableActivity2, fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    private void doCooperativeNext(SuspendableActivity suspendableActivity) throws Pausable {
        Task.errNotWoven();
    }

    public void signal() {
        this.doSignal(WshCooperativeRuntime.getCurrentWshActivity());
    }

    private void doSignal(SuspendableActivity activity2) {
        if (!activity2.registered(this)) {
            throw new PhaserException("Activity cannot signal as it is not registered on this phaser!");
        }
        PhaserAbst.Mode phMode = activity2.phaserMode(this);
        if (phMode == PhaserAbst.Mode.WAIT) {
            return;
        }
        activity2.doSignal(this);
    }

    protected PhaseState getPhaseState(int phase) {
        Integer phaseInt = phase;
        PhaseState phaseState = this.phaseMap.get(phaseInt);
        if (phaseState == null) {
            this.phaseMap.putIfAbsent(phaseInt, new PhaseState(this, phase));
            phaseState = this.phaseMap.get(phaseInt);
        }
        return phaseState;
    }

    public void doWait() {
        throw new IllegalStateException("runtime should call doCooperativeWait() instead!");
    }

    public void doCooperativeWait(Fiber fiber) throws Pausable {
        SuspendableActivity suspendableActivity;
        SuspendableRawPhaser suspendableRawPhaser;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendableRawPhaser = this;
                suspendableActivity = null;
                break;
            }
            case 0: {
                suspendableRawPhaser = this;
                suspendableActivity = WshCooperativeRuntime.getCurrentWshActivity();
            }
        }
        suspendableRawPhaser.doCooperativeWait(suspendableActivity, fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public void doCooperativeWait() throws Pausable {
        Task.errNotWoven();
    }

    /*
     * WARNING - void declaration
     */
    private void doCooperativeWait(SuspendableActivity suspendableActivity, Fiber fiber) throws Pausable {
        SuspendableRawPhaser suspendableRawPhaser;
        SuspendableActivity suspendableActivity2;
        Fiber fiber2 = fiber;
        switch (fiber2.pc) {
            default: {
                fiber2.wrongPC();
            }
            case 1: {
                fiber = null;
                suspendableActivity2 = (SuspendableActivity)fiber2.getCallee();
                suspendableRawPhaser = null;
                break;
            }
            case 0: {
                void activity2;
                if (!activity2.registered(this)) {
                    throw new PhaserException("Activity cannot wait as it is not registered on this phaser!");
                }
                PhaserAbst.Mode phMode = activity2.phaserMode(this);
                if (phMode != PhaserAbst.Mode.WAIT && !activity2.resumed(this)) {
                    throw new PhaserException("Signal is necessary before wait.");
                }
                if (phMode == PhaserAbst.Mode.SIG) {
                    return;
                }
                suspendableActivity2 = activity2;
                suspendableRawPhaser = this;
            }
        }
        suspendableActivity2.doWait(suspendableRawPhaser, fiber2.down());
        switch (fiber2.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber2.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    private void doCooperativeWait(SuspendableActivity suspendableActivity) throws Pausable {
        Task.errNotWoven();
    }

    public boolean doWaitSingle1() {
        return this.doWaitSingle1("foo");
    }

    public boolean doWaitSingle1(String loc) {
        throw new UnsupportedOperationException("doWaitSingle1(" + loc + ") not supported in cooperative runtime");
    }

    /*
     * WARNING - void declaration
     */
    public boolean doCooperativeWaitSingle1(String string, Fiber fiber) throws Pausable {
        SuspendableActivity suspendableActivity;
        String string2;
        SuspendableRawPhaser suspendableRawPhaser;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendableRawPhaser = this;
                string2 = null;
                suspendableActivity = null;
                break;
            }
            case 0: {
                void loc;
                suspendableRawPhaser = this;
                string2 = loc;
                suspendableActivity = WshCooperativeRuntime.getCurrentWshActivity();
            }
        }
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return false;
            }
            case 3: {
                return false;
            }
        }
        return suspendableRawPhaser.doCooperativeWaitSingle1(string2, suspendableActivity, fiber.down());
    }

    public boolean doCooperativeWaitSingle1(String string) throws Pausable {
        Task.errNotWoven();
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean doCooperativeWaitSingle1(String string, SuspendableActivity suspendableActivity, Fiber fiber) throws Pausable {
        SuspendableRawPhaser suspendableRawPhaser;
        String string2;
        SuspendableActivity suspendableActivity2;
        Fiber fiber2 = fiber;
        switch (fiber2.pc) {
            default: {
                fiber2.wrongPC();
            }
            case 1: {
                fiber = null;
                suspendableActivity2 = (SuspendableActivity)fiber2.getCallee();
                string2 = null;
                suspendableRawPhaser = null;
                break;
            }
            case 0: {
                void loc;
                void activity2;
                if (!activity2.registered(this)) {
                    throw new PhaserException("Activity is not registered on this phaser!");
                }
                PhaserAbst.Mode phMode = activity2.phaserMode(this);
                if (phMode != PhaserAbst.Mode.SIG_WAIT_SINGLE) {
                    throw new PhaserException("Single statement isn't permitted for activity in " + (Object)((Object)phMode) + ".");
                }
                if (!activity2.resumed(this)) {
                    throw new PhaserException("Signal is necessary before wait.");
                }
                suspendableActivity2 = activity2;
                string2 = loc;
                suspendableRawPhaser = this;
            }
        }
        switch (fiber2.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber2.setState(state);
                return false;
            }
            case 3: {
                return false;
            }
        }
        return suspendableActivity2.doWaitForNextSinglePhase1(string2, suspendableRawPhaser, fiber2.down());
    }

    private boolean doCooperativeWaitSingle1(String string, SuspendableActivity suspendableActivity) throws Pausable {
        Task.errNotWoven();
        return false;
    }

    public void doWaitSingle2() {
        throw new UnsupportedOperationException("doWaitSingle2() not supported in cooperative runtime");
    }

    public void doCooperativeWaitSingle2(Fiber fiber) throws Pausable {
        SuspendableActivity suspendableActivity;
        SuspendableRawPhaser suspendableRawPhaser;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                suspendableRawPhaser = this;
                suspendableActivity = null;
                break;
            }
            case 0: {
                suspendableRawPhaser = this;
                suspendableActivity = WshCooperativeRuntime.getCurrentWshActivity();
            }
        }
        suspendableRawPhaser.doCooperativeWaitSingle2(suspendableActivity, fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public void doCooperativeWaitSingle2() throws Pausable {
        Task.errNotWoven();
    }

    /*
     * WARNING - void declaration
     */
    private void doCooperativeWaitSingle2(SuspendableActivity suspendableActivity, Fiber fiber) throws Pausable {
        SuspendableRawPhaser suspendableRawPhaser;
        SuspendableActivity suspendableActivity2;
        Fiber fiber2 = fiber;
        switch (fiber2.pc) {
            default: {
                fiber2.wrongPC();
            }
            case 1: {
                fiber = null;
                suspendableActivity2 = (SuspendableActivity)fiber2.getCallee();
                suspendableRawPhaser = null;
                break;
            }
            case 0: {
                void activity2;
                if (!activity2.registered(this)) {
                    throw new PhaserException("Activity is not registered on this phaser!");
                }
                PhaserAbst.Mode phMode = activity2.phaserMode(this);
                if (phMode != PhaserAbst.Mode.SIG_WAIT_SINGLE) {
                    throw new PhaserException("Single statement isn't permitted for activity in " + (Object)((Object)phMode) + ".");
                }
                suspendableActivity2 = activity2;
                suspendableRawPhaser = this;
            }
        }
        suspendableActivity2.doWaitForNextSinglePhase2(suspendableRawPhaser, fiber2.down());
        switch (fiber2.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber2.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    private void doCooperativeWaitSingle2(SuspendableActivity suspendableActivity) throws Pausable {
        Task.errNotWoven();
    }

    public void drop() {
        PhaseState phaseState;
        SuspendableActivity currentActivity = WshCooperativeRuntime.getCurrentWshActivity();
        PhaserAbst.Mode phMode = currentActivity.phaserMode(this);
        if (phMode != PhaserAbst.Mode.WAIT) {
            this.doSignal(currentActivity);
            int sigPhase = currentActivity.getSigPhase(this);
            phaseState = this.getPhaseState(sigPhase);
            phaseState.dropSignaller(currentActivity);
        }
        if (phMode != PhaserAbst.Mode.SIG) {
            int waitPhase = currentActivity.getWaitPhase(this);
            phaseState = this.getPhaseState(waitPhase);
            phaseState.dropWaiter(currentActivity);
        }
        currentActivity.dropPhaser(this);
    }

    public boolean dropped() {
        return !this.registered();
    }

    public boolean registered() {
        SuspendableActivity currentActivity = WshCooperativeRuntime.getCurrentWshActivity();
        return currentActivity.registered(this);
    }

    protected void register(SuspendableActivity activity2, PhaserAbst.Mode mode) {
        SuspendableActivity authorizer = WshCooperativeRuntime.getCurrentWshActivity();
        if (!authorizer.registered(this)) {
            throw new PhaserException("TRANSMIT mode isn't permitted.");
        }
        PhaserAbst.Mode authMode = authorizer.phaserMode(this);
        if (mode == PhaserAbst.Mode.SIG_WAIT_SINGLE && authMode != PhaserAbst.Mode.SIG_WAIT_SINGLE || authMode == PhaserAbst.Mode.SIG && mode != PhaserAbst.Mode.SIG || authMode == PhaserAbst.Mode.WAIT && mode != PhaserAbst.Mode.WAIT) {
            throw new PhaserException("Capability model violation: Parent mode = " + (Object)((Object)authMode) + ", child mode = " + (Object)((Object)mode) + ".");
        }
        if (this.quiescent(authorizer)) {
            throw new PhaserException(authorizer + "is not active on " + this + "; cannot transmit.");
        }
        if (mode != PhaserAbst.Mode.WAIT) {
            int sigPhase = authorizer.getSigPhase(this);
            this.getPhaseState(sigPhase).addSignaller(activity2);
        }
        if (mode != PhaserAbst.Mode.SIG) {
            int waitPhase = authorizer.getWaitPhase(this);
            this.getPhaseState(waitPhase).addWaiter(activity2);
        }
    }

    public boolean quiescent() {
        SuspendableActivity currentActivity = WshCooperativeRuntime.getCurrentWshActivity();
        return this.quiescent(currentActivity);
    }

    private boolean quiescent(SuspendableActivity currentActivity) {
        PhaserAbst.Mode phMode = currentActivity.phaserMode(this);
        return currentActivity.registered(this) && currentActivity.resumed(this) && (phMode == PhaserAbst.Mode.SIG_WAIT || phMode == PhaserAbst.Mode.SIG_WAIT_SINGLE);
    }

    public void resume() {
        throw new UnsupportedOperationException("resume() not supported in cooperative runtime");
    }

    public void signalWithLastArray(accumulator acc, int[] array) {
        throw new UnsupportedOperationException("signalWithLastArray(" + acc + "," + Arrays.toString(array) + "): " + "accumulators not supported in cooperative runtime");
    }

    public void signalWithLastArray(accumulator acc, double[] array) {
        throw new UnsupportedOperationException("signalWithLastArray(" + acc + "," + Arrays.toString(array) + "): " + "accumulators not supported in cooperative runtime");
    }

    public void setLastArray(accumulator acc, int[] array) {
        throw new UnsupportedOperationException("setLastArray(" + acc + "," + Arrays.toString(array) + "): " + "accumulators not supported in cooperative runtime");
    }

    public void setLastArray(accumulator acc, double[] array) {
        throw new UnsupportedOperationException("setLastArray(" + acc + "," + Arrays.toString(array) + "): " + "accumulators not supported in cooperative runtime");
    }

    public int getNumChildrenOfSubPhaser(int idx) {
        throw new UnsupportedOperationException("getNumChildrenOfSubPhaser(" + idx + "): " + "tree phasers are not supported in the cooperative runtime");
    }

    public int getLeafSubIdx() {
        throw new UnsupportedOperationException("getLeafSubIdx(): tree phasers are not supported in the cooperative runtime");
    }

    protected void registerAccumulator(Accumulator.AccumulatorAdapter accumulatorAdapter) {
        this.accumulators.add(accumulatorAdapter);
    }

    private void updateAccumulators(int phase) {
        for (Accumulator.AccumulatorAdapter accumulatorAdapter : this.accumulators) {
            accumulatorAdapter.updateResult(phase);
        }
    }

    public String toString() {
        return "SuspendableRawPhaser{id=" + this.id + ", name='" + this.name + '\'' + '}';
    }

    public String toDetailedString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        ArrayList keys = new ArrayList(this.phaseMap.keySet());
        Collections.sort(keys);
        for (Integer phase : keys) {
            PhaseState phaseState = this.phaseMap.get(phase);
            sb.append("\n  ===> ").append(phaseState.toString());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PhaseState {
        private final SuspendableRawPhaser parent;
        private final int phase;
        private final AtomicBoolean active;
        private final AtomicInteger numRegisteredSignallers;
        private final AtomicInteger numSignalsReceived;
        private final AtomicInteger numRegisteredWaiters;
        private final AtomicInteger numWaitsReceived;
        private final AtomicReference<String> nextSingleFlag;
        private final AtomicBoolean masterArrived;
        private final DataDrivenControl<Object> signalDdc;
        private final DataDrivenControl<Object> waitDdc;

        private PhaseState(SuspendableRawPhaser parent, int phase) {
            this.parent = parent;
            this.phase = phase;
            this.active = new AtomicBoolean(phase == 0);
            this.numRegisteredSignallers = new AtomicInteger(0);
            this.numSignalsReceived = new AtomicInteger(0);
            this.numRegisteredWaiters = new AtomicInteger(0);
            this.numWaitsReceived = new AtomicInteger(0);
            this.nextSingleFlag = new AtomicReference<Object>(null);
            this.masterArrived = new AtomicBoolean(false);
            this.signalDdc = new DataDrivenControl(false);
            this.waitDdc = new DataDrivenControl(false);
        }

        protected void activate(int srcPhase) {
            boolean success;
            if (srcPhase == this.phase - 1 && (success = this.active.compareAndSet(false, true))) {
                this.checkProgress(srcPhase);
            }
        }

        protected void addSignaller(SuspendableActivity activity2) {
            this.numRegisteredSignallers.incrementAndGet();
        }

        protected void dropSignaller(SuspendableActivity activity2) {
            this.numSignalsReceived.incrementAndGet();
            this.checkProgress(this.phase);
        }

        protected void doSignal() {
            this.numSignalsReceived.incrementAndGet();
            this.checkProgress(this.phase);
        }

        protected void addWaiter(SuspendableActivity activity2) {
            this.numRegisteredWaiters.incrementAndGet();
        }

        protected void dropWaiter(SuspendableActivity activity2) {
            this.numWaitsReceived.incrementAndGet();
            this.checkProgress(this.phase);
        }

        protected void doWait() {
            this.numWaitsReceived.incrementAndGet();
            this.checkProgress(this.phase);
        }

        protected boolean doWaitForNextSinglePhase1(String loc) {
            this.numWaitsReceived.incrementAndGet();
            boolean master = this.nextSingleFlag.compareAndSet(null, loc);
            if (!loc.equals(this.nextSingleFlag.get())) {
                throw new PhaserException("Location of single statement doesn't match.");
            }
            this.checkProgress(this.phase);
            return master;
        }

        protected void doWaitForNextSinglePhase2(boolean singleMaster) {
            if (singleMaster) {
                this.masterArrived.set(true);
            }
            this.checkProgress(this.phase);
        }

        private void checkProgress(int srcPhase) {
            if (!this.active.get()) {
                return;
            }
            if (this.phaseSignalsComplete()) {
                this.parent.updateAccumulators(this.phase);
                boolean success = this.signalDdc.setValue(Boolean.TRUE);
                if (success) {
                    int nextPhase = this.phase + 1;
                    this.parent.getPhaseState(nextPhase).activate(srcPhase);
                }
            }
            if (this.masterArrived.get() && this.phaseWaitsComplete()) {
                this.waitDdc.setValue(Boolean.TRUE);
            }
        }

        private boolean phaseSignalsComplete() {
            int signalsReceived;
            int signalsExpected = this.numRegisteredSignallers.get();
            return signalsExpected == (signalsReceived = this.numSignalsReceived.get());
        }

        private boolean phaseWaitsComplete() {
            int waitsExpected;
            int waitsReceived = this.numWaitsReceived.get();
            return waitsReceived == (waitsExpected = this.numRegisteredWaiters.get());
        }

        protected DataDrivenControl<Object> signalDataDrivenControl() {
            return this.signalDdc;
        }

        protected DataDrivenControl<Object> waitDataDrivenControl() {
            return this.waitDdc;
        }

        public String toString() {
            return "PhaseState{Phaser-" + this.parent.id + ", phase=" + this.phase + ", signallers=" + this.numRegisteredSignallers + ", sigs received=" + this.numSignalsReceived + ", signal_ddc.avail=" + this.signalDdc.valueAvailable() + ", waiters=" + this.numRegisteredWaiters + ", waits received=" + this.numWaitsReceived + ", wait_ddc.avail=" + this.waitDdc.valueAvailable() + ", active=" + this.active + '}';
        }
    }
}

