/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.cooperative;

import hj.lang.PhaserAbst;
import hj.lang.PhaserException;
import hj.lang.accumulator;
import hj.lang.phaser;
import hj.lang.phaserMode;
import hj.runtime.wsh.WshConfiguration;
import hj.runtime.wsh.WshFuture;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.cooperative.Accumulator;
import hj.runtime.wsh.cooperative.CooperativeIsolationManager;
import hj.runtime.wsh.cooperative.SuspendableActivity;
import hj.runtime.wsh.cooperative.SuspendableFuture;
import hj.runtime.wsh.cooperative.SuspendableRawPhaser;
import hj.runtime.wsh.finishAccumulator.FinishAccumulator;
import kilim.Fiber;
import kilim.Pausable;
import kilim.State;
import kilim.Task;

public class WshCooperativeRuntime
extends WshRuntime_c {
    private static WshCooperativeRuntime wshCooperativeRuntime;
    public static final boolean $isWoven = true;

    public WshCooperativeRuntime() {
        wshCooperativeRuntime = this;
    }

    public String getRuntimeType() {
        return "work-sharing [cooperative]" + (WshConfiguration.FJ ? " (FJ)" : "");
    }

    public static SuspendableActivity getCurrentWshActivity() {
        return (SuspendableActivity)wshCooperativeRuntime.currentActivity();
    }

    public static WshFuture createFuture() {
        return new SuspendableFuture();
    }

    public static void startIsolationCooperative(Fiber fiber) throws Pausable {
        CooperativeIsolationManager cooperativeIsolationManager;
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                cooperativeIsolationManager = (CooperativeIsolationManager)fiber.getCallee();
                break;
            }
            case 0: {
                cooperativeIsolationManager = CooperativeIsolationManager.ONLY;
            }
        }
        cooperativeIsolationManager.startIsolation(fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public static void startIsolationCooperative() throws Pausable {
        Task.errNotWoven();
    }

    public static void stopIsolationCooperative() {
        CooperativeIsolationManager.ONLY.stopIsolation();
    }

    protected accumulator.factory createAccumulatorFactory() {
        return new accumulator.factory(){

            public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph) {
                return Accumulator.newAccumulator(ope, type, ph);
            }

            public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy) {
                if (isLazy) {
                    throw new UnsupportedOperationException("Lazy accumulators are not supported in the cooperative runtime!");
                }
                return this.accumulator(ope, type, ph);
            }

            public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy, int arrsize) {
                if (isLazy || arrsize != 1) {
                    throw new UnsupportedOperationException("Lazy/Bounded accumulators are not supported in the cooperative runtime!");
                }
                return this.accumulator(ope, type, ph);
            }

            public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy, int arrsize, int func, double delay, double coef) {
                throw new UnsupportedOperationException("Advanced accumulators are not supported in the cooperative runtime!");
            }

            public accumulator accumulator(accumulator.Operator ope, Class type) {
                return new FinishAccumulator(ope, type);
            }

            public accumulator accumulator(accumulator.Operator ope, Class type, boolean isLazy) {
                return new FinishAccumulator(ope, type, isLazy);
            }

            public accumulator accumulator(accumulator.Operator ope, Class type, boolean isLazy, int func, double delay, double coef) {
                return new FinishAccumulator(ope, type, isLazy, func, delay, coef);
            }
        };
    }

    protected PhaserAbst.factory createPhaserFactory() {
        return new PhaserAbst.factory(){

            public PhaserAbst PhaserAbst() {
                return new SuspendableRawPhaser();
            }

            public PhaserAbst PhaserAbst(phaserMode mode) {
                return new SuspendableRawPhaser(PhaserAbst.pm2rm(mode));
            }

            public PhaserAbst PhaserAbst(String name, phaserMode mode, int busyWaitCount) {
                return new SuspendableRawPhaser(name, PhaserAbst.pm2rm(mode), busyWaitCount);
            }

            public PhaserAbst PhaserAbst(phaserMode mode, int numTiers, int numDegree) {
                System.err.println("tree phasers are not supported in the cooperative runtime, defaulting to simple phasers");
                return new SuspendableRawPhaser(PhaserAbst.pm2rm(mode));
            }

            public PhaserAbst PhaserAbst(phaserMode mode, int bound, PhaserAbst.Cycle cycle, int batchSize) {
                if (bound < 0) {
                    throw new PhaserException("bounded size must be greater or equal to 0");
                }
                System.err.println("bounded phasers are not supported in the cooperative runtime, defaulting to simple phasers");
                return new SuspendableRawPhaser(PhaserAbst.pm2rm(mode));
            }

            public PhaserAbst PhaserAbst(String name, phaserMode mode, int busyWaitCount, int numTiers, int numDegree) {
                System.err.println("tree phasers are not supported in the cooperative runtime, defaulting to simple phasers");
                return new SuspendableRawPhaser(name, PhaserAbst.pm2rm(mode), busyWaitCount);
            }

            public PhaserAbst PhaserAbst(String name, phaserMode mode, int busyWaitCount, int bound, PhaserAbst.Cycle cycle, int batchSize) {
                if (bound < 0) {
                    throw new PhaserException("bounded size must be greater or equal to 0");
                }
                System.err.println("bounded phasers are not supported in the cooperative runtime, defaulting to simple phasers");
                return new SuspendableRawPhaser(name, PhaserAbst.pm2rm(mode), busyWaitCount);
            }
        };
    }
}

