/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.finishAccumulator;

import java.util.concurrent.atomic.AtomicReference;

class AtomicDouble {
    private final AtomicReference<Double> atom;

    public AtomicDouble() {
        this.atom = new AtomicReference<Double>(new Double(0.0));
    }

    public AtomicDouble(double val) {
        this.atom = new AtomicReference<Double>(new Double(val));
    }

    public double get() {
        return this.atom.get();
    }

    public void set(double val) {
        this.atom.set(new Double(val));
    }

    public double addAndGet(double val) {
        double newVal;
        Double neo;
        Double cur;
        if (val == 0.0) {
            return this.get();
        }
        while (!this.atom.compareAndSet(cur = this.atom.get(), neo = new Double(newVal = cur + val))) {
        }
        return newVal;
    }

    public double mulAndGet(double val) {
        double newVal;
        Double neo;
        Double cur;
        if (val == 1.0) {
            return this.get();
        }
        while (!this.atom.compareAndSet(cur = this.atom.get(), neo = new Double(newVal = cur * val))) {
        }
        return newVal;
    }

    public double minAndGet(double val) {
        Double neo;
        Double cur;
        do {
            double v;
            if (!(val >= (v = (cur = this.atom.get()).doubleValue()))) continue;
            return v;
        } while (!this.atom.compareAndSet(cur, neo = new Double(val)));
        return val;
    }

    public double maxAndGet(double val) {
        Double neo;
        Double cur;
        do {
            double v;
            if (!(val <= (v = (cur = this.atom.get()).doubleValue()))) continue;
            return v;
        } while (!this.atom.compareAndSet(cur, neo = new Double(val)));
        return val;
    }
}

