/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.phaser;

import hj.lang.PhaserAbst;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.blocking.BlockingActivity;
import hj.runtime.wsh.phaser.PhaserImpl;
import hj.runtime.wsh.phaser.PhaserManager;
import hj.runtime.wsh.phaser.PhaserRegModeImpl;
import hj.runtime.wsh.phaser.SyncVar1;
import hj.runtime.wsh.phaser.SyncVar2;
import hj.runtime.wsh.phaser.accumulator.AccumCell;
import hj.runtime.wsh.phaser.accumulator.Accumulator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaserManagerImpl
implements PhaserManager {
    protected BlockingActivity activity;
    private PhaserRegModeImpl singlePhaserRegMode;
    private List<PhaserRegModeImpl> phaserRegModeList;
    public final HashMap<PhaserImpl, SyncVar1> syncVarMap1 = new HashMap();
    public final HashMap<PhaserImpl, SyncVar2> syncVarMap2 = new HashMap();
    public SyncVar1 sv1 = null;
    public SyncVar2 sv2 = null;
    public PhaserImpl singlePh = null;
    public int cnt = 0;
    public final HashMap<Accumulator, AccumCell> AccumCellMap = new HashMap();
    public AccumCell cell = null;
    public Accumulator acc = null;
    public int cnta = 0;
    public int tmpForDelay;
    public int round;
    public Random rand = null;
    public PhaserRegModeImpl phaserRegMode = null;
    public List<PhaserRegModeImpl> phaserRegModes = null;
    public List<PhaserImpl> childPhasers = null;
    public HashMap<BlockingActivity, List<PhaserRegModeImpl>> childActRegMap = null;
    public boolean hasAcyclicPhaser = false;

    public PhaserManagerImpl(BlockingActivity activity2) {
        this.activity = activity2;
    }

    public PhaserManagerImpl(BlockingActivity activity2, List<PhaserRegModeImpl> phaserRegModes) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, "adding phaserRegModes " + phaserRegModes + " to " + activity2);
        }
        this.phaserRegModeList = phaserRegModes;
        BlockingActivity a = (BlockingActivity)WshRuntime_c.getCurrentActivity();
        PhaserManager phm = a.getPhaserManager();
        phm.childActivityRegistration(activity2, phaserRegModes);
    }

    public PhaserManagerImpl(BlockingActivity activity2, PhaserRegModeImpl phaserRegMode2) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, "adding phaserRegMode " + phaserRegMode2 + " to " + activity2);
        }
        this.singlePhaserRegMode = phaserRegMode2;
    }

    private void switchFromSingleToListStrategy() {
        this.phaserRegModeList = new LinkedList<PhaserRegModeImpl>();
        this.phaserRegModeList.add(this.singlePhaserRegMode);
        this.singlePhaserRegMode = null;
    }

    @Override
    public void addPhaser(PhaserRegModeImpl pr) {
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, "" + this.activity + " adds " + pr + ".");
        }
        if (this.singlePhaserRegMode != null) {
            this.switchFromSingleToListStrategy();
        }
        this.phaserRegModeList.add(pr);
    }

    @Override
    public void dropPhaser(PhaserImpl ph) {
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, "" + this.activity + " drops " + ph + ".");
        }
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (singlePh.equals(ph)) {
                this.singlePhaserRegMode = null;
            } else if (Report.should_report("Phaser", 3)) {
                Report.report(3, "" + this.activity + " dropPhaser attempt failed because phaser to drop is not known by the activity " + ph + ".");
            }
        } else {
            PhaserRegModeImpl pr = null;
            for (PhaserRegModeImpl tpr : this.phaserRegModeList) {
                PhaserImpl ph2 = (PhaserImpl)tpr.getPhaser();
                if (!ph2.equals(ph)) continue;
                pr = tpr;
                break;
            }
            if (pr != null) {
                this.phaserRegModeList.remove(pr);
            }
        }
    }

    @Override
    public void dropAllPhasers() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            singlePh.drop(this.activity);
            this.singlePhaserRegMode = null;
        } else {
            int i = 0;
            PhaserImpl[] arr = new PhaserImpl[this.phaserRegModeList.size()];
            for (PhaserRegModeImpl pr : this.phaserRegModeList) {
                arr[i] = (PhaserImpl)pr.getPhaser();
                ++i;
            }
            PhaserImpl.dropAllPhasers(arr, this.activity);
            arr = null;
            this.phaserRegModeList = null;
        }
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, "" + this.activity + " drops all phasers.");
        }
    }

    @Override
    public void doSignal() {
        if (this.singlePhaserRegMode != null) {
            PhaserAbst.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".signal() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserAbst.Mode.SIG || (mode == PhaserAbst.Mode.SIG_WAIT || mode == PhaserAbst.Mode.SIG_WAIT_SINGLE) && !singlePh.quiescent()) {
                singlePh.signal();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".signal() on " + this.phaserRegModeList);
            }
            for (PhaserRegModeImpl pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserAbst.Mode mode = pr.getMode();
                if (mode != PhaserAbst.Mode.SIG && (mode != PhaserAbst.Mode.SIG_WAIT && mode != PhaserAbst.Mode.SIG_WAIT_SINGLE || ph.quiescent())) continue;
                ph.signal();
            }
        }
    }

    @Override
    public void doWait() {
        if (this.singlePhaserRegMode != null) {
            PhaserAbst.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doWait() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserAbst.Mode.WAIT || (mode == PhaserAbst.Mode.SIG_WAIT || mode == PhaserAbst.Mode.SIG_WAIT_SINGLE) && singlePh.quiescent()) {
                singlePh.doWait();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doWait() on " + this.phaserRegModeList);
            }
            for (PhaserRegModeImpl pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserAbst.Mode mode = pr.getMode();
                if (mode != PhaserAbst.Mode.WAIT && (mode != PhaserAbst.Mode.SIG_WAIT && mode != PhaserAbst.Mode.SIG_WAIT_SINGLE || !ph.quiescent())) continue;
                ph.doWait();
            }
        }
    }

    @Override
    public void doNext() {
        if (this.singlePhaserRegMode != null) {
            PhaserAbst.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserAbst.Mode.SIG || (mode == PhaserAbst.Mode.SIG_WAIT || mode == PhaserAbst.Mode.SIG_WAIT_SINGLE) && !singlePh.quiescent()) {
                singlePh.signal();
            }
            if (mode != PhaserAbst.Mode.SIG) {
                singlePh.doWait();
            }
        } else {
            PhaserAbst.Mode mode;
            PhaserImpl ph;
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext() on " + this.phaserRegModeList);
            }
            for (PhaserRegModeImpl pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                mode = pr.getMode();
                if (mode != PhaserAbst.Mode.SIG && (mode != PhaserAbst.Mode.SIG_WAIT && mode != PhaserAbst.Mode.SIG_WAIT_SINGLE || ph.quiescent())) continue;
                ph.signal();
            }
            for (PhaserRegModeImpl pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                mode = pr.getMode();
                if (mode == PhaserAbst.Mode.SIG) continue;
                ph.doWait();
            }
        }
    }

    @Override
    public int doNext1(String loc) {
        int ret = 0;
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext1() on " + singlePh);
            }
            if (!singlePh.quiescent()) {
                singlePh.signal();
            }
            if (singlePh.doWaitSingle1(loc)) {
                ++ret;
            }
        } else {
            PhaserImpl ph;
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext1() on " + this.phaserRegModeList);
            }
            for (PhaserRegModeImpl pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                if (ph.quiescent()) continue;
                ph.signal();
            }
            for (PhaserRegModeImpl pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                if (!ph.doWaitSingle1(loc)) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public void doNext2() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext2() on " + singlePh);
            }
            singlePh.doWaitSingle2();
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext2() on " + this.phaserRegModeList);
            }
            for (PhaserRegModeImpl pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                ph.doWaitSingle2();
            }
        }
    }

    @Override
    public void registerPhasers() {
        if (this.singlePhaserRegMode != null) {
            this.registerPhaser(this.singlePhaserRegMode);
        } else {
            for (PhaserRegModeImpl pr : this.phaserRegModeList) {
                this.registerPhaser(pr);
            }
        }
    }

    private void registerPhaser(PhaserRegModeImpl pr) {
        PhaserImpl ph = (PhaserImpl)pr.getPhaser();
        PhaserAbst.Mode mode = pr.getMode();
        ph.register(this.activity, mode);
    }

    @Override
    public PhaserImpl checkPhaserUse(PhaserImpl ph) {
        assert (false);
        return null;
    }

    @Override
    public int getNbRegisteredPhasers() {
        if (this.singlePhaserRegMode != null) {
            return 1;
        }
        if (this.phaserRegModeList != null) {
            return this.phaserRegModeList.size();
        }
        return 0;
    }

    @Override
    public List<PhaserRegModeImpl> getPhaserRegModeList() {
        if (this.singlePhaserRegMode != null) {
            ArrayList<PhaserRegModeImpl> l = new ArrayList<PhaserRegModeImpl>();
            l.add(this.singlePhaserRegMode);
            return l;
        }
        return this.phaserRegModeList;
    }

    @Override
    public void putSyncVar1(PhaserImpl ph, SyncVar1 s1) {
        if (this.cnt > 1) {
            this.syncVarMap1.put(ph, s1);
        } else if (this.cnt == 1) {
            if (ph == this.singlePh) {
                this.sv1 = s1;
            } else {
                if (this.sv1 != null) {
                    this.syncVarMap1.put(this.singlePh, this.sv1);
                }
                if (this.sv2 != null) {
                    this.syncVarMap2.put(this.singlePh, this.sv2);
                }
                this.syncVarMap1.put(ph, s1);
                this.cnt = 2;
            }
        } else {
            this.singlePh = ph;
            this.sv1 = s1;
            this.cnt = 1;
        }
    }

    @Override
    public void putSyncVar2(PhaserImpl ph, SyncVar2 s2) {
        if (this.cnt > 1) {
            this.syncVarMap2.put(ph, s2);
        } else if (this.cnt == 1) {
            if (ph == this.singlePh) {
                this.sv2 = s2;
            } else {
                if (this.sv1 != null) {
                    this.syncVarMap1.put(this.singlePh, this.sv1);
                }
                if (this.sv2 != null) {
                    this.syncVarMap2.put(this.singlePh, this.sv2);
                }
                this.syncVarMap2.put(ph, s2);
                this.cnt = 2;
            }
        } else {
            this.singlePh = ph;
            this.sv2 = s2;
            this.cnt = 1;
        }
    }

    @Override
    public SyncVar1 getSyncVar1(PhaserImpl ph) {
        if (this.cnt == 1 && ph == this.singlePh) {
            return this.sv1;
        }
        if (this.cnt > 1) {
            return this.syncVarMap1.get(ph);
        }
        return null;
    }

    @Override
    public SyncVar2 getSyncVar2(PhaserImpl ph) {
        if (this.cnt == 1 && ph == this.singlePh) {
            return this.sv2;
        }
        if (this.cnt > 1) {
            return this.syncVarMap2.get(ph);
        }
        return null;
    }

    @Override
    public void putAccumCell(Accumulator ac, AccumCell cel) {
        if (this.cnta > 1) {
            this.AccumCellMap.put(ac, cel);
        } else if (this.cnta == 1) {
            assert (ac != this.acc);
            this.AccumCellMap.put(this.acc, this.cell);
            this.AccumCellMap.put(ac, cel);
            this.cnta = 2;
        } else {
            this.acc = ac;
            this.cell = cel;
            this.cnta = 1;
        }
    }

    @Override
    public AccumCell getAccumCell(Accumulator ac) {
        if (this.cnta == 1 && ac == this.acc) {
            return this.cell;
        }
        if (this.cnta > 1) {
            return this.AccumCellMap.get(ac);
        }
        return null;
    }

    public void detectAcyclicPhasersOnCycle() {
        int n = this.childPhasers.size() + 1;
        HashMap<PhaserImpl, Integer> phToId = new HashMap<PhaserImpl, Integer>();
        ArrayList<Integer> aphasers = new ArrayList<Integer>();
        LinkedList<Integer> edges = new LinkedList<Integer>();
        int id = 0;
        for (PhaserImpl ph : this.childPhasers) {
            Integer num = new Integer(id);
            phToId.put(ph, num);
            if (ph.isAcyclic) {
                aphasers.add(num);
            }
            ++id;
        }
        if (aphasers.isEmpty()) {
            return;
        }
        if (this.phaserRegMode != null) {
            PhaserImpl ph = (PhaserImpl)this.phaserRegMode.getPhaser();
            PhaserAbst.Mode m = this.phaserRegMode.getMode();
            if (!(ph.isAcyclic || m != PhaserAbst.Mode.SIG_WAIT && m != PhaserAbst.Mode.SIG_WAIT_SINGLE)) {
                phToId.put(ph, new Integer(id));
            }
        } else if (this.phaserRegModes != null) {
            PhaserAbst.Mode modeSum = PhaserAbst.Mode.TRANSMIT;
            for (PhaserRegModeImpl pr : this.phaserRegModes) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserAbst.Mode m = pr.getMode();
                if (ph.isAcyclic) continue;
                if (modeSum == PhaserAbst.Mode.TRANSMIT) {
                    modeSum = m;
                } else if (modeSum != m) {
                    modeSum = PhaserAbst.Mode.SIG_WAIT;
                }
                if (modeSum != PhaserAbst.Mode.SIG_WAIT && modeSum != PhaserAbst.Mode.SIG_WAIT_SINGLE) continue;
                break;
            }
            if (modeSum == PhaserAbst.Mode.SIG_WAIT || modeSum == PhaserAbst.Mode.SIG_WAIT_SINGLE) {
                Integer num = new Integer(id);
                for (PhaserRegModeImpl pr : this.phaserRegModes) {
                    PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                    if (ph.isAcyclic) continue;
                    phToId.put(ph, num);
                }
            }
        }
        if (this.childActRegMap != null) {
            for (BlockingActivity a : this.childActRegMap.keySet()) {
                List<PhaserRegModeImpl> childActRegModes = this.childActRegMap.get(a);
                LinkedList sigs = new LinkedList();
                LinkedList waits = new LinkedList();
                for (PhaserRegModeImpl cpr : childActRegModes) {
                    PhaserImpl ph = (PhaserImpl)cpr.getPhaser();
                    PhaserAbst.Mode m = cpr.getMode();
                    if (m != PhaserAbst.Mode.WAIT) {
                        sigs.add(phToId.get(ph));
                    }
                    if (m == PhaserAbst.Mode.SIG) continue;
                    waits.add(phToId.get(ph));
                }
                for (Integer waitID : waits) {
                    for (Integer sigID : sigs) {
                        if (waitID == sigID) continue;
                        edges.add(waitID);
                        edges.add(sigID);
                    }
                }
            }
        }
        Integer[][] edgeTarget = new Integer[n][n];
        Integer[][] closureSource = new Integer[n][n];
        int[][] refcount = new int[n][n];
        LinkedList[] adjacent = new LinkedList[n];
        LinkedList[] reaches = new LinkedList[n];
        for (int i = 0; i < n; ++i) {
            adjacent[i] = new LinkedList();
            reaches[i] = new LinkedList();
        }
        int totalAph = aphasers.size();
        Iterator it = edges.iterator();
        while (it.hasNext()) {
            Integer srcID = (Integer)it.next();
            Integer distID = (Integer)it.next();
            if (refcount[distID][srcID] > 0) {
                int i = 0;
                while (i < totalAph) {
                    Integer aphID = (Integer)aphasers.get(i);
                    if (!(refcount[distID][aphID] <= 0 && distID != aphID || refcount[aphID][srcID] <= 0 && aphID != srcID)) {
                        aphasers.remove(i);
                        --totalAph;
                        continue;
                    }
                    ++i;
                }
                if (aphasers.isEmpty()) break;
            }
            this.insertEdge(srcID, distID, edgeTarget, closureSource, refcount, adjacent, reaches);
        }
        for (PhaserImpl ph : this.childPhasers) {
            if (!ph.isAcyclic) continue;
            if (!aphasers.contains(phToId.get(ph))) {
                ph.isAcyclic = false;
            }
            ph.isDetecting = false;
        }
    }

    private void insertEdge(Integer a, Integer b, Integer[][] edgeTarget, Integer[][] closureSource, int[][] refcount, List<Integer>[] adjacent, List<Integer>[] reaches) {
        ArrayList<Integer> worklist = new ArrayList<Integer>();
        if (refcount[a][b] == 0) {
            this.makeClosure(a, b, reaches, closureSource);
            worklist.add(a);
            worklist.add(b);
        }
        this.makeEdge(a, b, adjacent, edgeTarget);
        int[] nArray = refcount[a];
        int n = b;
        nArray[n] = nArray[n] + 1;
        for (Integer x : reaches[a]) {
            if (refcount[x][b] == 0) {
                this.makeClosure(x, b, reaches, closureSource);
                worklist.add(x);
                worklist.add(b);
            }
            int[] nArray2 = refcount[x];
            int n2 = b;
            nArray2[n2] = nArray2[n2] + 1;
        }
        int total = worklist.size();
        for (int i = 0; i < total; i += 2) {
            Integer x = (Integer)worklist.get(i);
            Integer y = (Integer)worklist.get(i + 1);
            for (Integer z : adjacent[y]) {
                if (refcount[x][z] == 0) {
                    this.makeClosure(x, z, reaches, closureSource);
                    worklist.add(x);
                    worklist.add(z);
                    total += 2;
                }
                int[] nArray3 = refcount[x];
                int n3 = z;
                nArray3[n3] = nArray3[n3] + 1;
            }
        }
    }

    private void makeEdge(Integer v, Integer w, List<Integer>[] adjacent, Integer[][] edgeTarget) {
        adjacent[v].add(w);
        edgeTarget[v.intValue()][w.intValue()] = w;
    }

    private void makeClosure(Integer v, Integer w, List<Integer>[] reaches, Integer[][] closureSource) {
        reaches[w].add(v);
        closureSource[v.intValue()][w.intValue()] = v;
    }

    @Override
    public void childActivityRegistration(BlockingActivity childActivity, List<PhaserRegModeImpl> phaserRegModes) {
        if (this.childActRegMap == null) {
            this.childActRegMap = new HashMap();
        }
        this.childActRegMap.put(childActivity, phaserRegModes);
    }

    @Override
    public boolean hasAcyclicPhaser() {
        return this.hasAcyclicPhaser;
    }

    @Override
    public void setHasAcyclicPhaser() {
        this.hasAcyclicPhaser = true;
    }

    @Override
    public void addChildPhasers(PhaserImpl phaserImpl) {
        if (this.childPhasers == null) {
            this.childPhasers = new LinkedList<PhaserImpl>();
        }
        this.childPhasers.add(phaserImpl);
    }

    @Override
    public Random rand() {
        if (this.rand == null) {
            this.rand = new Random();
        }
        return this.rand;
    }

    @Override
    public void tmpForDelay(int localSpin) {
        this.tmpForDelay = localSpin;
    }

    @Override
    public void setRound(int round) {
        this.round = round;
    }

    @Override
    public int round() {
        return this.round;
    }
}

