/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.phaser.accumulator;

import hj.runtime.wsh.blocking.BlockingActivity;
import hj.runtime.wsh.blocking.WshBlockingRuntime;
import java.util.concurrent.atomic.AtomicReference;

class AtomicDouble {
    private final AtomicReference<Double> atom;
    private final int func;
    private final double delay;
    private final double coef;

    public AtomicDouble() {
        this.atom = new AtomicReference<Double>(new Double(0.0));
        this.delay = 0.0;
        this.func = 0;
        this.coef = 0.0;
    }

    public AtomicDouble(double val) {
        this.atom = new AtomicReference<Double>(new Double(val));
        this.delay = 0.0;
        this.func = 0;
        this.coef = 0.0;
    }

    public AtomicDouble(double val, int f, double dl, double coe) {
        this.atom = new AtomicReference<Double>(new Double(val));
        this.func = f;
        this.delay = dl;
        this.coef = coe;
    }

    public double get() {
        return this.atom.get();
    }

    public void set(double val) {
        this.atom.set(new Double(val));
    }

    private int localSpin(double round, double exp, BlockingActivity a) {
        int n = 0;
        int length = (int)this.delay;
        switch (this.func) {
            case 1: {
                length = (int)(this.delay * (1.0 + this.coef * a.getPhaserManager().rand().nextDouble()));
                break;
            }
            case 2: {
                length = (int)(this.delay * (1.0 + this.coef * (round - 1.0)));
                break;
            }
            case 3: {
                length = (int)(this.delay * (1.0 + this.coef * round * a.getPhaserManager().rand().nextDouble()));
                break;
            }
            case 4: {
                length = (int)Math.min(exp * this.coef, this.delay);
                break;
            }
            case 5: {
                length = (int)(Math.min(exp * this.coef, this.delay) * a.getPhaserManager().rand().nextDouble());
            }
        }
        for (int i = 0; i < length; ++i) {
            n += i;
        }
        return n;
    }

    public double addAndGet(double val) {
        if (val == 0.0) {
            return this.get();
        }
        BlockingActivity a = (BlockingActivity)WshBlockingRuntime.getCurrentActivity();
        a.getPhaserManager().rand();
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            double newVal;
            Double neo;
            Double cur;
            if (this.atom.compareAndSet(cur = this.atom.get(), neo = new Double(newVal = cur + val))) {
                a.getPhaserManager().setRound((int)round);
                return newVal;
            }
            a.getPhaserManager().tmpForDelay(this.localSpin(round, exp, a));
            round += 1.0;
            exp *= 2.0;
        }
    }

    public double mulAndGet(double val) {
        if (val == 1.0) {
            return this.get();
        }
        BlockingActivity a = (BlockingActivity)WshBlockingRuntime.getCurrentActivity();
        a.getPhaserManager().rand();
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            double newVal;
            Double neo;
            Double cur;
            if (this.atom.compareAndSet(cur = this.atom.get(), neo = new Double(newVal = cur * val))) {
                a.getPhaserManager().setRound((int)round);
                return newVal;
            }
            a.getPhaserManager().tmpForDelay(this.localSpin(round, exp, a));
            round += 1.0;
            exp *= 2.0;
        }
    }

    public double minAndGet(double val) {
        BlockingActivity a = (BlockingActivity)WshBlockingRuntime.getCurrentActivity();
        a.getPhaserManager().rand();
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            Double cur;
            double v;
            if (val >= (v = (cur = this.atom.get()).doubleValue())) {
                a.getPhaserManager().setRound((int)round);
                return v;
            }
            Double neo = new Double(val);
            if (this.atom.compareAndSet(cur, neo)) {
                a.getPhaserManager().setRound((int)round);
                return val;
            }
            a.getPhaserManager().tmpForDelay(this.localSpin(round, exp, a));
            round += 1.0;
            exp *= 2.0;
        }
    }

    public double maxAndGet(double val) {
        BlockingActivity a = (BlockingActivity)WshBlockingRuntime.getCurrentActivity();
        a.getPhaserManager().rand();
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            Double cur;
            double v;
            if (val <= (v = (cur = this.atom.get()).doubleValue())) {
                a.getPhaserManager().setRound((int)round);
                return v;
            }
            Double neo = new Double(val);
            if (this.atom.compareAndSet(cur, neo)) {
                a.getPhaserManager().setRound((int)round);
                return val;
            }
            a.getPhaserManager().tmpForDelay(this.localSpin(round, exp, a));
            round += 1.0;
            exp *= 2.0;
        }
    }
}

