/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.threadpool;

import hj.runtime.wsh.Activity;
import hj.runtime.wsh.ActivityRunner;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.util.Epoc;

public class WshThread
extends Thread
implements PoolRunner,
ActivityRunner {
    private Activity activity;
    private Place place;
    private final String namePrefix;
    private Epoc tempEpoc = new Epoc();

    WshThread(ThreadGroup group, Runnable r, String namePrefix) {
        super(group, r, namePrefix, 0L);
        this.namePrefix = namePrefix;
    }

    public void setPlace(Place p) {
        this.place = p;
    }

    public Place getPlace() {
        return this.place;
    }

    public void setActivity(Activity a) {
        this.activity = a;
        this.setName(this.namePrefix + ": " + a.myName());
    }

    public Activity getActivity() {
        return this.activity;
    }

    public String thisThreadString() {
        return this + "@" + this.place + ":" + System.currentTimeMillis();
    }

    public String toString() {
        return "<PoolRunner " + this.hashCode() + ">";
    }

    public Epoc getEpoc() {
        if (this.tempEpoc == null) {
            this.tempEpoc = new Epoc();
        }
        return this.tempEpoc;
    }
}

