/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.adaptive;

import hj.array.ArrayFactory;
import hj.array.DistributionFactory;
import hj.array.point_c;
import hj.array.sharedmemory.DefaultArrayFactory;
import hj.array.sharedmemory.RegionFactory;
import hj.lang.Exception;
import hj.lang.Object;
import hj.lang.PhaserAbst;
import hj.lang.Runtime;
import hj.lang.RuntimeAbortException;
import hj.lang.accumulator;
import hj.lang.dist;
import hj.lang.phaser;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.TwoLevelLockPlace;
import hj.runtime.wst.WstConfiguration;
import hj.runtime.wst.adaptive.ActivationFrame;
import hj.runtime.wst.adaptive.Closure;
import hj.runtime.wst.adaptive.FinishTreeNode;
import hj.runtime.wst.adaptive.Place;
import hj.runtime.wst.adaptive.Worker;
import hj.runtime.wst.adaptive.WorkerExecutable;
import hj.runtime.wst.finishAccumulator.FinishAccumulator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Runtime
extends hj.lang.Runtime {
    public static Runtime singleton;
    private final Worker[] allWorkers;
    private final Place[] allPlaces;
    private final int numWorkers;
    private final int numPlaces;
    public final boolean reserveBottom = WstConfiguration.RESERVE_BOTTOM;
    public static volatile boolean done;
    private static long intervalTimer;

    public String getRuntimeType() {
        return "work-stealing";
    }

    public Runtime() {
        this.numWorkers = Configuration.INIT_THREADS_PER_PLACE;
        this.numPlaces = Configuration.NUMBER_OF_LOCAL_PLACES;
        if (this.numPlaces != 1) {
            System.out.println("Workstealing runtime doesn't support multi-places yet. Exiting.");
        }
        assert (this.numPlaces == 1);
        this.allWorkers = new Worker[this.numWorkers];
        this.allPlaces = new Place[this.numPlaces];
        done = false;
        singleton = this;
        TwoLevelLockPlace.init();
    }

    public void startWorkers(ActivationFrame mainAF) {
        int i;
        Closure initClosure = new Closure();
        initClosure.head = mainAF;
        this.allWorkers[0] = new Worker(0, initClosure);
        FinishTreeNode.mainFinishScope = new FinishTreeNode(null, this.allWorkers[0]);
        initClosure.setFinishScope(FinishTreeNode.mainFinishScope);
        initClosure = null;
        for (i = 1; i < this.numWorkers; ++i) {
            this.allWorkers[i] = new Worker(i, null);
        }
        for (i = 1; i < this.numWorkers; ++i) {
            this.allWorkers[i].start();
        }
        this.allWorkers[0].start();
        for (i = 0; i < this.numWorkers; ++i) {
            try {
                this.allWorkers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                --i;
            }
        }
        if (WstConfiguration.EXECUTION_STATS) {
            this.dumpStatistics();
        }
    }

    public static int getNumWorkers() {
        return Runtime.singleton.numWorkers;
    }

    public static int getNumPlaces() {
        return Runtime.singleton.numPlaces;
    }

    public static Worker getWorker(int i) {
        return Runtime.singleton.allWorkers[i];
    }

    public static Worker getCurrentWSTWorker() {
        Thread t = Thread.currentThread();
        if (t instanceof Worker) {
            return (Worker)t;
        }
        return null;
    }

    public static WorkerExecutable getCurrentExecutable() {
        Worker worker = Runtime.getCurrentWSTWorker();
        if (worker != null) {
            return worker.getClosure().currentExecutable;
        }
        return null;
    }

    public int getStealCounts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sum += this.allWorkers[i].getNumSteals();
        }
        return sum;
    }

    public int getStealAttempts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sum += this.allWorkers[i].getNumStealAttempts();
        }
        return sum;
    }

    private void dumpStatistics() {
        if (Configuration.printInfo()) {
            int sumSteals = 0;
            int sumStealAttempts = 0;
            for (int i = 0; i < this.numWorkers; ++i) {
                sumSteals += this.allWorkers[i].getNumSteals();
                sumStealAttempts += this.allWorkers[i].getNumStealAttempts();
            }
            System.err.println("StealAttempts=" + sumStealAttempts + "\t NumSteals=" + sumSteals);
            Runtime.printProfilingStats();
        }
    }

    public static void startTimer() {
        intervalTimer = -System.nanoTime();
    }

    public static void stopTimer() {
        intervalTimer += System.nanoTime();
    }

    public long getTimer() {
        return intervalTimer;
    }

    public static void printProfilingStats() {
        if (Configuration.printInfo()) {
            System.out.println("stack bound = " + WstConfiguration.POLICY_STACK_DEPTH);
            System.out.println("task bound = " + WstConfiguration.POLICY_DEQUE_LIMIT);
            System.out.println("re-evaluation interval = " + WstConfiguration.POLICY_INTERVAL);
            for (int i = 0; i < Runtime.getNumWorkers(); ++i) {
                Worker worker = Runtime.getWorker(i);
                System.out.println();
                System.out.println(worker + " re-evaluate policy " + worker.PROFILE_eval + " times");
                System.out.println("------ stack bound (switch/total)= " + worker.PROFILE_stack_bound_switch + "/" + worker.PROFILE_stack_bound);
                System.out.println("------ task bound (switch/total)= " + worker.PROFILE_task_bound_switch + "/" + worker.PROFILE_task_bound);
                System.out.println("------ steal rate fast (switch/total)= " + worker.PROFILE_steal_rate_fast_switch + "/" + worker.PROFILE_steal_rate_fast);
                System.out.println("------ steal rate slow (switch/total)= " + worker.PROFILE_steal_rate_slow_switch + "/" + worker.PROFILE_steal_rate_slow);
                System.out.println("------ reset (switch/total)= " + worker.PROFILE_reset_switch + "/" + worker.PROFILE_reset);
                System.out.println("------ workfirst asyncs = " + worker.PROFILE_work_first_asyncs);
                System.out.println("------ helpfirst asyncs = " + worker.PROFILE_help_first_asyncs);
            }
        }
    }

    public Activity currentActivity() {
        throw new RuntimeException("currentActivity not supported in work-stealing");
    }

    public place currentPlace() {
        return Runtime.place0();
    }

    public Runtime.Factory getFactory() {
        Runtime.Factory f = new Runtime.Factory(){

            public accumulator.factory getAccumulatorFactory() {
                return new accumulator.factory(){

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph) {
                        throw new Exception("Phaser-accumulator is not supported in work-stealing yet");
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy) {
                        throw new Exception("Phaser-accumulator is not supported in work-stealing yet");
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy, int arrsize) {
                        throw new Exception("Phaser-accumulator is not supported in work-stealing yet");
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy, int arrsize, int func, double delay, double coef) {
                        throw new Exception("Phaser-accumulator is not supported in work-stealing yet");
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type) {
                        return new FinishAccumulator(ope, type);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, boolean isLazy) {
                        return new FinishAccumulator(ope, type, isLazy);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, boolean isLazy, int func, double delay, double coef) {
                        return new FinishAccumulator(ope, type, isLazy, func, delay, coef);
                    }
                };
            }

            public ArrayFactory getArrayFactory() {
                return new DefaultArrayFactory();
            }

            public PhaserAbst.factory getPhaserFactory() {
                throw new Exception("Phasers are not supported in work-stealing yet");
            }

            public dist.factory getDistributionFactory() {
                return new DistributionFactory();
            }

            public place.factory getPlaceFactory() {
                return new place.factory(){

                    public place here() {
                        return Runtime.this.currentPlace();
                    }

                    public place place(int i) {
                        int index = i % place.MAX_PLACES;
                        return Runtime.this.allPlaces[index];
                    }

                    public Set places(int last) {
                        TreeSet<Place> result = new TreeSet<Place>();
                        for (int i = 0; i <= last % place.MAX_PLACES; ++i) {
                            result.add(Runtime.this.allPlaces[i]);
                        }
                        return result;
                    }
                };
            }

            public point.factory getPointFactory() {
                return new point_c.factory();
            }

            public region.factory getRegionFactory() {
                return new RegionFactory();
            }
        };
        return f;
    }

    protected place getPlace0() {
        return this.allPlaces[0];
    }

    public static place getPlace(int id) {
        return Runtime.singleton.allPlaces[id];
    }

    protected place[] getPlaces() {
        return this.allPlaces;
    }

    protected void initialize() {
        place.MAX_PLACES = this.numPlaces;
        for (int i = 0; i < Runtime.getNumPlaces(); ++i) {
            this.allPlaces[i] = new Place();
            if (this.allPlaces[i].id == i) continue;
            System.err.println("ERROR Place " + i);
        }
        place.initialize();
    }

    public void prepareForBoot() {
        this.initialize();
    }

    protected void run(String[] args) throws Exception {
        this.prepareForBoot();
        try {
            String mainClassName = Configuration.MAIN_CLASS_NAME;
            Class<?> main = Class.forName(mainClassName + "$mainframe", true, HJ_CLASSLOADER);
            Constructor<?> c = main.getDeclaredConstructor(String[].class);
            ActivationFrame maf = (ActivationFrame)c.newInstance(new java.lang.Object[]{args});
            maf.pc = 0;
            this.startWorkers(maf);
            this.checkExecution();
        }
        catch (ClassNotFoundException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (SecurityException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (Exception e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        this.shutdown();
    }

    private void checkExecution() {
        boolean success = true;
        for (int i = 0; i < this.numWorkers; ++i) {
            success &= this.allWorkers[i].success;
        }
        if (!success) {
            Runtime.setExitCode(202);
        }
    }

    public void setCurrentPlace(place p) {
    }

    public void shutdown() {
    }

    public void emergencyShutdown(RuntimeAbortException e) {
        throw new RuntimeException("emergencyShutdown not support in Work-Stealing mode");
    }

    public void startIsolation_() {
        TwoLevelLockPlace.atomicStarLock();
    }

    public int[] startIsolation_(Object[] objs) {
        throw new RuntimeException("startIsolation_ not yet implemented");
    }

    public int[] startIsolation_(List objs) {
        throw new RuntimeException("startIsolation_ not yet implemented");
    }

    public int startIsolation_(Object obj) {
        throw new RuntimeException("startIsolation_ not yet implemented");
    }

    public int[] startIsolation_(Object obj1, Object obj2) {
        throw new RuntimeException("startIsolation_ not yet implemented");
    }

    public void stopIsolation_() {
        TwoLevelLockPlace.atomicStarUnlock();
    }

    public void stopIsolation_(int[] placeIDs) {
        throw new RuntimeException("stopIsolation_ not yet implemented");
    }

    public void stopIsolation_(int placeID) {
        throw new RuntimeException("stopIsolation_ not yet implemented");
    }

    public void startIsolationR_() {
        TwoLevelLockPlace.atomicStarRLock();
    }

    public void stopIsolationR_() {
        TwoLevelLockPlace.atomicStarRUnLock();
    }

    public boolean registerLockObject_(java.lang.Object lockObject) {
        WorkerExecutable workerExec = Runtime.getCurrentExecutable();
        if (workerExec != null) {
            return workerExec.registerLockObject(lockObject);
        }
        throw new RuntimeException("Can't get current activity!");
    }

    public boolean registerLockObjects_(java.lang.Object[] lockObjects) {
        WorkerExecutable workerExec = Runtime.getCurrentExecutable();
        if (workerExec != null) {
            return workerExec.registerLockObjects(lockObjects);
        }
        throw new RuntimeException("Can't get current activity!");
    }

    public void releaseLockObjects_(java.lang.Object lockObject) {
        WorkerExecutable workerExec = Runtime.getCurrentExecutable();
        if (workerExec != null) {
            workerExec.releaseLockObjects(lockObject);
        }
    }

    static {
        done = false;
    }
}

