/*
 * Decompiled with CFR 0.152.
 */
package hj.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DebugUtil {
    private static final boolean DEBUG = true;
    private static final AtomicBoolean LOCK = new AtomicBoolean(false);
    private static final List<String> MSGS = new ArrayList<String>();

    public static void debugLazy(String msg) {
        boolean keepLooping = true;
        while (keepLooping) {
            boolean success = LOCK.compareAndSet(false, true);
            if (!success) continue;
            MSGS.add(msg);
            LOCK.set(false);
            keepLooping = false;
        }
    }

    public static void printLazyMsgs() {
        boolean keepLooping = true;
        while (keepLooping) {
            boolean success = LOCK.compareAndSet(false, true);
            if (!success) continue;
            for (String msg : MSGS) {
                System.out.println(msg);
            }
            MSGS.clear();
            LOCK.set(false);
            keepLooping = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugln(String msg) {
        Thread currentThread = Thread.currentThread();
        int callDepth = Math.max(currentThread.getStackTrace().length - 8, 0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < callDepth; ++i) {
            sb.append(' ');
        }
        sb.append(currentThread.getName());
        sb.append(": ");
        sb.append(msg);
        Class<DebugUtil> clazz = DebugUtil.class;
        synchronized (DebugUtil.class) {
            System.out.println(sb.toString());
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }
}

