/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import jsr166y.ForkJoinTask;
import jsr166y.ForkJoinWorkerThread;
import jsr166y.LinkedTransferQueue;
import jsr166y.RecursiveAction;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    private static final int shortMask = 65535;
    private static final int MAX_THREADS = Short.MAX_VALUE;
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
    private static final RuntimePermission modifyThreadPermission = new RuntimePermission("modifyThread");
    private static final AtomicInteger poolNumberGenerator = new AtomicInteger();
    volatile ForkJoinWorkerThread[] workers;
    private final ReentrantLock workerLock;
    private final Condition termination;
    private Thread.UncaughtExceptionHandler ueh;
    private final ForkJoinWorkerThreadFactory factory;
    private volatile WaitQueueNode spareStack;
    private final AtomicLong stealCount;
    private final LinkedTransferQueue<ForkJoinTask<?>> submissionQueue;
    private volatile WaitQueueNode syncStack;
    private volatile long eventCount;
    private final int poolNumber;
    private volatile int maxPoolSize;
    private volatile int parallelism;
    private volatile boolean locallyFifo;
    private volatile int workerCounts;
    private volatile int runControl;
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int TERMINATING = 2;
    private static final int TERMINATED = 3;
    private volatile boolean maintainsParallelism;
    private static final Unsafe UNSAFE = ForkJoinPool.getUnsafe();
    private static final long eventCountOffset = ForkJoinPool.objectFieldOffset("eventCount", ForkJoinPool.class);
    private static final long workerCountsOffset = ForkJoinPool.objectFieldOffset("workerCounts", ForkJoinPool.class);
    private static final long runControlOffset = ForkJoinPool.objectFieldOffset("runControl", ForkJoinPool.class);
    private static final long syncStackOffset = ForkJoinPool.objectFieldOffset("syncStack", ForkJoinPool.class);
    private static final long spareStackOffset = ForkJoinPool.objectFieldOffset("spareStack", ForkJoinPool.class);

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    private static int totalCountOf(int s) {
        return s >>> 16;
    }

    private static int runningCountOf(int s) {
        return s & 0xFFFF;
    }

    private static int workerCountsFor(int t, int r) {
        return (t << 16) + r;
    }

    final void updateRunningCount(int delta) {
        int s;
        while (!this.casWorkerCounts(s = this.workerCounts, s + delta)) {
        }
    }

    private void updateWorkerCount(int delta) {
        int s;
        int d = delta + (delta << 16);
        while (!this.casWorkerCounts(s = this.workerCounts, s + d)) {
        }
    }

    private static int runStateOf(int c) {
        return c >>> 16;
    }

    private static int activeCountOf(int c) {
        return c & 0xFFFF;
    }

    private static int runControlFor(int r, int a) {
        return (r << 16) + a;
    }

    final boolean tryIncrementActiveCount() {
        int c = this.runControl;
        return this.casRunControl(c, c + 1);
    }

    final boolean tryDecrementActiveCount() {
        int c = this.runControl;
        int nextc = c - 1;
        if (!this.casRunControl(c, nextc)) {
            return false;
        }
        if (ForkJoinPool.canTerminateOnShutdown(nextc)) {
            this.terminateOnShutdown();
        }
        return true;
    }

    private static boolean canTerminateOnShutdown(int c) {
        return (c & -c) >>> 16 != 0;
    }

    private boolean transitionRunStateTo(int state) {
        int c;
        do {
            if (ForkJoinPool.runStateOf(c = this.runControl) < state) continue;
            return false;
        } while (!this.casRunControl(c, ForkJoinPool.runControlFor(state, ForkJoinPool.activeCountOf(c))));
        return true;
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(ForkJoinWorkerThreadFactory factory) {
        this(Runtime.getRuntime().availableProcessors(), factory);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory) {
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (factory == null) {
            throw new NullPointerException();
        }
        ForkJoinPool.checkPermission();
        this.factory = factory;
        this.parallelism = parallelism;
        this.maxPoolSize = Short.MAX_VALUE;
        this.maintainsParallelism = true;
        this.poolNumber = poolNumberGenerator.incrementAndGet();
        this.workerLock = new ReentrantLock();
        this.termination = this.workerLock.newCondition();
        this.stealCount = new AtomicLong();
        this.submissionQueue = new LinkedTransferQueue();
    }

    private ForkJoinWorkerThread createWorker(int index) {
        Thread.UncaughtExceptionHandler h = this.ueh;
        ForkJoinWorkerThread w = this.factory.newThread(this);
        if (w != null) {
            w.poolIndex = index;
            w.setDaemon(true);
            w.setAsyncMode(this.locallyFifo);
            w.setName("ForkJoinPool-" + this.poolNumber + "-worker-" + index);
            if (h != null) {
                w.setUncaughtExceptionHandler(h);
            }
        }
        return w;
    }

    private static int arraySizeFor(int poolSize) {
        if (poolSize <= 1) {
            return 1;
        }
        int c = poolSize >= Short.MAX_VALUE ? Short.MAX_VALUE : poolSize - 1;
        c |= c >>> 1;
        c |= c >>> 2;
        c |= c >>> 4;
        c |= c >>> 8;
        c |= c >>> 16;
        return c + 1;
    }

    private ForkJoinWorkerThread[] ensureWorkerArrayCapacity(int newLength) {
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws == null) {
            this.workers = new ForkJoinWorkerThread[ForkJoinPool.arraySizeFor(newLength)];
            return this.workers;
        }
        if (newLength > ws.length) {
            this.workers = Arrays.copyOf(ws, ForkJoinPool.arraySizeFor(newLength));
            return this.workers;
        }
        return ws;
    }

    private void tryShrinkWorkerArray() {
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws != null) {
            int last;
            int len = ws.length;
            for (last = len - 1; last >= 0 && ws[last] == null; --last) {
            }
            int newLength = ForkJoinPool.arraySizeFor(last + 1);
            if (newLength < len) {
                this.workers = Arrays.copyOf(ws, newLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureWorkerInitialization() {
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws == null) {
            ReentrantLock lock = this.workerLock;
            lock.lock();
            try {
                ws = this.workers;
                if (ws == null) {
                    int ps = this.parallelism;
                    this.updateWorkerCount(ps);
                    ws = this.ensureWorkerArrayCapacity(ps);
                    for (int i = 0; i < ps; ++i) {
                        ForkJoinWorkerThread w = this.createWorker(i);
                        if (w != null) {
                            ws[i] = w;
                            w.start();
                            continue;
                        }
                        this.updateWorkerCount(-1);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void createAndStartAddedWorkers() {
        this.resumeAllSpares();
        int ps = this.parallelism;
        ForkJoinWorkerThread[] ws = this.ensureWorkerArrayCapacity(ps);
        int len = ws.length;
        int k = 0;
        while (k < len) {
            if (ws[k] != null) {
                ++k;
                continue;
            }
            int s = this.workerCounts;
            int tc = ForkJoinPool.totalCountOf(s);
            int rc = ForkJoinPool.runningCountOf(s);
            if (rc >= ps || tc >= ps) break;
            if (!this.casWorkerCounts(s, ForkJoinPool.workerCountsFor(tc + 1, rc + 1))) continue;
            ForkJoinWorkerThread w = this.createWorker(k);
            if (w != null) {
                ws[k++] = w;
                w.start();
                continue;
            }
            this.updateWorkerCount(-1);
            break;
        }
    }

    private <T> void doSubmit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException();
        }
        if (this.workers == null) {
            this.ensureWorkerInitialization();
        }
        this.submissionQueue.offer(task);
        this.signalIdleWorkers();
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        this.doSubmit(task);
        return task.join();
    }

    public void execute(ForkJoinTask<?> task) {
        this.doSubmit(task);
    }

    @Override
    public void execute(Runnable task) {
        ForkJoinTask<Object> job = task instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)task) : ForkJoinTask.adapt(task, null);
        this.doSubmit(job);
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        ForkJoinTask<T> job = ForkJoinTask.adapt(task);
        this.doSubmit(job);
        return job;
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        ForkJoinTask<T> job = ForkJoinTask.adapt(task, result);
        this.doSubmit(job);
        return job;
    }

    public ForkJoinTask<?> submit(Runnable task) {
        ForkJoinTask<Object> job = task instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)task) : ForkJoinTask.adapt(task, null);
        this.doSubmit(job);
        return job;
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        this.doSubmit(task);
        return task;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> forkJoinTasks = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            forkJoinTasks.add(ForkJoinTask.adapt(task));
        }
        this.invoke(new InvokeAll(forkJoinTasks));
        ArrayList<Future<T>> futures = forkJoinTasks;
        return futures;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler h;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            h = this.ueh;
        }
        finally {
            lock.unlock();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread.UncaughtExceptionHandler setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler h) {
        ForkJoinPool.checkPermission();
        Thread.UncaughtExceptionHandler old = null;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            old = this.ueh;
            this.ueh = h;
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws != null) {
                for (int i = 0; i < ws.length; ++i) {
                    ForkJoinWorkerThread w = ws[i];
                    if (w == null) continue;
                    w.setUncaughtExceptionHandler(h);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParallelism(int parallelism) {
        ForkJoinPool.checkPermission();
        if (parallelism <= 0 || parallelism > this.maxPoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            if (this.isProcessingTasks()) {
                int p = this.parallelism;
                this.parallelism = parallelism;
                if (this.workers != null) {
                    if (parallelism > p) {
                        this.createAndStartAddedWorkers();
                    } else {
                        this.trimSpares();
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.signalIdleWorkers();
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getPoolSize() {
        return ForkJoinPool.totalCountOf(this.workerCounts);
    }

    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaximumPoolSize(int newMax) {
        if (newMax < 0 || newMax > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.maxPoolSize = newMax;
    }

    public boolean getMaintainsParallelism() {
        return this.maintainsParallelism;
    }

    public void setMaintainsParallelism(boolean enable) {
        this.maintainsParallelism = enable;
    }

    public boolean setAsyncMode(boolean async) {
        boolean oldMode = this.locallyFifo;
        this.locallyFifo = async;
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread t = ws[i];
                if (t == null) continue;
                t.setAsyncMode(async);
            }
        }
        return oldMode;
    }

    public boolean getAsyncMode() {
        return this.locallyFifo;
    }

    public int getRunningThreadCount() {
        return ForkJoinPool.runningCountOf(this.workerCounts);
    }

    public int getActiveThreadCount() {
        return ForkJoinPool.activeCountOf(this.runControl);
    }

    final int getIdleThreadCount() {
        int c = ForkJoinPool.runningCountOf(this.workerCounts) - ForkJoinPool.activeCountOf(this.runControl);
        return c <= 0 ? 0 : c;
    }

    public boolean isQuiescent() {
        return ForkJoinPool.activeCountOf(this.runControl) == 0;
    }

    public long getStealCount() {
        return this.stealCount.get();
    }

    private void updateStealCount(ForkJoinWorkerThread w) {
        int sc = w.getAndClearStealCount();
        if (sc != 0) {
            this.stealCount.addAndGet(sc);
        }
    }

    public long getQueuedTaskCount() {
        long count = 0L;
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread t = ws[i];
                if (t == null) continue;
                count += (long)t.getQueueSize();
            }
        }
        return count;
    }

    public int getQueuedSubmissionCount() {
        return this.submissionQueue.size();
    }

    public boolean hasQueuedSubmissions() {
        return !this.submissionQueue.isEmpty();
    }

    protected ForkJoinTask<?> pollSubmission() {
        return this.submissionQueue.poll();
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        int n = this.submissionQueue.drainTo(c);
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread w = ws[i];
                if (w == null) continue;
                n += w.drainTasksTo(c);
            }
        }
        return n;
    }

    public String toString() {
        int ps = this.parallelism;
        int wc = this.workerCounts;
        int rc = this.runControl;
        long st = this.getStealCount();
        long qt = this.getQueuedTaskCount();
        long qs = this.getQueuedSubmissionCount();
        return super.toString() + "[" + ForkJoinPool.runStateToString(ForkJoinPool.runStateOf(rc)) + ", parallelism = " + ps + ", size = " + ForkJoinPool.totalCountOf(wc) + ", active = " + ForkJoinPool.activeCountOf(rc) + ", running = " + ForkJoinPool.runningCountOf(wc) + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    private static String runStateToString(int rs) {
        switch (rs) {
            case 0: {
                return "Running";
            }
            case 1: {
                return "Shutting down";
            }
            case 2: {
                return "Terminating";
            }
            case 3: {
                return "Terminated";
            }
        }
        throw new Error("Unknown run state");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.transitionRunStateTo(1);
        if (ForkJoinPool.canTerminateOnShutdown(this.runControl)) {
            if (this.workers == null) {
                ReentrantLock lock = this.workerLock;
                lock.lock();
                try {
                    if (this.workers == null) {
                        this.terminate();
                        this.transitionRunStateTo(3);
                        this.termination.signalAll();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            this.terminateOnShutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.terminate();
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return ForkJoinPool.runStateOf(this.runControl) == 3;
    }

    public boolean isTerminating() {
        return ForkJoinPool.runStateOf(this.runControl) == 2;
    }

    @Override
    public boolean isShutdown() {
        return ForkJoinPool.runStateOf(this.runControl) >= 1;
    }

    final boolean isProcessingTasks() {
        return ForkJoinPool.runStateOf(this.runControl) < 2;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            while (true) {
                if (this.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void workerTerminated(ForkJoinWorkerThread w) {
        this.updateStealCount(w);
        this.updateWorkerCount(-1);
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws != null) {
                int idx = w.poolIndex;
                if (idx >= 0 && idx < ws.length && ws[idx] == w) {
                    ws[idx] = null;
                }
                if (ForkJoinPool.totalCountOf(this.workerCounts) == 0) {
                    this.terminate();
                    this.transitionRunStateTo(3);
                    this.termination.signalAll();
                } else if (this.isProcessingTasks()) {
                    this.tryShrinkWorkerArray();
                    this.tryResumeSpare(true);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.signalIdleWorkers();
    }

    private void terminate() {
        if (this.transitionRunStateTo(2)) {
            this.stopAllWorkers();
            this.resumeAllSpares();
            this.signalIdleWorkers();
            this.cancelQueuedSubmissions();
            this.cancelQueuedWorkerTasks();
            this.interruptUnterminatedWorkers();
            this.signalIdleWorkers();
        }
    }

    private void terminateOnShutdown() {
        if (!this.hasQueuedSubmissions() && ForkJoinPool.canTerminateOnShutdown(this.runControl)) {
            this.terminate();
        }
    }

    private void cancelQueuedSubmissions() {
        ForkJoinTask<?> task;
        while ((task = this.pollSubmission()) != null) {
            task.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQueuedWorkerTasks() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws != null) {
                for (int i = 0; i < ws.length; ++i) {
                    ForkJoinWorkerThread t = ws[i];
                    if (t == null) continue;
                    t.cancelTasks();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllWorkers() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws != null) {
                for (int i = 0; i < ws.length; ++i) {
                    ForkJoinWorkerThread t = ws[i];
                    if (t == null) continue;
                    t.shutdownNow();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptUnterminatedWorkers() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws != null) {
                for (int i = 0; i < ws.length; ++i) {
                    ForkJoinWorkerThread t = ws[i];
                    if (t == null || t.isTerminated()) continue;
                    try {
                        t.interrupt();
                        continue;
                    }
                    catch (SecurityException ignore) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    final void ensureSync() {
        WaitQueueNode q;
        long c = this.eventCount;
        while ((q = this.syncStack) != null && q.count < c) {
            if (!this.casBarrierStack(q, null)) continue;
            do {
                q.signal();
            } while ((q = q.next) != null);
            break;
        }
    }

    private void signalIdleWorkers() {
        long c;
        while (!this.casEventCount(c = this.eventCount, c + 1L)) {
        }
        this.ensureSync();
    }

    final void signalWork() {
        if (this.syncStack != null) {
            long c = this.eventCount;
            this.casEventCount(c, c + 1L);
            WaitQueueNode q = this.syncStack;
            if (q != null && q.count <= c) {
                if (this.casBarrierStack(q, q.next)) {
                    q.signal();
                } else {
                    this.ensureSync();
                }
            }
        }
    }

    final void sync(ForkJoinWorkerThread w) {
        this.updateStealCount(w);
        if (!w.isShutdown() && this.isProcessingTasks() && !this.suspendIfSpare(w)) {
            WaitQueueNode h;
            long c;
            long prev = w.lastEventCount;
            WaitQueueNode node = null;
            while ((c = this.eventCount) == prev && ((h = this.syncStack) == null || h.count == prev)) {
                if (node == null) {
                    node = new WaitQueueNode(prev, w);
                }
                if (!this.casBarrierStack(node.next = h, node)) continue;
                if (!Thread.interrupted() && node.thread != null && this.eventCount == prev && (h != null || !ForkJoinWorkerThread.hasQueuedTasks(this.workers) && this.eventCount == prev)) {
                    LockSupport.park(this);
                }
                c = this.eventCount;
                if (node.thread == null) break;
                node.thread = null;
                if (c != prev) break;
                this.casEventCount(prev, prev + 1L);
                break;
            }
            w.lastEventCount = c;
            this.ensureSync();
        }
    }

    final boolean hasNewSyncEvent(ForkJoinWorkerThread w) {
        long wc = w.lastEventCount;
        long c = this.eventCount;
        if (wc != c) {
            w.lastEventCount = c;
        }
        this.ensureSync();
        return wc != c || wc != this.eventCount;
    }

    final boolean preJoin(ForkJoinTask<?> joinMe, boolean maintainParallelism) {
        maintainParallelism &= this.maintainsParallelism;
        boolean dec = false;
        while (this.spareStack == null || !this.tryResumeSpare(dec)) {
            int counts = this.workerCounts;
            if (!dec && !(dec = this.casWorkerCounts(counts--, counts))) continue;
            if (!this.needSpare(counts, maintainParallelism)) break;
            if (joinMe.status < 0) {
                return true;
            }
            if (!this.tryAddSpare(counts)) continue;
            break;
        }
        return false;
    }

    final boolean preBlock(ManagedBlocker blocker, boolean maintainParallelism) {
        maintainParallelism &= this.maintainsParallelism;
        boolean dec = false;
        while (this.spareStack == null || !this.tryResumeSpare(dec)) {
            int counts = this.workerCounts;
            if (!dec && !(dec = this.casWorkerCounts(counts--, counts))) continue;
            if (!this.needSpare(counts, maintainParallelism)) break;
            if (blocker.isReleasable()) {
                return true;
            }
            if (!this.tryAddSpare(counts)) continue;
            break;
        }
        return false;
    }

    private boolean needSpare(int counts, boolean maintainParallelism) {
        int ps = this.parallelism;
        int rc = ForkJoinPool.runningCountOf(counts);
        int tc = ForkJoinPool.totalCountOf(counts);
        int runningDeficit = ps - rc;
        int totalSurplus = tc - ps;
        return tc < this.maxPoolSize && (rc == 0 || totalSurplus < 0 || maintainParallelism && runningDeficit > totalSurplus && ForkJoinWorkerThread.hasQueuedTasks(this.workers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAddSpare(int expectedCounts) {
        boolean success;
        block7: {
            ReentrantLock lock = this.workerLock;
            int expectedRunning = ForkJoinPool.runningCountOf(expectedCounts);
            int expectedTotal = ForkJoinPool.totalCountOf(expectedCounts);
            success = false;
            boolean locked = false;
            try {
                int rc;
                int tc;
                int s;
                do {
                    s = this.workerCounts;
                    tc = ForkJoinPool.totalCountOf(s);
                    rc = ForkJoinPool.runningCountOf(s);
                    if (rc > expectedRunning) break block7;
                    if (tc > expectedTotal) {
                    } else if (locked || (locked = lock.tryLock())) continue;
                    break block7;
                } while (!this.casWorkerCounts(s, ForkJoinPool.workerCountsFor(tc + 1, rc + 1)));
                this.createAndStartSpare(tc);
                success = true;
            }
            finally {
                if (locked) {
                    lock.unlock();
                }
            }
        }
        return success;
    }

    private void createAndStartSpare(int k) {
        ForkJoinWorkerThread w = null;
        ForkJoinWorkerThread[] ws = this.ensureWorkerArrayCapacity(k + 1);
        int len = ws.length;
        if (k < len && ws[k] != null) {
            for (k = 0; k < len && ws[k] != null; ++k) {
            }
        }
        if (k < len && this.isProcessingTasks() && (w = this.createWorker(k)) != null) {
            ws[k] = w;
            w.start();
        } else {
            this.updateWorkerCount(-1);
        }
        this.signalIdleWorkers();
    }

    private boolean suspendIfSpare(ForkJoinWorkerThread w) {
        int rc;
        int tc;
        int s;
        WaitQueueNode node = null;
        do {
            int ps;
            s = this.workerCounts;
            rc = ForkJoinPool.runningCountOf(s);
            tc = ForkJoinPool.totalCountOf(s);
            if (tc <= (ps = this.parallelism) || rc <= ps) {
                return false;
            }
            if (node != null) continue;
            node = new WaitQueueNode(0L, w);
        } while (!this.casWorkerCounts(s, ForkJoinPool.workerCountsFor(tc, rc - 1)));
        while (!this.casSpareStack(node.next = this.spareStack, node)) {
        }
        while (!Thread.interrupted() && node.thread != null) {
            LockSupport.park(this);
        }
        return true;
    }

    private boolean tryResumeSpare(boolean updateCount) {
        WaitQueueNode q;
        while ((q = this.spareStack) != null) {
            if (!this.casSpareStack(q, q.next)) continue;
            if (updateCount) {
                this.updateRunningCount(1);
            }
            q.signal();
            return true;
        }
        return false;
    }

    private boolean resumeAllSpares() {
        WaitQueueNode q;
        while ((q = this.spareStack) != null) {
            if (!this.casSpareStack(q, null)) continue;
            do {
                this.updateRunningCount(1);
                q.signal();
            } while ((q = q.next) != null);
            return true;
        }
        return false;
    }

    private void trimSpares() {
        WaitQueueNode q;
        int surplus = ForkJoinPool.totalCountOf(this.workerCounts) - this.parallelism;
        while (surplus > 0 && (q = this.spareStack) != null) {
            if (!this.casSpareStack(q, null)) continue;
            do {
                this.updateRunningCount(1);
                ForkJoinWorkerThread w = q.thread;
                if (w != null && surplus > 0 && ForkJoinPool.runningCountOf(this.workerCounts) > 0 && w.shutdown()) {
                    --surplus;
                }
                q.signal();
            } while ((q = q.next) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void managedBlock(ManagedBlocker blocker, boolean maintainParallelism) throws InterruptedException {
        ForkJoinPool pool;
        Thread t = Thread.currentThread();
        ForkJoinPool forkJoinPool = pool = t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool : null;
        if (!blocker.isReleasable()) {
            try {
                if (pool == null || !pool.preBlock(blocker, maintainParallelism)) {
                    ForkJoinPool.awaitBlocker(blocker);
                }
            }
            finally {
                if (pool != null) {
                    pool.updateRunningCount(1);
                }
            }
        }
    }

    private static void awaitBlocker(ManagedBlocker blocker) throws InterruptedException {
        while (!blocker.isReleasable() && !blocker.block()) {
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(callable));
    }

    private boolean casEventCount(long cmp, long val) {
        return UNSAFE.compareAndSwapLong(this, eventCountOffset, cmp, val);
    }

    private boolean casWorkerCounts(int cmp, int val) {
        return UNSAFE.compareAndSwapInt(this, workerCountsOffset, cmp, val);
    }

    private boolean casRunControl(int cmp, int val) {
        return UNSAFE.compareAndSwapInt(this, runControlOffset, cmp, val);
    }

    private boolean casSpareStack(WaitQueueNode cmp, WaitQueueNode val) {
        return UNSAFE.compareAndSwapObject(this, spareStackOffset, cmp, val);
    }

    private boolean casBarrierStack(WaitQueueNode cmp, WaitQueueNode val) {
        return UNSAFE.compareAndSwapObject(this, syncStackOffset, cmp, val);
    }

    private static long objectFieldOffset(String field, Class<?> klazz) {
        try {
            return UNSAFE.objectFieldOffset(klazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldError error = new NoSuchFieldError(field);
            error.initCause(e);
            throw error;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class WaitQueueNode {
        WaitQueueNode next;
        volatile ForkJoinWorkerThread thread;
        final long count;

        WaitQueueNode(long c, ForkJoinWorkerThread w) {
            this.count = c;
            this.thread = w;
        }

        void signal() {
            ForkJoinWorkerThread t = this.thread;
            if (t != null) {
                this.thread = null;
                LockSupport.unpark(t);
            }
        }
    }

    static final class InvokeAll<T>
    extends RecursiveAction {
        final ArrayList<ForkJoinTask<T>> tasks;
        private static final long serialVersionUID = -7914297376763021607L;

        InvokeAll(ArrayList<ForkJoinTask<T>> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void compute() {
            try {
                InvokeAll.invokeAll(this.tasks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            try {
                return new ForkJoinWorkerThread(pool);
            }
            catch (OutOfMemoryError oom) {
                return null;
            }
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

