/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.AmbQualifierNode;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.ast.Prefix;
import polyglot.ast.QualifierNode;
import polyglot.ast.TypeCheckTypeGoal;
import polyglot.frontend.SetResolverGoal;
import polyglot.types.LazyRef;
import polyglot.types.Qualifier;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeCheckPreparer;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbQualifierNode_c
extends Node_c
implements AmbQualifierNode {
    protected LazyRef<Qualifier> qualifier;
    protected Prefix qual;
    protected Id name;

    public AmbQualifierNode_c(Position pos, Prefix qual, Id name) {
        super(pos);
        assert (name != null);
        this.qual = qual;
        this.name = name;
    }

    public LazyRef<? extends Qualifier> qualifierRef() {
        return this.qualifier;
    }

    @Override
    public Id name() {
        return this.name;
    }

    public AmbQualifierNode name(Id name) {
        AmbQualifierNode_c n = (AmbQualifierNode_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public Prefix prefix() {
        return this.qual;
    }

    public AmbQualifierNode qual(Prefix qual) {
        AmbQualifierNode_c n = (AmbQualifierNode_c)this.copy();
        n.qual = qual;
        return n;
    }

    public AmbQualifierNode qualifier(LazyRef<Qualifier> qualifier) {
        AmbQualifierNode_c n = (AmbQualifierNode_c)this.copy();
        n.qualifier = qualifier;
        return n;
    }

    protected AmbQualifierNode_c reconstruct(Prefix qual, Id name) {
        if (qual != this.qual || name != this.name) {
            AmbQualifierNode_c n = (AmbQualifierNode_c)this.copy();
            n.qual = qual;
            n.name = name;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild(this.name, v);
        Prefix qual = (Prefix)this.visitChild(this.qual, v);
        return this.reconstruct(qual, name);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        LazyRef<Qualifier> sym2 = Types.lazyRef(ts.unknownQualifier(this.position()), new SetResolverGoal(tb.job()));
        return this.qualifier(sym2);
    }

    public Qualifier qualifier() {
        return (Qualifier)this.qualifierRef().get();
    }

    @Override
    public void setResolver(Node parent, TypeCheckPreparer v) {
        Ref r = this.qualifierRef();
        TypeChecker tc = new TypeChecker(v.job(), v.typeSystem(), v.nodeFactory(), v.getMemo());
        tc = (TypeChecker)tc.context(v.context().freeze());
        r.setResolver(new TypeCheckTypeGoal(parent, this, tc, (LazyRef)r, false));
    }

    @Override
    public Node disambiguate(ContextVisitor ar) throws SemanticException {
        SemanticException ex;
        try {
            Node n = ar.nodeFactory().disamb().disambiguate(this, ar, this.position(), this.qual, this.name);
            if (n instanceof QualifierNode) {
                QualifierNode qn = (QualifierNode)n;
                Qualifier q = qn.qualifierRef().get();
                this.qualifier.update(q);
                return n;
            }
            ex = new SemanticException("Could not find type or package \"" + (this.qual == null ? this.name.toString() : this.qual.toString() + "." + this.name.toString()) + "\".", this.position());
        }
        catch (SemanticException e) {
            ex = e;
        }
        LazyRef<Qualifier> sym2 = this.qualifier;
        sym2.update(ar.typeSystem().unknownQualifier(this.position()));
        throw ex;
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot exception check ambiguous node " + this + ".");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.qual != null) {
            this.print(this.qual, w, tr);
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        tr.print(this, this.name, w);
    }

    @Override
    public String toString() {
        return (this.qual == null ? this.name.toString() : this.qual.toString() + "." + this.name.toString()) + "{amb}";
    }
}

