/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Assert;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.frontend.Globals;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assert_c
extends Stmt_c
implements Assert {
    protected Expr cond;
    protected Expr errorMessage;

    public Assert_c(Position pos, Expr cond, Expr errorMessage) {
        super(pos);
        assert (cond != null);
        this.cond = cond;
        this.errorMessage = errorMessage;
    }

    @Override
    public Expr cond() {
        return this.cond;
    }

    @Override
    public Assert cond(Expr cond) {
        Assert_c n = (Assert_c)this.copy();
        n.cond = cond;
        return n;
    }

    @Override
    public Expr errorMessage() {
        return this.errorMessage;
    }

    @Override
    public Assert errorMessage(Expr errorMessage) {
        Assert_c n = (Assert_c)this.copy();
        n.errorMessage = errorMessage;
        return n;
    }

    protected Assert_c reconstruct(Expr cond, Expr errorMessage) {
        if (cond != this.cond || errorMessage != this.errorMessage) {
            Assert_c n = (Assert_c)this.copy();
            n.cond = cond;
            n.errorMessage = errorMessage;
            return n;
        }
        return this;
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        if (!this.cond.type().isBoolean()) {
            throw new SemanticException("Condition of assert statement must have boolean type.", this.cond.position());
        }
        if (this.errorMessage != null && this.errorMessage.type().isVoid()) {
            throw new SemanticException("Error message in assert statement cannot be void.", this.errorMessage.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr cond = (Expr)this.visitChild(this.cond, v);
        Expr errorMessage = (Expr)this.visitChild(this.errorMessage, v);
        return this.reconstruct(cond, errorMessage);
    }

    @Override
    public String toString() {
        return "assert " + this.cond.toString() + (this.errorMessage != null ? ": " + this.errorMessage.toString() : "") + ";";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("assert ");
        this.print(this.cond, w, tr);
        if (this.errorMessage != null) {
            w.write(": ");
            this.print(this.errorMessage, w, tr);
        }
        w.write(";");
    }

    @Override
    public void translate(CodeWriter w, Translator tr) {
        if (!Globals.Options().assertions) {
            w.write(";");
        } else {
            this.prettyPrint(w, tr);
        }
    }

    @Override
    public Term firstChild() {
        return this.cond;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.errorMessage != null) {
            v.visitCFG(this.cond, this.errorMessage, 1);
            v.visitCFG(this.errorMessage, this, 0);
        } else {
            v.visitCFG(this.cond, this, 0);
        }
        return succs;
    }
}

