/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Ambiguous;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.frontend.Globals;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Assign_c
extends Expr_c
implements Assign,
Ambiguous {
    protected Assign.Operator op;
    protected Expr right;

    public Assign_c(Position pos, Assign.Operator op, Expr right) {
        super(pos);
        assert (op != null && right != null);
        this.op = op;
        this.right = right;
    }

    @Override
    public Precedence precedence() {
        return Precedence.ASSIGN;
    }

    @Override
    public abstract Expr left(NodeFactory var1);

    @Override
    public Assign.Operator operator() {
        return this.op;
    }

    @Override
    public Assign operator(Assign.Operator op) {
        Assign_c n = (Assign_c)this.copy();
        n.op = op;
        return n;
    }

    @Override
    public Expr right() {
        return this.right;
    }

    @Override
    public Assign right(Expr right) {
        if (right == this.right) {
            return this;
        }
        Assign_c n = (Assign_c)this.copy();
        n.right = right;
        return n;
    }

    public abstract Assign visitLeft(NodeVisitor var1);

    @Override
    public Node visitChildren(NodeVisitor v) {
        Assign a = this.visitLeft(v);
        Expr right = (Expr)this.visitChild(a.right(), v);
        return a.right(right);
    }

    @Override
    public abstract Type leftType();

    public abstract Assign typeCheckLeft(ContextVisitor var1) throws SemanticException;

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        Assign_c n = (Assign_c)this.typeCheckLeft(tc);
        TypeSystem ts = tc.typeSystem();
        Type t = n.leftType();
        if (t == null) {
            t = ts.unknownType(this.position());
        }
        Expr right = n.right();
        Assign.Operator op = n.operator();
        Type s = right.type();
        Context context = tc.context();
        if (op == ASSIGN) {
            if (!(ts.isImplicitCastValid(s, t, context) || ts.typeEquals(s, t, context) || ts.numericConversionValid(t, right.constantValue(), context))) {
                throw new SemanticException("Cannot assign " + s + " to " + t + ".", this.position());
            }
            return n.type(t);
        }
        if (op == ADD_ASSIGN) {
            if (ts.typeEquals(t, ts.String(), context) && ts.canCoerceToString(s, context)) {
                return n.type(ts.String());
            }
            if (t.isNumeric() && s.isNumeric()) {
                return n.type(ts.promote(t, s));
            }
            throw new SemanticException("The " + op + " operator must have " + "numeric or String operands.", this.position());
        }
        if (op == SUB_ASSIGN || op == MUL_ASSIGN || op == DIV_ASSIGN || op == MOD_ASSIGN) {
            if (t.isNumeric() && s.isNumeric()) {
                return n.type(ts.promote(t, s));
            }
            throw new SemanticException("The " + op + " operator must have " + "numeric operands.", this.position());
        }
        if (op == BIT_AND_ASSIGN || op == BIT_OR_ASSIGN || op == BIT_XOR_ASSIGN) {
            if (t.isBoolean() && s.isBoolean()) {
                return n.type(ts.Boolean());
            }
            if (ts.isImplicitCastValid(t, ts.Long(), context) && ts.isImplicitCastValid(s, ts.Long(), context)) {
                return n.type(ts.promote(t, s));
            }
            throw new SemanticException("The " + op + " operator must have " + "integral or boolean operands.", this.position());
        }
        if (op == SHL_ASSIGN || op == SHR_ASSIGN || op == USHR_ASSIGN) {
            if (ts.isImplicitCastValid(t, ts.Long(), context) && ts.isImplicitCastValid(s, ts.Long(), context)) {
                return n.type(ts.promote(t));
            }
            throw new SemanticException("The " + op + " operator must have " + "integral operands.", this.position());
        }
        throw new InternalCompilerError("Unrecognized assignment operator " + op + ".");
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.right) {
            TypeSystem ts = av.typeSystem();
            if (ts.numericConversionValid(this.leftType(), child.constantValue(), av.context())) {
                return child.type();
            }
            return this.leftType();
        }
        return child.type();
    }

    @Override
    public boolean throwsArithmeticException() {
        return this.op == DIV_ASSIGN || this.op == MOD_ASSIGN;
    }

    @Override
    public String toString() {
        return this.left(Globals.NF()) + " " + this.op + " " + this.right;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printSubExpr(this.left(Globals.NF()), true, w, tr);
        w.write(" ");
        w.write(this.op.toString());
        w.allowBreak(2, 2, " ", 1);
        w.begin(0);
        this.printSubExpr(this.right, false, w, tr);
        w.end();
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(operator " + this.op + ")");
        w.end();
    }

    @Override
    public abstract Term firstChild();

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.operator() == ASSIGN) {
            this.acceptCFGAssign(v);
        } else {
            this.acceptCFGOpAssign(v);
        }
        return succs;
    }

    protected abstract void acceptCFGAssign(CFGBuilder var1);

    protected abstract void acceptCFGOpAssign(CFGBuilder var1);

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        if (this.throwsArithmeticException()) {
            return Collections.singletonList(ts.ArithmeticException());
        }
        return Collections.emptyList();
    }
}

