/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Case;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Case_c
extends Stmt_c
implements Case {
    protected Expr expr;
    protected long value;

    public Case_c(Position pos, Expr expr) {
        super(pos);
        this.expr = expr;
    }

    @Override
    public boolean isDefault() {
        return this.expr == null;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Case expr(Expr expr) {
        Case_c n = (Case_c)this.copy();
        n.expr = expr;
        return n;
    }

    @Override
    public long value() {
        return this.value;
    }

    @Override
    public Case value(long value) {
        Case_c n = (Case_c)this.copy();
        n.value = value;
        return n;
    }

    protected Case_c reconstruct(Expr expr) {
        if (expr != this.expr) {
            Case_c n = (Case_c)this.copy();
            n.expr = expr;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild(this.expr, v);
        return this.reconstruct(expr);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        if (this.expr == null) {
            return this;
        }
        TypeSystem ts = tc.typeSystem();
        if (!ts.isImplicitCastValid(this.expr.type(), ts.Int(), tc.context()) && !ts.isImplicitCastValid(this.expr.type(), ts.Char(), tc.context())) {
            throw new SemanticException("Case label must be an byte, char, short, or int.", this.position());
        }
        return this;
    }

    @Override
    public Node checkConstants(ContextVisitor tc) throws SemanticException {
        if (this.expr == null) {
            return this;
        }
        if (this.expr.isConstant()) {
            Object o = this.expr.constantValue();
            if (o instanceof Number && !(o instanceof Long) && !(o instanceof Float) && !(o instanceof Double)) {
                return this.value(((Number)o).longValue());
            }
            if (o instanceof Character) {
                return this.value(((Character)o).charValue());
            }
        }
        throw new SemanticException("Case label must be an integral constant.", this.position());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Int();
        }
        return child.type();
    }

    @Override
    public String toString() {
        if (this.expr == null) {
            return "default:";
        }
        return "case " + this.expr + ":";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.expr == null) {
            w.write("default:");
        } else {
            w.write("case ");
            this.print(this.expr, w, tr);
            w.write(":");
        }
    }

    @Override
    public Term firstChild() {
        if (this.expr != null) {
            return this.expr;
        }
        return null;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.expr != null) {
            v.visitCFG(this.expr, this, 0);
        }
        return succs;
    }
}

