/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cast_c
extends Expr_c
implements Cast {
    protected TypeNode castType;
    protected Expr expr;

    public Cast_c(Position pos, TypeNode castType, Expr expr) {
        super(pos);
        assert (castType != null && expr != null);
        this.castType = castType;
        this.expr = expr;
    }

    @Override
    public Precedence precedence() {
        return Precedence.CAST;
    }

    @Override
    public TypeNode castType() {
        return this.castType;
    }

    @Override
    public Cast castType(TypeNode castType) {
        Cast_c n = (Cast_c)this.copy();
        n.castType = castType;
        return n;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Cast expr(Expr expr) {
        Cast_c n = (Cast_c)this.copy();
        n.expr = expr;
        return n;
    }

    protected Cast_c reconstruct(TypeNode castType, Expr expr) {
        if (castType != this.castType || expr != this.expr) {
            Cast_c n = (Cast_c)this.copy();
            n.castType = castType;
            n.expr = expr;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode castType = (TypeNode)this.visitChild(this.castType, v);
        Expr expr = (Expr)this.visitChild(this.expr, v);
        return this.reconstruct(castType, expr);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.isCastValid(this.expr.type(), this.castType.type(), tc.context())) {
            throw new SemanticException("Cannot cast the expression of type \"" + this.expr.type() + "\" to type \"" + this.castType.type() + "\".", this.position());
        }
        return this.type(this.castType.type());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            if (this.castType.type().isReference()) {
                return ts.Object();
            }
            if (this.castType.type().isNumeric()) {
                return ts.Double();
            }
            if (this.castType.type().isBoolean()) {
                return ts.Boolean();
            }
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "(" + this.castType + ") " + this.expr;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write("(");
        this.print(this.castType, w, tr);
        w.write(")");
        w.allowBreak(2, " ");
        this.printSubExpr(this.expr, w, tr);
        w.end();
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG(this.expr, this.castType, 1);
        v.visitCFG(this.castType, this, 0);
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        if (this.expr.type().isReference()) {
            return Collections.singletonList(ts.ClassCastException());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isConstant() {
        return this.expr.isConstant() && this.castType.type().isPrimitive();
    }

    @Override
    public Object constantValue() {
        Object v = this.expr.constantValue();
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean && this.castType.type().isBoolean()) {
            return v;
        }
        if (v instanceof String) {
            TypeSystem ts = this.castType.type().typeSystem();
            if (this.castType.type().typeEquals(ts.String(), ts.emptyContext())) {
                return v;
            }
        }
        if (v instanceof Double) {
            double vv = (Double)v;
            if (this.castType.type().isDouble()) {
                return vv;
            }
            if (this.castType.type().isFloat()) {
                return Float.valueOf((float)vv);
            }
            if (this.castType.type().isLong()) {
                return (long)vv;
            }
            if (this.castType.type().isInt()) {
                return (int)vv;
            }
            if (this.castType.type().isChar()) {
                return Character.valueOf((char)vv);
            }
            if (this.castType.type().isShort()) {
                return (short)vv;
            }
            if (this.castType.type().isByte()) {
                return (byte)vv;
            }
        }
        if (v instanceof Float) {
            float vv = ((Float)v).floatValue();
            if (this.castType.type().isDouble()) {
                return (double)vv;
            }
            if (this.castType.type().isFloat()) {
                return Float.valueOf(vv);
            }
            if (this.castType.type().isLong()) {
                return (long)vv;
            }
            if (this.castType.type().isInt()) {
                return (int)vv;
            }
            if (this.castType.type().isChar()) {
                return Character.valueOf((char)vv);
            }
            if (this.castType.type().isShort()) {
                return (short)vv;
            }
            if (this.castType.type().isByte()) {
                return (byte)vv;
            }
        }
        if (v instanceof Number) {
            long vv = ((Number)v).longValue();
            if (this.castType.type().isDouble()) {
                return (double)vv;
            }
            if (this.castType.type().isFloat()) {
                return Float.valueOf(vv);
            }
            if (this.castType.type().isLong()) {
                return vv;
            }
            if (this.castType.type().isInt()) {
                return (int)vv;
            }
            if (this.castType.type().isChar()) {
                return Character.valueOf((char)vv);
            }
            if (this.castType.type().isShort()) {
                return (short)vv;
            }
            if (this.castType.type().isByte()) {
                return (byte)vv;
            }
        }
        if (v instanceof Character) {
            char vv = ((Character)v).charValue();
            if (this.castType.type().isDouble()) {
                return (double)vv;
            }
            if (this.castType.type().isFloat()) {
                return Float.valueOf(vv);
            }
            if (this.castType.type().isLong()) {
                return (long)vv;
            }
            if (this.castType.type().isInt()) {
                return (int)vv;
            }
            if (this.castType.type().isChar()) {
                return Character.valueOf(vv);
            }
            if (this.castType.type().isShort()) {
                return (short)vv;
            }
            if (this.castType.type().isByte()) {
                return (byte)vv;
            }
        }
        return null;
    }
}

