/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Catch_c
extends Stmt_c
implements Catch {
    protected Formal formal;
    protected Block body;

    public Catch_c(Position pos, Formal formal, Block body) {
        super(pos);
        assert (formal != null && body != null);
        this.formal = formal;
        this.body = body;
    }

    @Override
    public Type catchType() {
        return this.formal.declType();
    }

    @Override
    public Formal formal() {
        return this.formal;
    }

    @Override
    public Catch formal(Formal formal) {
        Catch_c n = (Catch_c)this.copy();
        n.formal = formal;
        return n;
    }

    @Override
    public Block body() {
        return this.body;
    }

    @Override
    public Catch body(Block body) {
        Catch_c n = (Catch_c)this.copy();
        n.body = body;
        return n;
    }

    protected Catch_c reconstruct(Formal formal, Block body) {
        if (formal != this.formal || body != this.body) {
            Catch_c n = (Catch_c)this.copy();
            n.formal = formal;
            n.body = body;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Formal formal = (Formal)this.visitChild(this.formal, v);
        Block body = (Block)this.visitChild(this.body, v);
        return this.reconstruct(formal, body);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!this.catchType().isThrowable()) {
            throw new SemanticException("Can only throw subclasses of \"" + ts.Throwable() + "\".", this.formal.position());
        }
        return this;
    }

    @Override
    public String toString() {
        return "catch (" + this.formal + ") " + this.body;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("catch (");
        this.printBlock(this.formal, w, tr);
        w.write(")");
        this.printSubStmt(this.body, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.formal;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG(this.formal, this.body, 1);
        v.visitCFG(this.body, this, 0);
        return succs;
    }
}

