/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.FlagsNode;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.main.Report;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.Context;
import polyglot.types.Def;
import polyglot.types.Flags;
import polyglot.types.MemberDef;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.PruningVisitor;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDecl_c
extends Term_c
implements ClassDecl {
    protected FlagsNode flags;
    protected Id name;
    protected TypeNode superClass;
    protected List<TypeNode> interfaces;
    protected ClassBody body;
    protected ConstructorDef defaultCI;
    protected ClassDef type;

    public ClassDecl_c(Position pos, FlagsNode flags, Id name, TypeNode superClass, List interfaces, ClassBody body) {
        super(pos);
        assert (flags != null && name != null && interfaces != null && body != null);
        this.flags = flags;
        this.name = name;
        this.superClass = superClass;
        this.interfaces = TypedList.copyAndCheck(interfaces, TypeNode.class, true);
        this.body = body;
    }

    public List<Def> defs() {
        return Collections.singletonList(this.type);
    }

    @Override
    public MemberDef memberDef() {
        return this.type;
    }

    @Override
    public ClassDef classDef() {
        return this.type;
    }

    @Override
    public ClassDecl classDef(ClassDef type) {
        if (type == this.type) {
            return this;
        }
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.type = type;
        return n;
    }

    @Override
    public FlagsNode flags() {
        return this.flags;
    }

    @Override
    public ClassDecl flags(FlagsNode flags) {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public ClassDecl name(Id name) {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public TypeNode superClass() {
        return this.superClass;
    }

    @Override
    public ClassDecl superClass(TypeNode superClass) {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.superClass = superClass;
        return n;
    }

    @Override
    public List<TypeNode> interfaces() {
        return this.interfaces;
    }

    @Override
    public ClassDecl interfaces(List<TypeNode> interfaces) {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.interfaces = TypedList.copyAndCheck(interfaces, TypeNode.class, true);
        return n;
    }

    @Override
    public ClassBody body() {
        return this.body;
    }

    @Override
    public ClassDecl body(ClassBody body) {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.body = body;
        return n;
    }

    protected ClassDecl_c reconstruct(FlagsNode flags, Id name, TypeNode superClass, List<TypeNode> interfaces, ClassBody body) {
        if (flags != this.flags || name != this.name || superClass != this.superClass || !CollectionUtil.allEqual(interfaces, this.interfaces) || body != this.body) {
            ClassDecl_c n = (ClassDecl_c)this.copy();
            n.flags = flags;
            n.name = name;
            n.superClass = superClass;
            n.interfaces = TypedList.copyAndCheck(interfaces, TypeNode.class, true);
            n.body = body;
            return n;
        }
        return this;
    }

    @Override
    public Term firstChild() {
        return this.body();
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG(this.body(), this, 0);
        return succs;
    }

    public Node visitSignature(NodeVisitor v) {
        FlagsNode flags = (FlagsNode)this.visitChild(this.flags, v);
        Id name = (Id)this.visitChild(this.name, v);
        TypeNode superClass = (TypeNode)this.visitChild(this.superClass, v);
        List interfaces = this.visitList(this.interfaces, v);
        ClassBody body = this.body;
        return this.reconstruct(flags, name, superClass, interfaces, body);
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        ClassDecl_c n = (ClassDecl_c)this.visitSignature(v);
        ClassBody body = (ClassBody)n.visitChild(n.body, v);
        return body == n.body ? n : n.body(body);
    }

    @Override
    public Node buildTypesOverride(TypeBuilder tb) throws SemanticException {
        ClassDecl_c n = this;
        n = n.preBuildTypes(tb);
        n = n.buildTypesBody(tb);
        n = n.postBuildTypes(tb);
        return n;
    }

    private ClassDecl_c buildTypesBody(TypeBuilder tb) throws SemanticException {
        ClassDecl_c n = this;
        TypeBuilder tb2 = tb.pushClass(n.type);
        ClassBody body = (ClassBody)n.visitChild(n.body, tb2);
        n = (ClassDecl_c)n.body(body);
        return n;
    }

    public ClassDecl_c preBuildTypes(TypeBuilder tb) throws SemanticException {
        ClassDef type = (tb = tb.pushClass(this.position(), this.flags.flags(), this.name.id())).currentClass();
        if (type.isMember() && type.outer().get().flags().isInterface()) {
            type.flags(type.flags().Public().Static());
        }
        if (type.isMember() && type.flags().isInterface()) {
            type.flags(type.flags().Static());
        }
        if (type.flags().isInterface()) {
            type.flags(type.flags().Abstract());
        }
        ClassDecl_c n = this;
        FlagsNode flags = (FlagsNode)n.visitChild(n.flags, tb);
        Id name = (Id)n.visitChild(n.name, tb);
        TypeNode superClass = (TypeNode)n.visitChild(n.superClass, tb);
        List interfaces = n.visitList(n.interfaces, tb);
        n = n.reconstruct(flags, name, superClass, interfaces, n.body);
        n.setSuperClass(tb.typeSystem(), type);
        n.setInterfaces(tb.typeSystem(), type);
        n = (ClassDecl_c)n.classDef(type).flags(flags.flags(type.flags()));
        return n;
    }

    public ClassDecl_c postBuildTypes(TypeBuilder tb) throws SemanticException {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        if (n.defaultConstructorNeeded()) {
            ConstructorDecl cd = n.createDefaultConstructor(this.type, tb.typeSystem(), tb.nodeFactory());
            TypeBuilder tb2 = tb.pushClass(n.type);
            cd = (ConstructorDecl)tb2.visitEdge(n, cd);
            n = (ClassDecl_c)n.body(n.body().addMember(cd));
            n.defaultCI = cd.constructorDef();
        }
        return n;
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        if (child == this.body) {
            TypeSystem ts = c.typeSystem();
            c = c.pushClass(this.type, this.type.asType());
        } else if (child == this.superClass || this.interfaces.contains(child)) {
            c = c.pushBlock();
            c.addNamed(this.type.asType());
        }
        return super.enterChildScope(child, c);
    }

    protected void checkSupertypeCycles(TypeSystem ts) throws SemanticException {
        Ref<? extends Type> stref = this.type.superType();
        if (stref != null) {
            Type t = stref.get();
            if (t instanceof UnknownType) {
                throw new SemanticException();
            }
            if (!t.isClass() || t.toClass().flags().isInterface()) {
                throw new SemanticException("Cannot extend type " + t + "; not a class.", this.superClass != null ? this.superClass.position() : this.position());
            }
            ts.checkCycles((ReferenceType)t);
        }
        for (Ref<? extends Type> tref : this.type.interfaces()) {
            Type t = tref.get();
            assert (!(t instanceof UnknownType));
            if (!t.isClass() || !t.toClass().flags().isInterface()) {
                String s = this.type.flags().isInterface() ? "extend" : "implement";
                throw new SemanticException("Cannot " + s + " type " + t + "; not an interface.", this.position());
            }
            ts.checkCycles((ReferenceType)t);
        }
    }

    protected void setSuperClass(TypeSystem ts, ClassDef thisType) throws SemanticException {
        TypeNode superClass = this.superClass;
        QName objectName = ((ClassType)ts.Object()).fullName();
        if (superClass != null) {
            Ref<? extends Type> t = superClass.typeRef();
            if (Report.should_report("types", 3)) {
                Report.report(3, "setting superclass of " + this.type + " to " + t);
            }
            thisType.superType(t);
        } else if (thisType.asType().equals((Object)ts.Object()) || thisType.fullName().equals(objectName)) {
            if (Report.should_report("types", 3)) {
                Report.report(3, "setting superclass of " + thisType + " to " + null);
            }
            thisType.superType(null);
        } else {
            if (Report.should_report("types", 3)) {
                Report.report(3, "setting superclass of " + this.type + " to " + ts.Object());
            }
            thisType.superType(Types.ref(ts.Object()));
        }
    }

    protected void setInterfaces(TypeSystem ts, ClassDef thisType) throws SemanticException {
        List<TypeNode> interfaces = this.interfaces;
        for (TypeNode tn : interfaces) {
            Ref<? extends Type> t = tn.typeRef();
            if (Report.should_report("types", 3)) {
                Report.report(3, "adding interface of " + thisType + " to " + t);
            }
            thisType.addInterface(t);
        }
    }

    protected boolean defaultConstructorNeeded() {
        if (this.flags.flags().isInterface()) {
            return false;
        }
        for (ClassMember cm : this.body().members()) {
            if (!(cm instanceof ConstructorDecl)) continue;
            return false;
        }
        return true;
    }

    protected ConstructorDecl createDefaultConstructor(ClassDef thisType, TypeSystem ts, NodeFactory nf) throws SemanticException {
        Position pos = this.body().position().startOf();
        Block block = null;
        Ref<? extends Type> superType = thisType.superType();
        if (superType != null) {
            ConstructorCall cc = nf.SuperCall(pos, Collections.EMPTY_LIST);
            block = nf.Block(pos, cc);
        } else {
            block = nf.Block(pos);
        }
        ConstructorDecl cd = nf.ConstructorDecl(pos, nf.FlagsNode(pos, Flags.PUBLIC), this.name, Collections.EMPTY_LIST, Collections.EMPTY_LIST, block);
        return cd;
    }

    @Override
    public Node typeCheckOverride(Node parent, ContextVisitor tc) throws SemanticException {
        ClassDecl_c n = this;
        NodeVisitor v = tc.enter(parent, n);
        if (v instanceof PruningVisitor) {
            return this;
        }
        TypeChecker childtc = (TypeChecker)v;
        n = (ClassDecl_c)n.typeCheckSupers(tc, childtc);
        n = (ClassDecl_c)n.typeCheckBody(parent, tc, childtc);
        return n;
    }

    public Node typeCheckSupers(ContextVisitor tc, TypeChecker childtc) throws SemanticException {
        ClassDecl_c n = this;
        Context c = tc.context();
        this.type.inStaticContext(c.inStaticContext());
        FlagsNode flags = n.flags;
        Id name = n.name;
        TypeNode superClass = n.superClass;
        List interfaces = n.interfaces;
        ClassBody body = n.body;
        flags = (FlagsNode)this.visitChild(n.flags, childtc);
        name = (Id)this.visitChild(n.name, childtc);
        superClass = (TypeNode)n.visitChild(n.superClass, childtc);
        interfaces = n.visitList(n.interfaces, childtc);
        if (n.superClass() != null) assert (this.type.superType() == n.superClass().typeRef());
        n = n.reconstruct(flags, name, superClass, interfaces, body);
        n.checkSupertypeCycles(tc.typeSystem());
        return n;
    }

    public Node typeCheckBody(Node parent, ContextVisitor tc, TypeChecker childtc) throws SemanticException {
        ClassDecl_c old = this;
        ClassDecl_c n = this;
        FlagsNode flags = n.flags;
        Id name = n.name;
        TypeNode superClass = n.superClass;
        List<TypeNode> interfaces = n.interfaces;
        ClassBody body = n.body;
        body = (ClassBody)n.visitChild(body, childtc);
        n = n.reconstruct(flags, name, superClass, interfaces, body);
        n = (ClassDecl_c)tc.leave(parent, old, n, childtc);
        return n;
    }

    @Override
    public Node conformanceCheck(ContextVisitor tc) throws SemanticException {
        Type another;
        Named nm;
        Context ctxt;
        TypeSystem ts = tc.typeSystem();
        ClassType type = this.type.asType();
        Name name = this.name.id();
        if (type.isNested()) {
            for (ClassType container = type.outer(); container != null; container = container.outer()) {
                Name cname;
                if (!container.isAnonymous() && (cname = container.name()).equals(name)) {
                    throw new SemanticException("Cannot declare member class \"" + type.fullName() + "\" inside class with the " + "same name.", this.position());
                }
                if (!container.isNested()) break;
            }
        }
        if (type.isLocal() && (ctxt = tc.context()).isLocal(name) && (nm = ctxt.find(ts.TypeMatcher(name))) instanceof Type && (another = (Type)((Object)nm)).isClass() && another.toClass().isLocal()) {
            throw new SemanticException("Cannot declare local class \"" + this.type + "\" within the same " + "method, constructor or initializer as another " + "local class of the same name.", this.position());
        }
        if (type.isMember() && type.flags().isInterface() && type.outer().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare member interfaces.", this.position());
        }
        if (type.isMember() && type.flags().isStatic() && type.outer().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare static member classes.", this.position());
        }
        if (type.superClass() != null) {
            if (!type.superClass().isClass() || type.superClass().toClass().flags().isInterface()) {
                throw new SemanticException("Cannot extend non-class \"" + type.superClass() + "\".", this.position());
            }
            if (type.superClass().toClass().flags().isFinal()) {
                throw new SemanticException("Cannot extend final class \"" + type.superClass() + "\".", this.position());
            }
            if (type.typeEquals(ts.Object(), tc.context())) {
                throw new SemanticException("Class \"" + this.type + "\" cannot have a superclass.", this.superClass.position());
            }
        }
        for (TypeNode tn : this.interfaces) {
            Type t = tn.type();
            if (!t.isClass() || !t.toClass().flags().isInterface()) {
                throw new SemanticException("Superinterface " + t + " of " + type + " is not an interface.", tn.position());
            }
            if (!type.typeEquals(ts.Object(), tc.context())) continue;
            throw new SemanticException("Class " + this.type + " cannot have a superinterface.", tn.position());
        }
        try {
            if (type.isTopLevel()) {
                ts.checkTopLevelClassFlags(type.flags());
            }
            if (type.isMember()) {
                ts.checkMemberClassFlags(type.flags());
            }
            if (type.isLocal()) {
                ts.checkLocalClassFlags(type.flags());
            }
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        ts.checkClassConformance(type, this.enterChildScope(this.body, tc.context()));
        return this;
    }

    @Override
    public String toString() {
        Flags flags = this.flags.flags();
        return flags.clearInterface().translate() + (flags.isInterface() ? "interface " : "class ") + this.name + " " + this.body;
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        Flags flags = this.type.flags();
        if (flags.isInterface()) {
            w.write(flags.clearInterface().clearAbstract().translate());
        } else {
            w.write(flags.translate());
        }
        if (flags.isInterface()) {
            w.write("interface ");
        } else {
            w.write("class ");
        }
        tr.print(this, this.name, w);
        if (this.superClass() != null) {
            w.allowBreak(0);
            w.write("extends ");
            this.print(this.superClass(), w, tr);
        }
        if (!this.interfaces.isEmpty()) {
            w.allowBreak(2);
            if (flags.isInterface()) {
                w.write("extends ");
            } else {
                w.write("implements ");
            }
            w.begin(0);
            Iterator<TypeNode> i = this.interfaces().iterator();
            while (i.hasNext()) {
                TypeNode tn = i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0);
            }
            w.end();
        }
        w.unifiedBreak(0);
        w.end();
        w.write("{");
    }

    public void prettyPrintFooter(CodeWriter w, PrettyPrinter tr) {
        w.write("}");
        w.newline(0);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.prettyPrintHeader(w, tr);
        this.print(this.body(), w, tr);
        this.prettyPrintFooter(w, tr);
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
        if (this.type != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(type " + this.type + ")");
            w.end();
        }
    }
}

