/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.ErrorRef_c;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorCall_c
extends Stmt_c
implements ConstructorCall {
    protected ConstructorCall.Kind kind;
    protected Expr qualifier;
    protected List arguments;
    protected ConstructorInstance ci;

    public ConstructorCall_c(Position pos, ConstructorCall.Kind kind, Expr qualifier, List arguments) {
        super(pos);
        assert (kind != null && arguments != null);
        this.kind = kind;
        this.qualifier = qualifier;
        this.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
    }

    @Override
    public Expr qualifier() {
        return this.qualifier;
    }

    @Override
    public ConstructorCall qualifier(Expr qualifier) {
        ConstructorCall_c n = (ConstructorCall_c)this.copy();
        n.qualifier = qualifier;
        return n;
    }

    @Override
    public ConstructorCall.Kind kind() {
        return this.kind;
    }

    @Override
    public ConstructorCall kind(ConstructorCall.Kind kind) {
        ConstructorCall_c n = (ConstructorCall_c)this.copy();
        n.kind = kind;
        return n;
    }

    @Override
    public List<Expr> arguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public ProcedureCall arguments(List<Expr> arguments) {
        ConstructorCall_c n = (ConstructorCall_c)this.copy();
        n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        return n;
    }

    @Override
    public ProcedureInstance procedureInstance() {
        return this.constructorInstance();
    }

    @Override
    public ConstructorInstance constructorInstance() {
        return this.ci;
    }

    @Override
    public ConstructorCall constructorInstance(ConstructorInstance ci) {
        if (ci == this.ci) {
            return this;
        }
        ConstructorCall_c n = (ConstructorCall_c)this.copy();
        n.ci = ci;
        return n;
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushStatic();
    }

    protected ConstructorCall_c reconstruct(Expr qualifier, List arguments) {
        if (qualifier != this.qualifier || !CollectionUtil.allEqual(arguments, this.arguments)) {
            ConstructorCall_c n = (ConstructorCall_c)this.copy();
            n.qualifier = qualifier;
            n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr qualifier = (Expr)this.visitChild(this.qualifier, v);
        List arguments = this.visitList(this.arguments, v);
        return this.reconstruct(qualifier, arguments);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        if (this.kind == SUPER && tb.currentClass() == ts.Object()) {
            return tb.nodeFactory().Empty(this.position());
        }
        ConstructorCall_c n = (ConstructorCall_c)super.buildTypes(tb);
        ConstructorInstance ci = ts.createConstructorInstance(this.position(), new ErrorRef_c(ts, this.position(), "Cannot get ConstructorDef before type-checking constructor call."));
        return n.constructorInstance(ci);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        ConstructorCall_c n = this;
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ClassType ct = c.currentClass();
        Type superType = ct.superClass();
        if (this.qualifier != null) {
            if (this.kind != SUPER) {
                throw new SemanticException("Can only qualify a \"super\"constructor invocation.", this.position());
            }
            if (!superType.isClass() || !superType.toClass().isInnerClass() || superType.toClass().inStaticContext()) {
                throw new SemanticException("The class \"" + superType + "\"" + " is not an inner class, or was declared in a static " + "context; a qualified constructor invocation cannot " + "be used.", this.position());
            }
            Type qt = this.qualifier.type();
            if (!qt.isClass() || !qt.isSubtype(superType.toClass().outer(), c)) {
                throw new SemanticException("The type of the qualifier \"" + qt + "\" does not match the immediately enclosing " + "class  of the super class \"" + superType.toClass().outer() + "\".", this.qualifier.position());
            }
        }
        if (this.kind == SUPER) {
            if (!superType.isClass()) {
                throw new SemanticException("Super type of " + ct + " is not a class.", this.position());
            }
            Expr q = this.qualifier;
            if (q == null && superType.isClass() && superType.toClass().isInnerClass()) {
                Copy e;
                ClassType superContainer = superType.toClass().outer();
                for (e = ct; e != null; e = e.outer()) {
                    if (!e.isSubtype(superContainer, c) || !ct.hasEnclosingInstance((ClassType)e)) continue;
                    NodeFactory nf = tc.nodeFactory();
                    q = nf.This(this.position(), nf.CanonicalTypeNode(this.position(), (Type)e)).type((Type)e);
                    break;
                }
                if (e == null) {
                    throw new SemanticException(ct + " must have an enclosing instance" + " that is a subtype of " + superContainer, this.position());
                }
                if (e == ct) {
                    throw new SemanticException(ct + " is a subtype of " + superContainer + "; an enclosing instance that is a subtype of " + superContainer + " must be specified in the super constructor call.", this.position());
                }
            }
            if (this.qualifier != q) {
                n = (ConstructorCall_c)n.qualifier(q);
            }
        }
        ArrayList<Type> argTypes = new ArrayList<Type>();
        for (Copy e : n.arguments) {
            argTypes.add(e.type());
        }
        if (this.kind == SUPER) {
            ct = ct.superClass().toClass();
        }
        ConstructorInstance ci = ts.findConstructor(ct, ts.ConstructorMatcher(ct, argTypes, c));
        return n.constructorInstance(ci);
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.qualifier) {
            return ts.Object();
        }
        Iterator i = this.arguments.iterator();
        Iterator<Type> j = this.ci.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = (Expr)i.next();
            Type t = j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    @Override
    public String toString() {
        return (this.qualifier != null ? this.qualifier + "." : "") + this.kind + "(...)";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.qualifier != null) {
            this.print(this.qualifier, w, tr);
            w.write(".");
        }
        w.write(this.kind + "(");
        w.begin(0);
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0);
        }
        w.end();
        w.write(");");
    }

    @Override
    public Term firstChild() {
        if (this.qualifier != null) {
            return this.qualifier;
        }
        return ConstructorCall_c.listChild(this.arguments, null);
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.qualifier != null) {
            if (!this.arguments.isEmpty()) {
                v.visitCFG(this.qualifier, ConstructorCall_c.listChild(this.arguments, null), 1);
                v.visitCFGList(this.arguments, this, 0);
            } else {
                v.visitCFG(this.qualifier, this, 0);
            }
        } else if (!this.arguments.isEmpty()) {
            v.visitCFGList(this.arguments, this, 0);
        }
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> l = new ArrayList<Type>();
        l.addAll(this.ci.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        return l;
    }
}

