/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Ambiguous;
import polyglot.ast.Disamb;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode;
import polyglot.ast.Prefix;
import polyglot.ast.QualifierNode;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.TypeNode;
import polyglot.frontend.Globals;
import polyglot.frontend.Goal;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.LazyRef;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.NoMemberException;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.Qualifier;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.VarInstance;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public class Disamb_c
implements Disamb {
    protected ContextVisitor v;
    protected Position pos;
    protected Node prefix;
    protected Id name;
    protected NodeFactory nf;
    protected TypeSystem ts;
    protected Context c;
    protected Ambiguous amb;

    public Node disambiguate(Ambiguous amb, ContextVisitor v, Position pos, Prefix prefix, String name) throws SemanticException {
        return this.disambiguate(amb, v, pos, (Node)prefix, v.nodeFactory().Id(pos, name));
    }

    public Node disambiguate(Ambiguous amb, ContextVisitor v, Position pos, Node prefix, Id name) throws SemanticException {
        this.v = v;
        this.pos = pos;
        this.prefix = prefix;
        this.name = name;
        this.amb = amb;
        this.nf = v.nodeFactory();
        this.ts = v.typeSystem();
        this.c = v.context();
        if (prefix instanceof Ambiguous) {
            throw new SemanticException("Cannot disambiguate node with ambiguous prefix.");
        }
        Node result = null;
        if (prefix instanceof PackageNode) {
            PackageNode pn = (PackageNode)prefix;
            result = this.disambiguatePackagePrefix(pn);
        } else if (prefix instanceof TypeNode) {
            TypeNode tn = (TypeNode)prefix;
            result = this.disambiguateTypeNodePrefix(tn);
        } else if (prefix instanceof Expr) {
            Expr e = (Expr)prefix;
            result = this.disambiguateExprPrefix(e);
        } else if (prefix == null) {
            result = this.disambiguateNoPrefix();
        }
        assert (!(result instanceof Ambiguous));
        return result;
    }

    protected Node disambiguatePackagePrefix(PackageNode pn) throws SemanticException {
        Named n;
        Resolver pc = this.ts.packageContextResolver(pn.package_().get());
        try {
            n = pc.find(this.ts.TypeMatcher(this.name.id()));
        }
        catch (SemanticException e) {
            n = null;
        }
        Qualifier q = null;
        if (n instanceof Qualifier) {
            q = (Qualifier)((Object)n);
        } else if (n == null) {
            Package p = this.ts.createPackage(pn.package_(), this.name.id());
            q = p;
        } else {
            return null;
        }
        if (q.isPackage() && this.packageOK()) {
            return this.nf.PackageNode(this.pos, Types.ref(q.toPackage()));
        }
        if (q.isType() && this.typeOK()) {
            return this.makeTypeNode(q.toType());
        }
        return null;
    }

    protected Node disambiguateTypeNodePrefix(TypeNode tn) throws SemanticException {
        Type t;
        block7: {
            t = tn.type();
            if (this.exprOK()) {
                try {
                    FieldInstance fi = this.ts.findField(t, this.ts.FieldMatcher(t, this.name.id(), this.c));
                    return this.nf.Field(this.pos, tn, this.name).fieldInstance(fi);
                }
                catch (NoMemberException e) {
                    if (e.getKind() == 3) break block7;
                    throw e;
                }
            }
        }
        if (t.isClass() && this.typeOK()) {
            Named n;
            Resolver tc = t.toClass().resolver();
            try {
                n = tc.find(this.ts.MemberTypeMatcher(t, this.name.id(), this.c));
            }
            catch (NoClassException e) {
                return null;
            }
            if (n instanceof Type) {
                Type type = (Type)((Object)n);
                return this.makeTypeNode(type);
            }
        }
        return null;
    }

    protected Node disambiguateExprPrefix(Expr e) throws SemanticException {
        if (this.exprOK()) {
            return this.nf.Field(this.pos, e, this.name);
        }
        return null;
    }

    protected Node disambiguateNoPrefix() throws SemanticException {
        block8: {
            Node n;
            VarInstance<?> vi;
            if (this.exprOK() && (vi = this.c.findVariableSilent(this.name.id())) != null && (n = this.disambiguateVarInstance(vi)) != null) {
                return n;
            }
            if (this.typeOK()) {
                try {
                    Named n2 = this.c.find(this.ts.TypeMatcher(this.name.id()));
                    if (n2 instanceof Type) {
                        Type type = (Type)((Object)n2);
                        return this.makeTypeNode(type);
                    }
                }
                catch (NoClassException e) {
                    if (this.name.id().toString().equals(e.getClassName())) break block8;
                    throw e;
                }
            }
        }
        if (this.packageOK()) {
            try {
                Package p = this.ts.packageForName(QName.make(null, this.name.id()));
                return this.nf.PackageNode(this.pos, Types.ref(p));
            }
            catch (SemanticException e) {
                Package p = this.ts.createPackage(QName.make(null, this.name.id()));
                return this.nf.PackageNode(this.pos, Types.ref(p));
            }
        }
        return null;
    }

    protected Node disambiguateVarInstance(VarInstance vi) throws SemanticException {
        if (vi instanceof FieldInstance) {
            FieldInstance fi = (FieldInstance)vi;
            Receiver r = this.makeMissingFieldTarget(fi);
            return this.nf.Field(this.pos, r, this.name).fieldInstance(fi).targetImplicit(true);
        }
        if (vi instanceof LocalInstance) {
            LocalInstance li = (LocalInstance)vi;
            return this.nf.Local(this.pos, this.name).localInstance(li);
        }
        return null;
    }

    protected Receiver makeMissingFieldTarget(FieldInstance fi) throws SemanticException {
        Receiver r;
        if (fi.flags().isStatic()) {
            r = this.nf.CanonicalTypeNode(this.pos.startOf(), fi.container());
        } else {
            ClassType scope = this.c.findFieldScope(this.name.id());
            assert (scope != null);
            r = !this.ts.typeEquals(scope, this.c.currentClass(), this.c) ? (Special)this.nf.This(this.pos.startOf(), this.nf.CanonicalTypeNode(this.pos.startOf(), scope)).del().typeCheck(this.v) : (Special)this.nf.This(this.pos.startOf()).del().typeCheck(this.v);
        }
        return r;
    }

    protected Receiver makeMissingMethodTarget(MethodInstance mi) throws SemanticException {
        Receiver r;
        if (mi.flags().isStatic()) {
            r = this.nf.CanonicalTypeNode(this.pos.startOf(), mi.container());
        } else {
            ClassType scope = this.c.findMethodScope(this.name.id());
            assert (scope != null);
            r = !this.ts.typeEquals(scope, this.c.currentClass(), this.c) ? (Special)this.nf.This(this.pos.startOf(), this.nf.CanonicalTypeNode(this.pos.startOf(), scope)).del().typeCheck(this.v) : (Special)this.nf.This(this.pos.startOf()).del().typeCheck(this.v);
        }
        return r;
    }

    protected boolean typeOK() {
        return !(this.amb instanceof Expr) && (this.amb instanceof TypeNode || this.amb instanceof QualifierNode || this.amb instanceof Receiver || this.amb instanceof Prefix);
    }

    protected boolean packageOK() {
        return !(this.amb instanceof Receiver) && (this.amb instanceof QualifierNode || this.amb instanceof Prefix);
    }

    protected boolean exprOK() {
        return !(this.amb instanceof QualifierNode) && !(this.amb instanceof TypeNode) && (this.amb instanceof Expr || this.amb instanceof Receiver || this.amb instanceof Prefix);
    }

    protected Node makeTypeNode(Type t) {
        TypeNode tn;
        if (this.amb instanceof TypeNode && (tn = (TypeNode)((Object)this.amb)).typeRef() instanceof LazyRef) {
            LazyRef sym2 = (LazyRef)tn.typeRef();
            sym2.update(t);
            Goal resolver = Globals.Scheduler().LookupGlobalType(sym2);
            resolver.update(Goal.Status.SUCCESS);
            sym2.setResolver(resolver);
            return this.nf.CanonicalTypeNode(this.pos, sym2);
        }
        return this.nf.CanonicalTypeNode(this.pos, t);
    }

    public String toString() {
        return "Disamb(" + this.amb.getClass().getName() + ": " + this.amb + ")";
    }
}

