/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.FlagsNode;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.frontend.AbstractGoal_c;
import polyglot.frontend.Goal;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.CodeDef;
import polyglot.types.Context;
import polyglot.types.Def;
import polyglot.types.FieldDef;
import polyglot.types.Flags;
import polyglot.types.InitializerDef;
import polyglot.types.LazyRef;
import polyglot.types.MemberDef;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.UnknownType;
import polyglot.types.VarDef;
import polyglot.types.VarDef_c;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeCheckPreparer;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDecl_c
extends Term_c
implements FieldDecl {
    protected FlagsNode flags;
    protected TypeNode type;
    protected Id name;
    protected Expr init;
    protected FieldDef fi;
    protected InitializerDef ii;

    public FieldDecl_c(Position pos, FlagsNode flags, TypeNode type, Id name, Expr init) {
        super(pos);
        assert (flags != null && type != null && name != null);
        this.flags = flags;
        this.type = type;
        this.name = name;
        this.init = init;
    }

    public List<Def> defs() {
        if (this.init == null) {
            return Collections.singletonList(this.fi);
        }
        return CollectionUtil.list(this.fi, this.ii, new Def[0]);
    }

    @Override
    public MemberDef memberDef() {
        return this.fi;
    }

    @Override
    public VarDef varDef() {
        return this.fi;
    }

    @Override
    public CodeDef codeDef() {
        return this.ii;
    }

    @Override
    public InitializerDef initializerDef() {
        return this.ii;
    }

    @Override
    public FieldDecl initializerDef(InitializerDef ii) {
        if (ii == this.ii) {
            return this;
        }
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.ii = ii;
        return n;
    }

    @Override
    public Type declType() {
        return this.type.type();
    }

    @Override
    public FlagsNode flags() {
        return this.flags;
    }

    @Override
    public FieldDecl flags(FlagsNode flags) {
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    @Override
    public TypeNode type() {
        return this.type;
    }

    @Override
    public FieldDecl type(TypeNode type) {
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.type = type;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public FieldDecl name(Id name) {
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public Term codeBody() {
        return this.init;
    }

    @Override
    public Expr init() {
        return this.init;
    }

    @Override
    public FieldDecl init(Expr init) {
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.init = init;
        return n;
    }

    @Override
    public FieldDecl fieldDef(FieldDef fi) {
        if (fi == this.fi) {
            return this;
        }
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.fi = fi;
        return n;
    }

    @Override
    public FieldDef fieldDef() {
        return this.fi;
    }

    protected FieldDecl_c reconstruct(FlagsNode flags, TypeNode type, Id name, Expr init) {
        if (this.flags != flags || this.type != type || this.name != name || this.init != init) {
            FieldDecl_c n = (FieldDecl_c)this.copy();
            n.flags = flags;
            n.type = type;
            n.name = name;
            n.init = init;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        FieldDecl_c n = (FieldDecl_c)this.visitSignature(v);
        Expr init = (Expr)n.visitChild(n.init, v);
        return init == n.init ? n : n.init(init);
    }

    @Override
    public Node buildTypesOverride(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ClassDef ct = tb.currentClass();
        assert (ct != null);
        Flags flags = this.flags.flags();
        if (ct.flags().isInterface()) {
            flags = flags.Public().Static().Final();
        }
        FieldDef fi = this.createFieldDef(ts, ct, flags);
        ct.addField(fi);
        TypeBuilder tbChk = tb.pushDef(fi);
        InitializerDef ii = null;
        if (this.init != null) {
            Flags iflags = flags.isStatic() ? Flags.STATIC : Flags.NONE;
            ii = this.createInitializerDef(ts, ct, iflags);
            fi.setInitializer(ii);
            tbChk = tbChk.pushCode(ii);
        }
        final TypeBuilder tbx = tb;
        final FieldDef mix = fi;
        FieldDecl_c n = (FieldDecl_c)this.visitSignature(new NodeVisitor(){

            public Node override(Node n) {
                return FieldDecl_c.this.visitChild(n, tbx.pushDef(mix));
            }
        });
        fi.setType(n.type().typeRef());
        Expr init = (Expr)n.visitChild(n.init, tbChk);
        n = (FieldDecl_c)n.init(init);
        n = (FieldDecl_c)n.fieldDef(fi);
        if (ii != null) {
            n = (FieldDecl_c)n.initializerDef(ii);
        }
        n = (FieldDecl_c)n.flags(n.flags.flags(flags));
        return n;
    }

    protected InitializerDef createInitializerDef(TypeSystem ts, ClassDef ct, Flags iflags) {
        InitializerDef ii = ts.initializerDef(this.init.position(), Types.ref(ct.asType()), iflags);
        return ii;
    }

    protected FieldDef createFieldDef(TypeSystem ts, ClassDef ct, Flags flags) {
        FieldDef fi = ts.fieldDef(this.position(), Types.ref(ct.asType()), flags, this.type.typeRef(), this.name.id());
        return fi;
    }

    @Override
    public Context enterScope(Context c) {
        if (this.ii != null) {
            return c.pushCode(this.ii);
        }
        return c;
    }

    @Override
    public void setResolver(final Node parent, TypeCheckPreparer v) {
        final FieldDef def = this.fieldDef();
        Ref<VarDef_c.ConstantValue> rx = def.constantValueRef();
        if (rx instanceof LazyRef) {
            LazyRef r = (LazyRef)rx;
            TypeChecker tc0 = new TypeChecker(v.job(), v.typeSystem(), v.nodeFactory(), v.getMemo());
            final TypeChecker tc = (TypeChecker)tc0.context(v.context().freeze());
            final FieldDecl_c n = this;
            r.setResolver(new AbstractGoal_c("ConstantValue"){

                public boolean runTask() {
                    if (this.state() == Goal.Status.RUNNING_RECURSIVE || this.state() == Goal.Status.RUNNING_WILL_FAIL) {
                        def.setNotConstant();
                    } else {
                        Node m = parent.visitChild(n, tc);
                        tc.job().nodeMemo().put(n, m);
                        tc.job().nodeMemo().put(m, m);
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public Node checkConstants(ContextVisitor tc) throws SemanticException {
        if (this.init == null || !this.init.isConstant() || !this.fi.flags().isFinal()) {
            this.fi.setNotConstant();
        } else {
            this.fi.setConstantValue(this.init.constantValue());
        }
        return this;
    }

    public Node visitSignature(NodeVisitor v) {
        FlagsNode flags = (FlagsNode)this.visitChild(this.flags, v);
        TypeNode type = (TypeNode)this.visitChild(this.type, v);
        Id name = (Id)this.visitChild(this.name, v);
        return this.reconstruct(flags, type, name, this.init);
    }

    public Node typeCheckBody(Node parent, TypeChecker tc, TypeChecker childtc) throws SemanticException {
        FieldDecl_c n = this;
        Expr init = (Expr)n.visitChild(n.init, childtc);
        n = (FieldDecl_c)n.init(init);
        return n.checkConstants(tc);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (this.init != null && !(this.init.type() instanceof UnknownType)) {
            if (this.init instanceof ArrayInit) {
                ((ArrayInit)this.init).typeCheckElements(tc, this.type.type());
            } else if (!(ts.isImplicitCastValid(this.init.type(), this.type.type(), tc.context()) || ts.typeEquals(this.init.type(), this.type.type(), tc.context()) || ts.numericConversionValid(this.type.type(), this.init.constantValue(), tc.context()))) {
                throw new SemanticException("The type of the variable initializer \"" + this.init.type() + "\" does not match that of " + "the declaration \"" + this.type.type() + "\".", this.init.position());
            }
        }
        return this;
    }

    @Override
    public Node conformanceCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Flags flags = this.fi.flags();
        try {
            ts.checkFieldFlags(flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        Type fcontainer = Types.get(this.fieldDef().container());
        if (fcontainer.isClass()) {
            ClassType container = fcontainer.toClass();
            if (container.flags().isInterface() && (flags.isProtected() || flags.isPrivate())) {
                throw new SemanticException("Interface members must be public.", this.position());
            }
            if (flags.isStatic() && container.isInnerClass() && (!flags.isFinal() || this.init == null || !this.init.isConstant())) {
                throw new SemanticException("Inner classes cannot declare static fields, unless they are compile-time constant fields.", this.position());
            }
        }
        return this;
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push(new ExceptionChecker.CodeTypeReporter("A field initializer"));
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.init) {
            TypeSystem ts = av.typeSystem();
            if (ts.numericConversionValid(this.type.type(), child.constantValue(), av.context())) {
                return child.type();
            }
            return this.type.type();
        }
        return child.type();
    }

    @Override
    public Term firstChild() {
        return this.type;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.init != null) {
            v.visitCFG(this.type, this.init, 1);
            v.visitCFG(this.init, this, 0);
        } else {
            v.visitCFG(this.type, this, 0);
        }
        return succs;
    }

    @Override
    public String toString() {
        return this.flags.flags().translate() + this.type + " " + this.name + (this.init != null ? " = " + this.init : "");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        boolean isInterface = this.fi != null && this.fi.container() != null && this.fi.container().get().toClass().flags().isInterface();
        Flags f = this.flags.flags();
        if (isInterface) {
            f = f.clearPublic();
            f = f.clearStatic();
            f = f.clearFinal();
        }
        w.write(f.translate());
        this.print(this.type, w, tr);
        w.allowBreak(2, 2, " ", 1);
        tr.print(this, this.name, w);
        if (this.init != null) {
            w.write(" =");
            w.allowBreak(2, " ");
            this.print(this.init, w, tr);
        }
        w.write(";");
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.fi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.fi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
    }
}

