/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.FlagsNode;
import polyglot.ast.Initializer;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.CodeDef;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Def;
import polyglot.types.Flags;
import polyglot.types.InitializerDef;
import polyglot.types.MemberDef;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SubtypeSet;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Initializer_c
extends Term_c
implements Initializer {
    protected FlagsNode flags;
    protected Block body;
    protected InitializerDef ii;

    public Initializer_c(Position pos, FlagsNode flags, Block body) {
        super(pos);
        assert (flags != null && body != null);
        this.flags = flags;
        this.body = body;
    }

    public List<Def> defs() {
        return Collections.singletonList(this.ii);
    }

    @Override
    public MemberDef memberDef() {
        return this.ii;
    }

    @Override
    public FlagsNode flags() {
        return this.flags;
    }

    @Override
    public Initializer flags(FlagsNode flags) {
        Initializer_c n = (Initializer_c)this.copy();
        n.flags = flags;
        return n;
    }

    @Override
    public InitializerDef initializerDef() {
        return this.ii;
    }

    @Override
    public CodeDef codeDef() {
        return this.initializerDef();
    }

    @Override
    public Initializer initializerDef(InitializerDef ii) {
        if (ii == this.ii) {
            return this;
        }
        Initializer_c n = (Initializer_c)this.copy();
        n.ii = ii;
        return n;
    }

    @Override
    public Term codeBody() {
        return this.body;
    }

    @Override
    public Block body() {
        return this.body;
    }

    @Override
    public CodeBlock body(Block body) {
        Initializer_c n = (Initializer_c)this.copy();
        n.body = body;
        return n;
    }

    protected Initializer_c reconstruct(FlagsNode flags, Block body) {
        if (flags != this.flags || body != this.body) {
            Initializer_c n = (Initializer_c)this.copy();
            n.flags = flags;
            n.body = body;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        FlagsNode flags = (FlagsNode)this.visitChild(this.flags, v);
        Block body = (Block)this.visitChild(this.body, v);
        return this.reconstruct(flags, body);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushCode(this.ii);
    }

    @Override
    public Term firstChild() {
        return this.body();
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG(this.body(), this, 0);
        return succs;
    }

    @Override
    public Node buildTypesOverride(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ClassDef ct = tb.currentClass();
        assert (ct != null);
        Flags flags = this.flags.flags();
        InitializerDef ii = this.createInitializerDef(ts, ct, flags);
        TypeBuilder tbChk = tb.pushCode(ii);
        final TypeBuilder tbx = tb;
        final InitializerDef mix = ii;
        Initializer_c n = (Initializer_c)this.visitSignature(new NodeVisitor(){

            public Node override(Node n) {
                return Initializer_c.this.visitChild(n, tbx.pushCode(mix));
            }
        });
        Block body = (Block)n.visitChild(n.body, tbChk);
        n = (Initializer_c)n.body(body);
        n = (Initializer_c)n.initializerDef(ii);
        return n;
    }

    protected InitializerDef createInitializerDef(TypeSystem ts, ClassDef ct, Flags flags) {
        InitializerDef ii = ts.initializerDef(this.position(), Types.ref(ct.asType()), flags);
        return ii;
    }

    public Node visitSignature(NodeVisitor v) {
        return this;
    }

    public Node typeCheckBody(Node parent, TypeChecker tc, TypeChecker childtc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Block body = this.body;
        body = (Block)this.visitChild(this.body, childtc);
        Initializer_c n = this.reconstruct(this.flags, body);
        n = (Initializer_c)tc.leave(parent, this, n, childtc);
        return n;
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Flags flags = this.flags.flags();
        try {
            ts.checkInitializerFlags(flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (flags.isStatic() && this.initializerDef().container().get().toClass().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare static initializers.", this.position());
        }
        return this;
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        if (this.initializerDef().flags().isStatic()) {
            return ec.push(new ExceptionChecker.CodeTypeReporter("A static initializer block"));
        }
        if (!this.initializerDef().container().get().toClass().isAnonymous()) {
            ec = ec.push(new ExceptionChecker.CodeTypeReporter("An instance initializer block"));
            SubtypeSet allowed = null;
            Type throwable = ec.typeSystem().Throwable();
            ClassType container = this.initializerDef().container().get().toClass();
            for (ConstructorInstance ci : container.constructors()) {
                if (allowed == null) {
                    allowed = new SubtypeSet(throwable);
                    allowed.addAll((Collection<? extends Type>)ci.throwTypes());
                    continue;
                }
                SubtypeSet other = new SubtypeSet(throwable);
                other.addAll((Collection<? extends Type>)ci.throwTypes());
                SubtypeSet inter = new SubtypeSet(throwable);
                for (Type t : allowed) {
                    if (!other.contains(t)) continue;
                    inter.add(t);
                }
                for (Type t : other) {
                    if (!allowed.contains(t)) continue;
                    inter.add(t);
                }
                allowed = inter;
            }
            ec = ec.push(allowed);
            return ec;
        }
        return ec.push();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        this.print(this.flags, w, tr);
        this.print(this.body, w, tr);
        w.end();
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.ii != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.ii + ")");
            w.end();
        }
    }

    @Override
    public String toString() {
        return this.flags.flags().translate() + "{ ... }";
    }
}

