/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.NumLit_c;
import polyglot.ast.Precedence;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;

public class IntLit_c
extends NumLit_c
implements IntLit {
    protected IntLit.Kind kind;

    public IntLit_c(Position pos, IntLit.Kind kind, long value) {
        super(pos, value);
        assert (kind != null);
        this.kind = kind;
    }

    public boolean boundary() {
        return this.kind == INT && (int)this.value == Integer.MIN_VALUE || this.kind == LONG && this.value == Long.MIN_VALUE;
    }

    public long value() {
        return this.longValue();
    }

    public IntLit value(long value) {
        IntLit_c n = (IntLit_c)this.copy();
        n.value = value;
        return n;
    }

    public IntLit.Kind kind() {
        return this.kind;
    }

    public IntLit kind(IntLit.Kind kind) {
        IntLit_c n = (IntLit_c)this.copy();
        n.kind = kind;
        return n;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        IntLit.Kind kind = this.kind();
        if (kind == INT) {
            return this.type(ts.Int());
        }
        if (kind == LONG) {
            return this.type(ts.Long());
        }
        throw new InternalCompilerError("Unrecognized IntLit kind " + kind);
    }

    public String positiveToString() {
        if (this.kind() == LONG) {
            if (this.boundary()) {
                return "9223372036854775808L";
            }
            if (this.value < 0L) {
                return "0x" + Long.toHexString(this.value) + "L";
            }
            return Long.toString(this.value) + "L";
        }
        if (this.boundary()) {
            return "2147483648";
        }
        if ((int)this.value < 0) {
            return "0x" + Integer.toHexString((int)this.value);
        }
        return Integer.toString((int)this.value);
    }

    public String toString() {
        if (this.kind() == LONG) {
            return Long.toString(this.value) + "L";
        }
        return Long.toString((int)this.value);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.toString());
    }

    public Object constantValue() {
        if (this.kind() == LONG) {
            return this.value;
        }
        return (int)this.value;
    }

    public Precedence precedence() {
        if (this.value < 0L && !this.boundary()) {
            return Precedence.UNARY;
        }
        return Precedence.LITERAL;
    }
}

