/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import polyglot.ast.ClassDecl;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeList;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalClassDecl_c
extends Stmt_c
implements LocalClassDecl {
    protected ClassDecl decl;

    public LocalClassDecl_c(Position pos, ClassDecl decl) {
        super(pos);
        assert (decl != null);
        this.decl = decl;
    }

    @Override
    public ClassDecl decl() {
        return this.decl;
    }

    @Override
    public LocalClassDecl decl(ClassDecl decl) {
        LocalClassDecl_c n = (LocalClassDecl_c)this.copy();
        n.decl = decl;
        return n;
    }

    protected LocalClassDecl_c reconstruct(ClassDecl decl) {
        if (decl != this.decl) {
            LocalClassDecl_c n = (LocalClassDecl_c)this.copy();
            n.decl = decl;
            return n;
        }
        return this;
    }

    @Override
    public Term firstChild() {
        return this.decl();
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG(this.decl(), this, 0);
        return succs;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Node decl = this.visitChild(this.decl, v);
        if (decl instanceof NodeList) {
            NodeList nl = (NodeList)decl;
            ArrayList<Node> decls = new ArrayList<Node>(nl.nodes());
            ListIterator<LocalClassDecl_c> it = decls.listIterator();
            while (it.hasNext()) {
                ClassDecl cd = (ClassDecl)it.next();
                it.set(this.reconstruct(cd));
            }
            return nl.nodes(decls);
        }
        return this.reconstruct((ClassDecl)decl);
    }

    @Override
    public void addDecls(Context c) {
        if (!this.decl.classDef().isLocal()) {
            throw new InternalCompilerError("Non-local " + this.decl.classDef() + " found in method body.");
        }
        c.addNamed(this.decl.classDef().asType());
    }

    @Override
    public String toString() {
        return this.decl.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printBlock(this.decl, w, tr);
        w.write(";");
    }
}

