/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.FlagsNode;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.main.Report;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.CodeDef;
import polyglot.types.Context;
import polyglot.types.Def;
import polyglot.types.Flags;
import polyglot.types.MemberDef;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.ProcedureDef;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDecl_c
extends Term_c
implements MethodDecl {
    protected FlagsNode flags;
    protected TypeNode returnType;
    protected Id name;
    protected List<Formal> formals;
    protected List<TypeNode> throwTypes;
    protected Block body;
    protected MethodDef mi;
    private static final Collection TOPICS = CollectionUtil.list("types", "context", new String[0]);

    public MethodDecl_c(Position pos, FlagsNode flags, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        super(pos);
        assert (flags != null && returnType != null && name != null && formals != null && throwTypes != null);
        this.flags = flags;
        this.returnType = returnType;
        this.name = name;
        this.formals = TypedList.copyAndCheck(formals, Formal.class, true);
        this.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
        this.body = body;
    }

    public List<Def> defs() {
        return Collections.singletonList(this.mi);
    }

    @Override
    public MemberDef memberDef() {
        return this.mi;
    }

    @Override
    public FlagsNode flags() {
        return this.flags;
    }

    @Override
    public MethodDecl flags(FlagsNode flags) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    @Override
    public TypeNode returnType() {
        return this.returnType;
    }

    @Override
    public MethodDecl returnType(TypeNode returnType) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.returnType = returnType;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public MethodDecl name(Id name) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public List<Formal> formals() {
        return Collections.unmodifiableList(this.formals);
    }

    @Override
    public MethodDecl formals(List<Formal> formals) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.formals = TypedList.copyAndCheck(formals, Formal.class, true);
        return n;
    }

    @Override
    public List<TypeNode> throwTypes() {
        return Collections.unmodifiableList(this.throwTypes);
    }

    @Override
    public MethodDecl throwTypes(List<TypeNode> throwTypes) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
        return n;
    }

    @Override
    public Term codeBody() {
        return this.body;
    }

    @Override
    public Block body() {
        return this.body;
    }

    @Override
    public CodeBlock body(Block body) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.body = body;
        return n;
    }

    @Override
    public MethodDef methodDef() {
        return this.mi;
    }

    @Override
    public MethodDecl methodDef(MethodDef mi) {
        if (mi == this.mi) {
            return this;
        }
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.mi = mi;
        return n;
    }

    @Override
    public CodeDef codeDef() {
        return this.procedureInstance();
    }

    @Override
    public ProcedureDef procedureInstance() {
        return this.mi;
    }

    protected MethodDecl_c reconstruct(FlagsNode flags, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        if (flags != this.flags || returnType != this.returnType || name != this.name || !CollectionUtil.allEqual(formals, this.formals) || !CollectionUtil.allEqual(throwTypes, this.throwTypes) || body != this.body) {
            MethodDecl_c n = (MethodDecl_c)this.copy();
            n.flags = flags;
            n.returnType = returnType;
            n.name = name;
            n.formals = TypedList.copyAndCheck(formals, Formal.class, true);
            n.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
            n.body = body;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        MethodDecl_c n = (MethodDecl_c)this.visitSignature(v);
        Block body = (Block)n.visitChild(n.body, v);
        return body == n.body ? n : n.body(body);
    }

    @Override
    public Node buildTypesOverride(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ClassDef ct = tb.currentClass();
        assert (ct != null);
        Flags flags = this.flags.flags();
        if (ct.flags().isInterface()) {
            flags = flags.Public().Abstract();
        }
        MethodDef mi = this.createMethodDef(ts, ct, flags);
        ct.addMethod(mi);
        TypeBuilder tbChk = tb.pushCode(mi);
        final TypeBuilder tbx = tb;
        final MethodDef mix = mi;
        MethodDecl_c n = (MethodDecl_c)this.visitSignature(new NodeVisitor(){

            public Node override(Node n) {
                return MethodDecl_c.this.visitChild(n, tbx.pushCode(mix));
            }
        });
        ArrayList<Ref<? extends Type>> formalTypes = new ArrayList<Ref<? extends Type>>(n.formals().size());
        for (Formal f : n.formals()) {
            formalTypes.add(f.type().typeRef());
        }
        ArrayList<Ref<? extends Type>> throwTypes = new ArrayList<Ref<? extends Type>>(n.throwTypes().size());
        for (TypeNode tn : n.throwTypes()) {
            throwTypes.add(tn.typeRef());
        }
        mi.setReturnType(n.returnType().typeRef());
        mi.setFormalTypes(formalTypes);
        mi.setThrowTypes(throwTypes);
        Block body = (Block)n.visitChild(n.body, tbChk);
        n = (MethodDecl_c)n.body(body);
        return n.methodDef(mi);
    }

    protected MethodDef createMethodDef(TypeSystem ts, ClassDef ct, Flags flags) {
        MethodDef mi = ts.methodDef(this.position(), Types.ref(ct.asType()), flags, this.returnType.typeRef(), this.name.id(), Collections.<Ref<Type>>emptyList(), Collections.<Ref<Type>>emptyList());
        return mi;
    }

    @Override
    public Context enterScope(Context c) {
        if (Report.should_report(TOPICS, 5)) {
            Report.report(5, "enter scope of method " + this.name);
        }
        c = c.pushCode(this.mi);
        return c;
    }

    public Node visitSignature(NodeVisitor v) {
        TypeNode returnType = (TypeNode)this.visitChild(this.returnType, v);
        FlagsNode flags = (FlagsNode)this.visitChild(this.flags, v);
        Id name = (Id)this.visitChild(this.name, v);
        List formals = this.visitList(this.formals, v);
        List throwTypes = this.visitList(this.throwTypes, v);
        return this.reconstruct(flags, returnType, name, formals, throwTypes, this.body);
    }

    public Node typeCheckBody(Node parent, TypeChecker tc, TypeChecker childtc) throws SemanticException {
        MethodDecl_c n = this;
        Block body = (Block)n.visitChild(n.body, childtc);
        n = (MethodDecl_c)n.body(body);
        return n;
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        for (TypeNode tn : this.throwTypes()) {
            Type t = tn.type();
            if (t.isThrowable()) continue;
            throw new SemanticException("Type \"" + t + "\" is not a subclass of \"" + ts.Throwable() + "\".", tn.position());
        }
        return this;
    }

    @Override
    public Node conformanceCheck(ContextVisitor tc) throws SemanticException {
        Flags flags = this.mi.flags();
        this.checkFlags(tc, flags);
        this.overrideMethodCheck(tc);
        return this;
    }

    protected void checkFlags(ContextVisitor tc, Flags flags) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (tc.context().currentClass().flags().isInterface()) {
            if (flags.isProtected() || flags.isPrivate()) {
                throw new SemanticException("Interface methods must be public.", this.position());
            }
            if (flags.isStatic()) {
                throw new SemanticException("Interface methods cannot be static.", this.position());
            }
        }
        try {
            ts.checkMethodFlags(flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        Type container = Types.get(this.methodDef().container());
        ClassType ct = container.toClass();
        if (this.body == null && !flags.isAbstract() && !flags.isNative()) {
            throw new SemanticException("Missing method body.", this.position());
        }
        if (this.body != null && ct.flags().isInterface()) {
            throw new SemanticException("Interface methods cannot have a body.", this.position());
        }
        if (this.body != null && flags.isAbstract()) {
            throw new SemanticException("An abstract method cannot have a body.", this.position());
        }
        if (this.body != null && flags.isNative()) {
            throw new SemanticException("A native method cannot have a body.", this.position());
        }
        if (ct != null && flags.isStatic() && ct.isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare static methods.", this.position());
        }
    }

    protected void overrideMethodCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        MethodInstance mi = this.mi.asInstance();
        for (MethodInstance mj : mi.implemented(tc.context())) {
            if (!ts.isAccessible(mj, tc.context())) continue;
            ts.checkOverride(mi, mj, tc.context());
        }
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push(new ExceptionChecker.CodeTypeReporter("Method " + this.mi.signature())).push(this.methodDef().asInstance().throwTypes());
    }

    @Override
    public String toString() {
        return this.flags.flags().translate() + this.returnType + " " + this.name + "(...)";
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        this.print(this.flags, w, tr);
        this.print(this.returnType, w, tr);
        w.allowBreak(2, 2, " ", 1);
        w.write(this.name + "(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator<Term> i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = i.next();
            this.print(f, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (!this.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = this.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.prettyPrintHeader(w, tr);
        if (this.body != null) {
            this.printSubStmt(this.body, w, tr);
        } else {
            w.write(";");
        }
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.mi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.mi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
    }

    @Override
    public Term firstChild() {
        return MethodDecl_c.listChild(this.formals(), this.returnType());
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFGList(this.formals(), this.returnType(), 1);
        if (this.body() == null) {
            v.visitCFG(this.returnType(), this, 0);
        } else {
            v.visitCFG(this.returnType(), this.body(), 1);
            v.visitCFG(this.body(), this, 0);
        }
        return succs;
    }
}

