/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewArray_c
extends Expr_c
implements NewArray {
    protected TypeNode baseType;
    protected List dims;
    protected int addDims;
    protected ArrayInit init;

    public NewArray_c(Position pos, TypeNode baseType, List dims, int addDims, ArrayInit init) {
        super(pos);
        assert (baseType != null && dims != null);
        assert (addDims >= 0);
        assert (!dims.isEmpty() || init != null);
        assert (addDims > 0 || init == null);
        assert (dims.size() + addDims > 0);
        this.baseType = baseType;
        this.dims = TypedList.copyAndCheck(dims, Expr.class, true);
        this.addDims = addDims;
        this.init = init;
    }

    @Override
    public TypeNode baseType() {
        return this.baseType;
    }

    @Override
    public NewArray baseType(TypeNode baseType) {
        NewArray_c n = (NewArray_c)this.copy();
        n.baseType = baseType;
        return n;
    }

    public List dims() {
        return Collections.unmodifiableList(this.dims);
    }

    public NewArray dims(List dims) {
        NewArray_c n = (NewArray_c)this.copy();
        n.dims = TypedList.copyAndCheck(dims, Expr.class, true);
        return n;
    }

    @Override
    public int numDims() {
        return this.dims.size() + this.addDims;
    }

    @Override
    public int additionalDims() {
        return this.addDims;
    }

    @Override
    public NewArray additionalDims(int addDims) {
        NewArray_c n = (NewArray_c)this.copy();
        n.addDims = addDims;
        return n;
    }

    @Override
    public ArrayInit init() {
        return this.init;
    }

    @Override
    public NewArray init(ArrayInit init) {
        NewArray_c n = (NewArray_c)this.copy();
        n.init = init;
        return n;
    }

    protected NewArray_c reconstruct(TypeNode baseType, List dims, ArrayInit init) {
        if (baseType != this.baseType || !CollectionUtil.allEqual(dims, this.dims) || init != this.init) {
            NewArray_c n = (NewArray_c)this.copy();
            n.baseType = baseType;
            n.dims = TypedList.copyAndCheck(dims, Expr.class, true);
            n.init = init;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode baseType = (TypeNode)this.visitChild(this.baseType, v);
        List dims = this.visitList(this.dims, v);
        ArrayInit init = (ArrayInit)this.visitChild(this.init, v);
        return this.reconstruct(baseType, dims, init);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        for (Expr expr : this.dims) {
            if (ts.isImplicitCastValid(expr.type(), ts.Int(), tc.context())) continue;
            throw new SemanticException("Array dimension must be an integer.", expr.position());
        }
        Type type = ts.arrayOf(this.baseType.type(), this.dims.size() + this.addDims);
        if (this.init != null) {
            this.init.typeCheckElements(tc, type);
        }
        return this.type(type);
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.init) {
            return this.type();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "new " + this.baseType + "[...]";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("new ");
        this.print(this.baseType, w, tr);
        for (Expr e : this.dims) {
            w.write("[");
            this.printBlock(e, w, tr);
            w.write("]");
        }
        for (int i = 0; i < this.addDims; ++i) {
            w.write("[]");
        }
        if (this.init != null) {
            w.write(" ");
            this.print(this.init, w, tr);
        }
    }

    @Override
    public Term firstChild() {
        return this.baseType;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.init != null) {
            v.visitCFG(this.baseType, NewArray_c.listChild(this.dims, this.init), 1);
            v.visitCFGList(this.dims, this.init, 1);
            v.visitCFG(this.init, this, 0);
        } else {
            v.visitCFG(this.baseType, NewArray_c.listChild(this.dims, null), 1);
            v.visitCFGList(this.dims, this, 0);
        }
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        if (this.dims != null && !this.dims.isEmpty()) {
            try {
                return CollectionUtil.list(ts.typeForName(QName.make("java.lang.NegativeArraySizeException")));
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Cannot find class java.lang.NegativeArraySizeException", e);
            }
        }
        return Collections.EMPTY_LIST;
    }
}

