/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.ast.PackageNode;
import polyglot.ast.SourceFile;
import polyglot.ast.TopLevelDecl;
import polyglot.frontend.Source;
import polyglot.types.Context;
import polyglot.types.ImportTable;
import polyglot.types.Name;
import polyglot.types.SemanticException;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFile_c
extends Node_c
implements SourceFile {
    protected PackageNode package_;
    protected List<Import> imports;
    protected List<TopLevelDecl> decls;
    protected ImportTable importTable;
    protected Source source;

    public SourceFile_c(Position pos, PackageNode package_, List<Import> imports, List<TopLevelDecl> decls) {
        super(pos);
        assert (imports != null && decls != null && !decls.isEmpty());
        this.package_ = package_;
        this.imports = TypedList.copyAndCheck(imports, Import.class, true);
        this.decls = TypedList.copyAndCheck(decls, TopLevelDecl.class, true);
    }

    @Override
    public Source source() {
        return this.source;
    }

    @Override
    public SourceFile source(Source source) {
        SourceFile_c n = (SourceFile_c)this.copy();
        n.source = source;
        return n;
    }

    @Override
    public PackageNode package_() {
        return this.package_;
    }

    @Override
    public SourceFile package_(PackageNode package_) {
        SourceFile_c n = (SourceFile_c)this.copy();
        n.package_ = package_;
        return n;
    }

    @Override
    public List<Import> imports() {
        return Collections.unmodifiableList(this.imports);
    }

    @Override
    public SourceFile imports(List<Import> imports) {
        SourceFile_c n = (SourceFile_c)this.copy();
        n.imports = TypedList.copyAndCheck(imports, Import.class, true);
        return n;
    }

    @Override
    public List<TopLevelDecl> decls() {
        return Collections.unmodifiableList(this.decls);
    }

    @Override
    public SourceFile decls(List<TopLevelDecl> decls) {
        SourceFile_c n = (SourceFile_c)this.copy();
        n.decls = TypedList.copyAndCheck(decls, TopLevelDecl.class, true);
        return n;
    }

    @Override
    public ImportTable importTable() {
        return this.importTable;
    }

    @Override
    public SourceFile importTable(ImportTable importTable) {
        SourceFile_c n = (SourceFile_c)this.copy();
        n.importTable = importTable;
        return n;
    }

    protected SourceFile_c reconstruct(PackageNode package_, List<Import> imports, List<TopLevelDecl> decls) {
        if (package_ != this.package_ || !CollectionUtil.allEqual(imports, this.imports) || !CollectionUtil.allEqual(decls, this.decls)) {
            SourceFile_c n = (SourceFile_c)this.copy();
            n.package_ = package_;
            n.imports = TypedList.copyAndCheck(imports, Import.class, true);
            n.decls = TypedList.copyAndCheck(decls, TopLevelDecl.class, true);
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        PackageNode package_ = (PackageNode)this.visitChild(this.package_, v);
        List imports = this.visitList(this.imports, v);
        List decls = this.visitList(this.decls, v);
        return this.reconstruct(package_, imports, decls);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        if (this.package_ != null) {
            return tb.pushPackage(Types.get(this.package_.package_()));
        }
        return tb;
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushSource(this.importTable);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        HashSet<Name> names = new HashSet<Name>();
        boolean hasPublic = false;
        for (TopLevelDecl d : this.decls) {
            Name s = d.name().id();
            if (names.contains(s)) {
                throw new SemanticException("Duplicate declaration: \"" + s + "\".", d.position());
            }
            names.add(s);
            if (!d.flags().flags().isPublic()) continue;
            if (hasPublic) {
                throw new SemanticException("The source contains more than one public declaration.", d.position());
            }
            hasPublic = true;
        }
        return this;
    }

    @Override
    public String toString() {
        return "<<<< " + this.source + " >>>>";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("<<<< " + this.source + " >>>>");
        w.newline(0);
        if (this.package_ != null) {
            w.write("package ");
            this.print(this.package_, w, tr);
            w.write(";");
            w.newline(0);
            w.newline(0);
        }
        for (Import im : this.imports) {
            this.print(im, w, tr);
        }
        if (!this.imports.isEmpty()) {
            w.newline(0);
        }
        for (TopLevelDecl d : this.decls) {
            this.print(d, w, tr);
        }
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.begin(0);
        w.allowBreak(4, " ");
        w.write("(import-table " + this.importTable + ")");
        w.end();
    }
}

