/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import polyglot.ast.Case;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Switch;
import polyglot.ast.SwitchElement;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Switch_c
extends Stmt_c
implements Switch {
    protected Expr expr;
    protected List<SwitchElement> elements;

    public Switch_c(Position pos, Expr expr, List<SwitchElement> elements) {
        super(pos);
        assert (expr != null && elements != null);
        this.expr = expr;
        this.elements = TypedList.copyAndCheck(elements, SwitchElement.class, true);
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Switch expr(Expr expr) {
        Switch_c n = (Switch_c)this.copy();
        n.expr = expr;
        return n;
    }

    @Override
    public List<SwitchElement> elements() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    public Switch elements(List<SwitchElement> elements) {
        Switch_c n = (Switch_c)this.copy();
        n.elements = TypedList.copyAndCheck(elements, SwitchElement.class, true);
        return n;
    }

    protected Switch_c reconstruct(Expr expr, List<SwitchElement> elements) {
        if (expr != this.expr || !CollectionUtil.allEqual(elements, this.elements)) {
            Switch_c n = (Switch_c)this.copy();
            n.expr = expr;
            n.elements = TypedList.copyAndCheck(elements, SwitchElement.class, true);
            return n;
        }
        return this;
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild(this.expr, v);
        List elements = this.visitList(this.elements, v);
        return this.reconstruct(expr, elements);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context context = tc.context();
        if (!ts.isImplicitCastValid(this.expr.type(), ts.Int(), context) && !ts.isImplicitCastValid(this.expr.type(), ts.Char(), context)) {
            throw new SemanticException("Switch index must be an integer.", this.position());
        }
        return this;
    }

    @Override
    public Node checkConstants(ContextVisitor tc) throws SemanticException {
        HashSet<Object> labels = new HashSet<Object>();
        for (SwitchElement s : this.elements) {
            String str;
            Object key;
            if (!(s instanceof Case)) continue;
            Case c = (Case)s;
            if (c.isDefault()) {
                key = "default";
                str = "default";
            } else {
                if (!c.expr().isConstant()) continue;
                key = c.value();
                str = c.expr().toString() + " (" + c.value() + ")";
            }
            if (labels.contains(key)) {
                throw new SemanticException("Duplicate case label: " + str + ".", c.position());
            }
            labels.add(key);
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Int();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "switch (" + this.expr + ") { ... }";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("switch (");
        this.printBlock(this.expr, w, tr);
        w.write(") {");
        w.unifiedBreak(4);
        w.begin(0);
        boolean lastWasCase = false;
        boolean first = true;
        for (SwitchElement s : this.elements) {
            if (s instanceof Case) {
                if (lastWasCase) {
                    w.unifiedBreak(0);
                } else if (!first) {
                    w.unifiedBreak(0);
                }
                this.printBlock(s, w, tr);
                lastWasCase = true;
            } else {
                w.unifiedBreak(4);
                this.print(s, w, tr);
                lastWasCase = false;
            }
            first = false;
        }
        w.end();
        w.unifiedBreak(0);
        w.write("}");
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        ArrayList<Stmt> cases = new ArrayList<Stmt>(this.elements.size() + 1);
        ArrayList<Integer> entry = new ArrayList<Integer>(this.elements.size() + 1);
        boolean hasDefault = false;
        for (SwitchElement s : this.elements) {
            if (!(s instanceof Case)) continue;
            cases.add(s);
            entry.add(1);
            if (((Case)s).expr() != null) continue;
            hasDefault = true;
        }
        if (!hasDefault) {
            cases.add(this);
            entry.add(new Integer(0));
        }
        v.visitCFG((Term)this.expr, FlowGraph.EDGE_KEY_OTHER, cases, entry);
        v.push(this).visitCFGList(this.elements, this, 0);
        return succs;
    }
}

