/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ast.Throw;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Throw_c
extends Stmt_c
implements Throw {
    protected Expr expr;

    public Throw_c(Position pos, Expr expr) {
        super(pos);
        assert (expr != null);
        this.expr = expr;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Throw expr(Expr expr) {
        Throw_c n = (Throw_c)this.copy();
        n.expr = expr;
        return n;
    }

    protected Throw_c reconstruct(Expr expr) {
        if (expr != this.expr) {
            Throw_c n = (Throw_c)this.copy();
            n.expr = expr;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild(this.expr, v);
        return this.reconstruct(expr);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        if (!this.expr.type().isThrowable()) {
            throw new SemanticException("Can only throw subclasses of \"" + tc.typeSystem().Throwable() + "\".", this.expr.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Throwable();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "throw " + this.expr + ";";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("throw ");
        this.print(this.expr, w, tr);
        w.write(";");
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG(this.expr, this, 0);
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        return CollectionUtil.list(this.expr.type(), ts.NullPointerException(), new Type[0]);
    }
}

