/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Node;
import polyglot.frontend.AbstractGoal_c;
import polyglot.frontend.Goal;
import polyglot.frontend.SchedulerException;
import polyglot.types.LazyRef;
import polyglot.util.CollectionUtil;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCheckFragmentGoal
extends AbstractGoal_c {
    protected Node parent;
    protected Node n;
    protected TypeChecker v;
    protected LazyRef r;
    protected boolean mightFail;

    public TypeCheckFragmentGoal(Node parent, Node n, TypeChecker v, LazyRef r, boolean mightFail) {
        this.parent = parent;
        this.n = n;
        this.v = v;
        this.r = r;
        this.mightFail = mightFail;
    }

    @Override
    public List<Goal> prereqs() {
        List<Goal> l = super.prereqs();
        List<Goal> l2 = Collections.singletonList(this.v.job().extensionInfo().scheduler().PreTypeCheck(this.v.job()));
        if (l.isEmpty()) {
            return l2;
        }
        return CollectionUtil.append(l, l2);
    }

    @Override
    public boolean runTask() {
        Goal g = this.v.job().extensionInfo().scheduler().PreTypeCheck(this.v.job());
        assert (g.hasBeenReached());
        if (this.state() == Goal.Status.RUNNING_RECURSIVE) {
            this.r.update(this.r.getCached());
            return this.mightFail;
        }
        try {
            Node m = this.parent.visitChild(this.n, this.v);
            this.v.job().nodeMemo().put(this.n, m);
            this.v.job().nodeMemo().put(m, m);
            return this.mightFail || this.r.known();
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return this.v.job() + ":" + this.v.job().extensionInfo() + ":" + this.name() + " (" + this.stateString() + ") " + this.parent + "->" + this.n;
    }
}

