/*
 * Decompiled with CFR 0.152.
 */
package polyglot.dispatch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import polyglot.dispatch.PassthruError;
import polyglot.util.InternalCompilerError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dispatch {
    public static <T> T proxy(Class<? super T> c, T target) {
        return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, new DispatchProxy<T>(target));
    }

    public static <T> T proxy(T target) {
        Object p = null;
        if (p == null) {
            Class<?> c = target.getClass();
            ArrayList interfaces = new ArrayList();
            for (Class<?> s = c; s != null; s = s.getSuperclass()) {
                for (Class<?> ci : s.getInterfaces()) {
                    interfaces.add(ci);
                }
            }
            p = Proxy.newProxyInstance(c.getClassLoader(), interfaces.toArray(new Class[0]), new DispatchProxy<T>(target));
        }
        return (T)p;
    }

    public static class Dispatcher {
        String name;

        public Dispatcher(String name) {
            this.name = name;
        }

        public Object invoke(Object a, Object ... b) {
            try {
                return DispatchProxy.invoke(a, this.name, b);
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
            catch (NoSuchMethodException e) {
                throw new InternalCompilerError(e);
            }
            catch (Exception e) {
                throw new PassthruError(e);
            }
            catch (Throwable e) {
                throw new InternalCompilerError(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DispatchProxy<T>
    implements InvocationHandler {
        T target;

        DispatchProxy(T target) {
            this.target = target;
        }

        private static boolean compatible(Class[] actuals, Class[] formals) {
            if (actuals.length != formals.length) {
                return false;
            }
            for (int i = 0; i < actuals.length; ++i) {
                if (!(actuals[i] == null ? formals[i].isPrimitive() : !formals[i].isAssignableFrom(actuals[i]))) continue;
                return false;
            }
            return true;
        }

        private static void findMethods(Class<?> c, String name, Class retType, Class[] argTypes, List<Method> matched) throws NoSuchMethodException {
            if (c == null) {
                return;
            }
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!name.equals(m.getName()) || !DispatchProxy.compatible(argTypes, m.getParameterTypes()) || retType != null && !retType.isAssignableFrom(m.getReturnType())) continue;
                matched.add(m);
            }
        }

        static Result compareMethods(Method m1, Method m2) {
            if (m1 == m2) {
                return Result.EQUAL;
            }
            if (0 < m1.getParameterTypes().length) {
                Class<?> t2;
                int i = 0;
                Class<?> t1 = m1.getParameterTypes()[i];
                Result r = t1.equals(t2 = m2.getParameterTypes()[i]) ? Result.EQUAL : (t2.isAssignableFrom(t1) ? Result.LESS : (t1.isAssignableFrom(t2) ? Result.GREATER : Result.INCOMPARABLE));
                for (i = 1; i < m1.getParameterTypes().length && r != Result.INCOMPARABLE; ++i) {
                    t1 = m1.getParameterTypes()[i];
                    if (t1.equals(t2 = m2.getParameterTypes()[i])) continue;
                    r = t2.isAssignableFrom(t1) ? (r == Result.GREATER ? Result.INCOMPARABLE : Result.LESS) : (t1.isAssignableFrom(t2) ? (r == Result.LESS ? Result.INCOMPARABLE : Result.GREATER) : Result.INCOMPARABLE);
                }
                if (r == Result.INCOMPARABLE) {
                    if (m1.getDeclaringClass().isAssignableFrom(m2.getDeclaringClass())) {
                        r = Result.LESS;
                    }
                    if (m2.getDeclaringClass().isAssignableFrom(m1.getDeclaringClass())) {
                        r = Result.GREATER;
                    }
                }
                return r;
            }
            return Result.EQUAL;
        }

        private static Method findMethod(Class<?> c, String name, Class<?> retType, Class[] argTypes) throws NoSuchMethodException {
            Result r;
            Method mi;
            int i;
            ArrayList<Method> matched = new ArrayList<Method>(1);
            DispatchProxy.findMethods(c, name, retType, argTypes, matched);
            if (matched.isEmpty()) {
                throw new NoSuchMethodException(c + "." + name + Arrays.asList(argTypes));
            }
            Method mostSpecific = (Method)matched.get(0);
            for (i = 1; i < matched.size(); ++i) {
                mi = (Method)matched.get(i);
                r = DispatchProxy.compareMethods(mi, mostSpecific);
                if (r != Result.LESS) continue;
                mostSpecific = mi;
            }
            for (i = 0; i < matched.size(); ++i) {
                mi = (Method)matched.get(i);
                r = DispatchProxy.compareMethods(mi, mostSpecific);
                if (r != Result.INCOMPARABLE) continue;
                mostSpecific = null;
            }
            if (mostSpecific == null) {
                throw new NoSuchMethodException("Ambiguous call " + matched);
            }
            return mostSpecific;
        }

        public static <T> Object invoke(T target, String name, Object[] args) throws Throwable {
            Class<?> c = target.getClass();
            args = DispatchProxy.flatten(args);
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i] != null ? args[i].getClass() : null;
            }
            Method m = DispatchProxy.findMethod(c, name, null, argTypes);
            try {
                return m.invoke(target, args);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private static Object[] flatten(Object[] args) {
            int n = 0;
            boolean flatten = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof Object[]) {
                    Object[] a = (Object[])args[i];
                    n += a.length;
                    flatten = true;
                    continue;
                }
                ++n;
            }
            if (!flatten) {
                return args;
            }
            Object[] newArgs = new Object[n];
            int j = 0;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof Object[]) {
                    Object[] a = (Object[])args[i];
                    for (int k = 0; k < a.length; ++k) {
                        newArgs[j++] = a[k];
                    }
                    continue;
                }
                newArgs[j++] = args[i];
            }
            return newArgs;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            return DispatchProxy.invoke(this.target, m.getName(), args);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Result {
            LESS,
            GREATER,
            EQUAL,
            UNKNOWN,
            INCOMPARABLE;

        }
    }
}

