/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.Globals;
import polyglot.frontend.Goal;
import polyglot.frontend.Scheduler;
import polyglot.main.Report;
import polyglot.types.LazyRef_c;
import polyglot.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGoal_c
extends LazyRef_c<Goal.Status>
implements Goal {
    String name;
    public List<Goal> prereqs;

    @Override
    public Goal intern(Scheduler scheduler) {
        return scheduler.intern(this);
    }

    protected AbstractGoal_c() {
        super(Goal.Status.NEW);
        this.name = StringUtil.getShortNameComponent(this.getClass().getName().replace('$', '.'));
        this.setResolver(this);
    }

    protected AbstractGoal_c(String name) {
        super(Goal.Status.NEW);
        this.name = name;
        this.setResolver(this);
    }

    @Override
    public void run() {
        boolean recursive;
        AbstractGoal_c goal = this;
        if (Report.should_report("frontend", 2)) {
            Report.report(2, "Running to goal " + goal);
        }
        LinkedList<Goal> worklist = new LinkedList<Goal>(this.prereqs());
        LinkedHashSet<Goal> prereqs = new LinkedHashSet<Goal>();
        prereqs.addAll(worklist);
        block17: while (!worklist.isEmpty()) {
            Goal g = worklist.removeFirst();
            if (g.getCached() == Goal.Status.SUCCESS) continue;
            if (Report.should_report("frontend", 4)) {
                Report.report(4, "running prereq: " + g + "->" + goal);
            }
            Goal.Status s = (Goal.Status)((Object)g.get());
            for (Goal g2 : this.prereqs()) {
                if (prereqs.contains(g2)) continue;
                prereqs.add(g2);
                worklist.add(g2);
            }
            switch (s) {
                case NEW: 
                case FAIL: 
                case RUNNING: 
                case RUNNING_RECURSIVE: 
                case RUNNING_WILL_FAIL: 
                case UNREACHABLE: {
                    this.update(Goal.Status.UNREACHABLE);
                    continue block17;
                }
            }
        }
        Goal.Status oldStatus = (Goal.Status)((Object)this.getCached());
        switch (oldStatus) {
            case RUNNING: 
            case RUNNING_RECURSIVE: {
                this.updateCache(Goal.Status.RUNNING_RECURSIVE);
                break;
            }
            case NEW: {
                this.updateCache(Goal.Status.RUNNING);
                break;
            }
            default: {
                return;
            }
        }
        boolean bl = recursive = oldStatus == Goal.Status.RUNNING_RECURSIVE;
        if (Report.should_report("frontend", 4)) {
            Report.report(4, "running goal " + goal);
        }
        if (Report.should_report("frontend", 5) && Globals.Scheduler().currentGoal() != null) {
            Report.report(5, "CURRENT = " + Globals.Scheduler().currentGoal());
            Report.report(5, "SPAWN   = " + goal);
        }
        boolean result = false;
        try {
            result = Globals.Scheduler().runPass(this);
            if (this.state() == Goal.Status.RUNNING_WILL_FAIL) {
                result = false;
            }
        }
        catch (CyclicDependencyException e) {
            // empty catch block
        }
        if (result) {
            switch (oldStatus) {
                case RUNNING: 
                case RUNNING_RECURSIVE: {
                    this.update(oldStatus);
                    break;
                }
                case NEW: {
                    this.update(Goal.Status.SUCCESS);
                    break;
                }
            }
        } else {
            switch (oldStatus) {
                case RUNNING: 
                case RUNNING_RECURSIVE: {
                    this.update(Goal.Status.RUNNING_WILL_FAIL);
                    break;
                }
                case NEW: {
                    this.update(Goal.Status.FAIL);
                    break;
                }
            }
        }
    }

    @Override
    public abstract boolean runTask();

    @Override
    public List<Goal> prereqs() {
        if (this.prereqs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.prereqs);
    }

    @Override
    public void addPrereq(Goal goal) {
        if (this.prereqs == null) {
            this.prereqs = new ArrayList<Goal>();
        }
        this.prereqs.add(goal);
    }

    @Override
    public boolean hasBeenReached() {
        return this.getCached() == Goal.Status.SUCCESS;
    }

    @Override
    public boolean isReachable() {
        Goal.Status state = (Goal.Status)((Object)this.getCached());
        switch (state) {
            case NEW: 
            case RUNNING: 
            case RUNNING_RECURSIVE: 
            case SUCCESS: {
                return true;
            }
            case FAIL: 
            case RUNNING_WILL_FAIL: 
            case UNREACHABLE: {
                return false;
            }
        }
        return false;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Goal.Status state() {
        return (Goal.Status)((Object)this.getCached());
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Goal) {
            Goal g = (Goal)o;
            return this.name().equals(g.name());
        }
        return false;
    }

    public boolean isRunning() {
        switch (this.state()) {
            case RUNNING: 
            case RUNNING_RECURSIVE: 
            case RUNNING_WILL_FAIL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void fail() {
        switch (this.state()) {
            case SUCCESS: {
                assert (false);
                break;
            }
            case RUNNING: 
            case RUNNING_RECURSIVE: {
                this.update(Goal.Status.RUNNING_WILL_FAIL);
                break;
            }
            case NEW: {
                this.update(Goal.Status.UNREACHABLE);
                break;
            }
        }
    }

    protected String stateString() {
        Goal.Status state = this.state();
        switch (state) {
            case NEW: {
                return "new";
            }
            case RUNNING: {
                return "running";
            }
            case RUNNING_RECURSIVE: {
                return "running-recursive";
            }
            case RUNNING_WILL_FAIL: {
                return "running-will-fail";
            }
            case SUCCESS: {
                return "success";
            }
            case FAIL: {
                return "failed";
            }
            case UNREACHABLE: {
                return "unreachable";
            }
        }
        return "unknown-goal-state";
    }

    @Override
    public String toString() {
        return this.name() + " (" + this.stateString() + ")";
    }
}

