/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.BarrierGoal;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Globals;
import polyglot.frontend.Goal;
import polyglot.frontend.Job;
import polyglot.frontend.OutputGoal;
import polyglot.frontend.ParserGoal;
import polyglot.frontend.Scheduler;
import polyglot.frontend.SourceGoal_c;
import polyglot.frontend.TypeObjectGoal_c;
import polyglot.frontend.VisitorGoal;
import polyglot.main.Version;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.types.LazyRef;
import polyglot.types.Named;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.ErrorQueue;
import polyglot.visit.ClassSerializer;
import polyglot.visit.ConformanceChecker;
import polyglot.visit.ConstructorCallChecker;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.ExitChecker;
import polyglot.visit.FwdReferenceChecker;
import polyglot.visit.InitChecker;
import polyglot.visit.InitImportsVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.ReachChecker;
import polyglot.visit.Translator;
import polyglot.visit.TypeCheckPreparer;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLScheduler
extends Scheduler {
    public JLScheduler(ExtensionInfo extInfo) {
        super(extInfo);
    }

    @Override
    public List<Goal> goals(Job job) {
        ArrayList<Goal> goals = new ArrayList<Goal>();
        goals.add(this.Parsed(job));
        goals.add(this.TypesInitialized(job));
        goals.add(this.ImportTableInitialized(job));
        goals.add(this.PreTypeCheck(job));
        goals.add(this.TypesInitializedForCommandLineBarrier());
        goals.add(this.TypeChecked(job));
        goals.add(this.ReassembleAST(job));
        goals.add(this.ConformanceChecked(job));
        goals.add(this.ReachabilityChecked(job));
        goals.add(this.ExceptionsChecked(job));
        goals.add(this.ExitPathsChecked(job));
        goals.add(this.InitializationsChecked(job));
        goals.add(this.ConstructorCallsChecked(job));
        goals.add(this.ForwardReferencesChecked(job));
        goals.add(this.Serialized(job));
        goals.add(this.CodeGenerated(job));
        goals.add(this.End(job));
        return goals;
    }

    @Override
    public Goal Parsed(Job job) {
        return new ParserGoal(this.extInfo.compiler(), job).intern(this);
    }

    @Override
    public Goal ImportTableInitialized(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        VisitorGoal g = new VisitorGoal("ImportTableInitialized", job, new InitImportsVisitor(job, ts, nf));
        Goal g2 = g.intern(this);
        return g2;
    }

    @Override
    public Goal TypesInitialized(Job job) {
        return job.TypesInitialized(this);
    }

    @Override
    public Goal TypesInitializedForCommandLineBarrier() {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        return new BarrierGoal("TypesInitializedForCommandLineBarrier", this.commandLineJobs()){

            public Goal prereqForJob(Job job) {
                return JLScheduler.this.PreTypeCheck(job);
            }
        }.intern(this);
    }

    @Override
    public Goal PreTypeCheck(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("PreTypeCheck", job, new TypeCheckPreparer(job, ts, nf, job.nodeMemo())).intern(this);
    }

    public Goal ReassembleAST(final Job job) {
        final Map<Node, Node> memo = job.nodeMemo();
        return new VisitorGoal("ReassembleAST", job, new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                Node m = (Node)memo.get(old);
                if (old == job.ast()) {
                    memo.clear();
                }
                if (m != null) {
                    return m;
                }
                return n;
            }
        }).intern(this);
    }

    @Override
    public Goal TypeChecked(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("TypeChecked", job, new TypeChecker(job, ts, nf, job.nodeMemo())).intern(this);
    }

    public Goal ConformanceChecked(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("ConformanceChecked", job, new ConformanceChecker(job, ts, nf)).intern(this);
    }

    @Override
    public Goal ReachabilityChecked(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("ReachChecked", job, new ReachChecker(job, ts, nf)).intern(this);
    }

    @Override
    public Goal ExceptionsChecked(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("ExceptionsChecked", job, new ExceptionChecker(job, ts, nf)).intern(this);
    }

    @Override
    public Goal ExitPathsChecked(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("ExitChecked", job, new ExitChecker(job, ts, nf)).intern(this);
    }

    @Override
    public Goal InitializationsChecked(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("InitializationsChecked", job, new InitChecker(job, ts, nf)).intern(this);
    }

    @Override
    public Goal ConstructorCallsChecked(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("ContructorCallsChecked", job, new ConstructorCallChecker(job, ts, nf)).intern(this);
    }

    @Override
    public Goal ForwardReferencesChecked(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("ForwardRefsChecked", job, new FwdReferenceChecker(job, ts, nf)).intern(this);
    }

    @Override
    public Goal Serialized(Job job) {
        Compiler compiler = job.extensionInfo().compiler();
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        if (compiler.serializeClassInfo()) {
            return new VisitorGoal("Serialized", job, new ClassSerializer(ts, nf, job.source().lastModified(), compiler.errorQueue(), this.extInfo.version())).intern(this);
        }
        return new SourceGoal_c("Serialized", job){

            public boolean runTask() {
                return true;
            }
        }.intern(this);
    }

    protected ClassSerializer createSerializer(TypeSystem ts, NodeFactory nf, Date lastModified, ErrorQueue eq, Version version) {
        return new ClassSerializer(ts, nf, lastModified, eq, version);
    }

    @Override
    public Goal CodeGenerated(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        return new OutputGoal(job, new Translator(job, ts, nf, this.extInfo.targetFactory())).intern(this);
    }

    @Override
    public Goal LookupGlobalType(LazyRef<Type> sym2) {
        return new LookupGlobalType("LookupGlobalType", (Ref<Type>)sym2).intern(this);
    }

    @Override
    public Goal LookupGlobalTypeDef(LazyRef<ClassDef> sym2, QName className) {
        return this.LookupGlobalTypeDefAndSetFlags(sym2, className, null);
    }

    @Override
    public Goal LookupGlobalTypeDefAndSetFlags(LazyRef<ClassDef> sym2, QName className, Flags flags) {
        return new LookupGlobalTypeDefAndSetFlags(sym2, className, flags).intern(this);
    }

    public Goal EnsureNoErrors(Job job) {
        return new SourceGoal_c("EnsureNoErrors", job){

            public boolean runTask() {
                return !this.job.reportedErrors();
            }
        }.intern(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LookupGlobalTypeDefAndSetFlags
    extends TypeObjectGoal_c<ClassDef> {
        protected QName className;
        protected Flags flags;

        protected LookupGlobalTypeDefAndSetFlags(Ref<ClassDef> v, QName className, Flags flags) {
            super(v);
            this.className = className;
            this.flags = flags;
        }

        @Override
        public String toString() {
            if (this.flags == null) {
                return this.name + "(" + this.className + ")";
            }
            return this.name + "(" + this.className + ", " + this.flags + ")";
        }

        @Override
        public boolean runTask() {
            LazyRef ref = (LazyRef)this.typeRef();
            try {
                TypeSystem ts = Globals.TS();
                Named n = ts.systemResolver().find(QName.make(this.className));
                if (n instanceof ClassType) {
                    ClassType ct = (ClassType)n;
                    ClassDef def = this.defResolved((ClassDef)ct.def());
                    ref.update(def);
                    return true;
                }
            }
            catch (SemanticException e) {
                Globals.Compiler().errorQueue().enqueue(5, e.getMessage(), e.position());
            }
            return false;
        }

        protected ClassDef defResolved(ClassDef def) {
            if (this.flags != null) {
                assert (def.isMember());
                def.setFlags(this.flags);
            }
            return def;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LookupGlobalType
    extends TypeObjectGoal_c<Type> {
        LazyRef<ClassDef> ref = Types.lazyRef(null);

        public LookupGlobalType(String name, Ref<Type> v) {
            super(name, v);
            Goal g = Globals.Scheduler().LookupGlobalTypeDef(this.ref, null);
            this.ref.setResolver(g);
        }

        @Override
        public boolean runTask() {
            ClassDef def = (ClassDef)this.ref.get();
            this.v.update(def.asType());
            return true;
        }
    }
}

