/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceFile;
import polyglot.ast.TypeNode;
import polyglot.frontend.Compiler;
import polyglot.frontend.FileSource;
import polyglot.frontend.Job;
import polyglot.frontend.Parser;
import polyglot.frontend.SourceGoal_c;
import polyglot.main.Report;
import polyglot.types.Flags;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;

public class ParserGoal
extends SourceGoal_c {
    protected Compiler compiler;

    public ParserGoal(Compiler compiler, Job job) {
        super("Parser", job);
        this.compiler = compiler;
    }

    protected SourceFile createDummyAST() {
        NodeFactory nf = this.job().extensionInfo().nodeFactory();
        String fName = this.job.source().name();
        Position pos = new Position(this.job.source().name(), fName);
        String name = fName.substring(fName.lastIndexOf(File.separatorChar) + 1, fName.lastIndexOf(46));
        ClassDecl decl = nf.ClassDecl(pos, nf.FlagsNode(pos, Flags.PUBLIC), nf.Id(pos, name), null, Collections.<TypeNode>emptyList(), nf.ClassBody(pos, Collections.<ClassMember>emptyList()));
        SourceFile ast = nf.SourceFile(pos, Collections.singletonList(decl)).source(this.job.source());
        return ast;
    }

    public boolean runTask() {
        ErrorQueue eq = this.compiler.errorQueue();
        FileSource source = (FileSource)this.job().source();
        Node ast = null;
        try {
            if (Report.should_report("parser", 1)) {
                Report.report(1, "" + source);
            }
            Reader reader = source.open();
            Parser p = this.job().extensionInfo().parser(reader, source, eq);
            if (Report.should_report("frontend", 2)) {
                Report.report(2, "Using parser " + p);
            }
            ast = p.parse();
            source.close();
        }
        catch (IOException e) {
            eq.enqueue(2, e.getMessage(), new Position(this.job().source().path(), this.job().source().name(), 1, 1, 1, 1));
        }
        if (ast == null) {
            ast = this.createDummyAST();
        }
        this.job().ast(ast);
        return true;
    }

    public String toString() {
        return super.toString() + "(" + this.job().source() + ")";
    }
}

