/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import polyglot.frontend.FileResource;
import polyglot.frontend.Resource;
import polyglot.frontend.ZipResource;
import polyglot.main.Report;
import polyglot.util.FileUtil;
import polyglot.util.InternalCompilerError;

public class ResourceLoader {
    protected Map zipCache = new HashMap();
    protected Set dirCache;
    protected Map dirContentsCache = new HashMap();
    protected static final Object not_found = new Object();
    protected static Collection verbose = new HashSet();

    public ResourceLoader() {
        this.dirCache = new HashSet();
    }

    public boolean dirExists(File dir, String name) {
        if (Report.should_report(verbose, 3)) {
            Report.report(3, "looking in " + dir + " for " + name.replace('.', File.separatorChar));
        }
        if (!dir.canRead()) {
            return false;
        }
        try {
            if (dir.getName().endsWith(".jar") || dir.getName().endsWith(".zip")) {
                if (this.dirCache.contains(name)) {
                    return true;
                }
                this.loadZip(dir);
                return this.dirCache.contains(name);
            }
            File f = new File(dir, name);
            return f.isDirectory() && FileUtil.checkNameFromRoot(dir, f);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new InternalCompilerError(e);
        }
        return false;
    }

    public Resource loadResource(File dir, String name) {
        if (Report.should_report(verbose, 3)) {
            Report.report(3, "looking in " + dir + " for " + name);
        }
        if (!dir.canRead()) {
            return null;
        }
        try {
            if (dir.getName().endsWith(".jar") || dir.getName().endsWith(".zip")) {
                ZipFile zip = this.loadZip(dir);
                return this.loadFromZip(dir, zip, name);
            }
            return this.loadFromFile(name, dir);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new InternalCompilerError(e);
        }
        return null;
    }

    ZipFile loadZip(File dir) throws IOException {
        Object o = this.zipCache.get(dir);
        if (o != not_found) {
            ZipFile zip = (ZipFile)o;
            if (zip != null) {
                return zip;
            }
            if (!dir.exists()) {
                this.zipCache.put(dir, not_found);
            } else {
                if (Report.should_report(verbose, 2)) {
                    Report.report(2, "Opening zip " + dir);
                }
                zip = dir.getName().endsWith(".jar") ? new JarFile(dir) : new ZipFile(dir);
                this.zipCache.put(dir, zip);
                Enumeration<? extends ZipEntry> i = zip.entries();
                while (i.hasMoreElements()) {
                    ZipEntry ei = i.nextElement();
                    String n = ei.getName();
                    int index = n.indexOf(47);
                    while (index >= 0) {
                        String res = n.substring(0, index);
                        this.dirCache.add(res);
                        index = n.indexOf(47, index + 1);
                    }
                }
                return zip;
            }
        }
        throw new FileNotFoundException(dir.getAbsolutePath());
    }

    Resource loadFromZip(File source, ZipFile zip, String fileName) throws IOException {
        ZipEntry entry;
        String entryName = fileName.replace(File.separatorChar, '/');
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "Looking for " + entryName + " in " + zip.getName());
        }
        if (zip != null && (entry = zip.getEntry(entryName)) != null) {
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "found zip entry " + entry);
            }
            ZipResource c = new ZipResource(source, zip, entryName);
            return c;
        }
        return null;
    }

    Resource loadFromFile(String name, File dir) throws IOException {
        File file;
        int sepIndex = name.indexOf(File.separatorChar);
        if (sepIndex > 0) {
            File newDir = new File(dir, name.substring(0, sepIndex));
            String newName = name.substring(sepIndex + 1);
            return this.loadFromFile(newName, newDir);
        }
        HashSet<String> dirContents = (HashSet<String>)this.dirContentsCache.get(dir);
        if (dirContents == null) {
            String[] contents;
            dirContents = new HashSet<String>();
            this.dirContentsCache.put(dir, dirContents);
            if (dir.exists() && dir.isDirectory() && (contents = dir.list()) != null) {
                for (int j = 0; j < contents.length; ++j) {
                    dirContents.add(contents[j]);
                }
            }
        }
        if (!(file = new File(dir, name)).exists()) {
            return null;
        }
        String firstPart = name;
        if (!dirContents.contains(firstPart)) {
            return null;
        }
        if (Report.should_report(verbose, 3)) {
            Report.report(3, "found " + file);
        }
        if (Report.should_report(verbose, 3)) {
            Report.report(3, "defining class " + name);
        }
        FileResource c = new FileResource(file);
        return c;
    }

    static {
        verbose.add("loader");
    }
}

