/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;

public class Stats {
    protected ExtensionInfo ext;
    protected Map<Object, Counts> counts = new HashMap<Object, Counts>();
    protected List<Object> keys = new ArrayList<Object>(20);

    public Stats(ExtensionInfo ext) {
        this.ext = ext;
    }

    public void resetCounts(Object key) {
        this.counts.remove(key);
    }

    public long getCount(Object key) {
        Counts t = this.counts.get(key);
        if (t == null) {
            return 0L;
        }
        return t.count;
    }

    public void accumulate(Object key, long count) {
        Counts t = this.counts.get(key);
        if (t == null) {
            this.keys.add(key);
            t = new Counts();
            this.counts.put(key, t);
        }
        t.count += count;
    }

    public void report() {
        if (Report.should_report("time", 1)) {
            Report.report(1, "\nStatistics for " + this.ext.compilerName() + " (" + this.ext.getClass().getName() + ")");
            Report.report(1, this.format("Count", "Key"));
            Report.report(1, this.format("-----", "---"));
            for (Object key : this.keys) {
                Counts t = this.counts.get(key);
                Report.report(1, this.format(key.toString(), Long.toString(t.count)));
            }
        }
    }

    public String format(String key, String value) {
        StringBuilder sb = new StringBuilder();
        for (int i = value.length(); i < 16; ++i) {
            sb.append(' ');
        }
        sb.append(value);
        sb.append(' ');
        sb.append(key);
        return sb.toString();
    }

    protected static class Counts {
        public long count;

        protected Counts() {
        }
    }
}

