/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import polyglot.frontend.Compiler;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.types.Name;
import polyglot.types.QName;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.UnicodeWriter;

public class TargetFactory {
    protected File outputDirectory;
    protected String outputExtension;
    protected boolean outputStdout;

    public TargetFactory(File outDir, String outExt, boolean so) {
        this.outputDirectory = outDir;
        this.outputExtension = outExt;
        this.outputStdout = so;
    }

    public Writer outputWriter(QName packageName, Name className, Source source) throws IOException {
        return this.outputWriter(this.outputFile(packageName, className, source));
    }

    public CodeWriter outputCodeWriter(File f, int width) throws IOException {
        Writer w = this.outputWriter(f);
        return Compiler.createCodeWriter(w, width);
    }

    public Writer outputWriter(File outputFile) throws IOException {
        if (Report.should_report("frontend", 2)) {
            Report.report(2, "Opening " + outputFile + " for output.");
        }
        if (this.outputStdout) {
            return new UnicodeWriter(new PrintWriter(System.out));
        }
        if (!outputFile.getParentFile().exists()) {
            File parent = outputFile.getParentFile();
            parent.mkdirs();
        }
        return new UnicodeWriter(new FileWriter(outputFile));
    }

    public File outputFile(QName packageName, Source source) {
        String name = new File(source.name()).getName();
        name = name.substring(0, name.lastIndexOf(46));
        return this.outputFile(packageName, Name.make(name), source);
    }

    public File outputFile(QName packageName, Name className, Source source) {
        if (this.outputDirectory == null) {
            throw new InternalCompilerError("Output directory not set.");
        }
        String pkgString = packageName == null ? "" : packageName.toString();
        File outputFile = new File(this.outputDirectory, pkgString.replace('.', File.separatorChar) + File.separatorChar + className + "." + this.outputExtension);
        if (source != null && outputFile.getPath().equals(source.path())) {
            throw new InternalCompilerError("The output file is the same as the source file");
        }
        return outputFile;
    }
}

