/*
 * Decompiled with CFR 0.152.
 */
package polyglot.main;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Globals;
import polyglot.main.Options;
import polyglot.main.Report;
import polyglot.main.UsageError;
import polyglot.util.ErrorQueue;
import polyglot.util.StdErrorQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private Set<String> source;
    public static final String verbose = "verbose";
    private static Collection<String> timeTopics = new ArrayList<String>(1);

    protected ExtensionInfo getExtensionInfo(List<String> args) throws TerminationException {
        ExtensionInfo ext = null;
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String s = i.next();
            if (s.equals("-ext") || s.equals("-extension")) {
                if (ext != null) {
                    throw new TerminationException("only one extension can be specified");
                }
                i.remove();
                if (!i.hasNext()) {
                    throw new TerminationException("missing argument");
                }
                String extName = i.next();
                i.remove();
                ext = Main.loadExtension("polyglot.ext." + extName + ".ExtensionInfo");
                continue;
            }
            if (!s.equals("-extclass")) continue;
            if (ext != null) {
                throw new TerminationException("only one extension can be specified");
            }
            i.remove();
            if (!i.hasNext()) {
                throw new TerminationException("missing argument");
            }
            String extClass = i.next();
            i.remove();
            ext = Main.loadExtension(extClass);
        }
        if (ext != null) {
            return ext;
        }
        return Main.loadExtension("polyglot.frontend.JLExtensionInfo");
    }

    public void start(String[] argv) throws TerminationException {
        this.start(argv, null, null);
    }

    public void start(String[] argv, ExtensionInfo ext) throws TerminationException {
        this.start(argv, ext, null);
    }

    public void start(String[] argv, ErrorQueue eq) throws TerminationException {
        this.start(argv, null, eq);
    }

    public void start(String[] argv, ExtensionInfo ext, ErrorQueue eq) throws TerminationException {
        this.source = new LinkedHashSet<String>();
        List<String> args = this.explodeOptions(argv);
        if (ext == null) {
            ext = this.getExtensionInfo(args);
        }
        Options options = ext.getOptions();
        try {
            argv = args.toArray(new String[0]);
            options.parseCommandLine(argv, this.source);
        }
        catch (UsageError ue) {
            PrintStream out;
            PrintStream printStream = out = ue.exitCode == 0 ? System.out : System.err;
            if (ue.getMessage() != null && ue.getMessage().length() > 0) {
                out.println(ext.compilerName() + ": " + ue.getMessage());
            }
            options.usage(out);
            throw new TerminationException(ue.exitCode);
        }
        if (eq == null) {
            eq = new StdErrorQueue(System.err, options.error_count, ext.compilerName());
        }
        Compiler compiler = new Compiler(ext, eq);
        Globals.initialize(compiler);
        long time0 = System.currentTimeMillis();
        if (!compiler.compileFiles(this.source)) {
            throw new TerminationException(1);
        }
        if (Report.should_report(verbose, 1)) {
            Main.reportTime("Total time=" + (System.currentTimeMillis() - time0), 1);
        }
    }

    private List<String> explodeOptions(String[] args) throws TerminationException {
        LinkedList<String> ll = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("@")) {
                String fn = args[i].substring(1);
                try {
                    String l;
                    BufferedReader lr = new BufferedReader(new FileReader(fn));
                    LinkedList<String> newArgs = new LinkedList<String>();
                    while ((l = lr.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(l, " ");
                        while (st.hasMoreTokens()) {
                            newArgs.add(st.nextToken());
                        }
                    }
                    lr.close();
                    ll.addAll(newArgs);
                    continue;
                }
                catch (IOException e) {
                    throw new TerminationException("cmdline parser: couldn't read args file " + fn);
                }
            }
            ll.add(args[i]);
        }
        return ll;
    }

    public static void main(String[] args) {
        try {
            new Main().start(args);
        }
        catch (TerminationException te) {
            if (te.getMessage() != null) {
                (te.exitCode == 0 ? System.out : System.err).println(te.getMessage());
            }
            System.exit(te.exitCode);
        }
    }

    static ExtensionInfo loadExtension(String ext) throws TerminationException {
        if (ext != null && !ext.equals("")) {
            Class<?> extClass = null;
            try {
                extClass = Class.forName(ext);
            }
            catch (ClassNotFoundException e) {
                throw new TerminationException("Extension " + ext + " not found: could not find class " + ext + ".");
            }
            try {
                return (ExtensionInfo)extClass.newInstance();
            }
            catch (ClassCastException e) {
                throw new TerminationException(ext + " is not a valid polyglot extension:" + " extension class " + ext + " exists but is not a subclass of ExtensionInfo");
            }
            catch (Exception e) {
                throw new TerminationException("Extension " + ext + " could not be loaded: could not instantiate " + ext + ".");
            }
        }
        return null;
    }

    private static void reportTime(String msg, int level) {
        Report.report(level, msg);
    }

    static {
        timeTopics.add("time");
    }

    public static class TerminationException
    extends RuntimeException {
        public final int exitCode;

        public TerminationException(String msg) {
            this(msg, 1);
        }

        public TerminationException(int exit) {
            this.exitCode = exit;
        }

        public TerminationException(String msg, int exit) {
            super(msg);
            this.exitCode = exit;
        }
    }
}

