/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import polyglot.main.Report;
import polyglot.types.Matcher;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnotherCachingResolver
implements Resolver,
Copy {
    protected Resolver inner;
    private Map<Object, Object> cache;
    private boolean cacheNotFound;
    private static final Collection TOPICS = CollectionUtil.list("types", "resolver", new String[0]);

    public AnotherCachingResolver(Resolver inner, boolean cacheNotFound) {
        this.inner = inner;
        this.cacheNotFound = cacheNotFound;
        this.cache = new LinkedHashMap<Object, Object>();
    }

    public AnotherCachingResolver(Resolver inner) {
        this(inner, true);
    }

    protected boolean shouldReport(int level) {
        return Report.should_report(TOPICS, level);
    }

    @Override
    public Object copy() {
        try {
            AnotherCachingResolver r = (AnotherCachingResolver)super.clone();
            r.cache = new HashMap<Object, Object>(this.cache);
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("clone failed");
        }
    }

    public Resolver inner() {
        return this.inner;
    }

    public String toString() {
        return "(cache " + this.inner.toString() + ")";
    }

    protected Collection<Named> cachedObjects() {
        ArrayList<Named> l = new ArrayList<Named>();
        for (Object o : this.cache.values()) {
            if (!(o instanceof Named)) continue;
            l.add((Named)o);
        }
        return l;
    }

    @Override
    public Named find(Matcher<Named> matcher) throws SemanticException {
        if (this.shouldReport(2)) {
            Report.report(2, "CachingResolver: find: " + matcher.signature());
        }
        Object o = null;
        if (matcher.key() != null) {
            o = this.cache.get(matcher.key());
        }
        if (o instanceof SemanticException) {
            throw (SemanticException)o;
        }
        Named q = (Named)o;
        if (q == null) {
            if (this.shouldReport(3)) {
                Report.report(3, "CachingResolver: not cached: " + matcher.signature());
            }
            try {
                q = this.inner.find(matcher);
            }
            catch (NoClassException e) {
                if (this.shouldReport(3)) {
                    Report.report(3, "CachingResolver: " + e.getMessage());
                    Report.report(3, "CachingResolver: installing " + matcher.signature() + "-> (not found) in resolver cache");
                }
                if (this.cacheNotFound && matcher.key() != null) {
                    this.cache.put(matcher.key(), e);
                }
                throw e;
            }
            if (matcher.key() != null) {
                this.cache.put(matcher.key(), q);
            }
            if (this.shouldReport(3)) {
                Report.report(3, "CachingResolver: loaded: " + matcher.signature());
            }
        } else if (this.shouldReport(3)) {
            Report.report(3, "CachingResolver: cached: " + matcher.signature());
        }
        return q;
    }

    public Named check(Matcher<Named> matcher) {
        if (matcher.key() == null) {
            return null;
        }
        Object o = this.cache.get(matcher.key());
        if (o instanceof Throwable) {
            return null;
        }
        return (Named)o;
    }

    public void dump() {
        Report.report(1, "Dumping " + this);
        for (Map.Entry<Object, Object> e : this.cache.entrySet()) {
            Report.report(2, e.toString());
        }
    }
}

