/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import polyglot.main.Report;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.SystemResolver;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingResolver
implements TopLevelResolver,
Copy {
    protected TopLevelResolver inner;
    private Map<QName, Object> cache;
    private boolean cacheNotFound;
    private static final Collection TOPICS = CollectionUtil.list("types", "resolver", new String[0]);

    public CachingResolver(TopLevelResolver inner, boolean cacheNotFound) {
        this.inner = inner;
        this.cacheNotFound = cacheNotFound;
        this.cache = new LinkedHashMap<QName, Object>();
    }

    public CachingResolver(TopLevelResolver inner) {
        this(inner, true);
    }

    protected boolean shouldReport(int level) {
        return Report.should_report("sysresolver", level) && this instanceof SystemResolver || Report.should_report(TOPICS, level);
    }

    @Override
    public boolean packageExists(QName name) {
        return this.inner.packageExists(name);
    }

    @Override
    public Object copy() {
        try {
            CachingResolver r = (CachingResolver)super.clone();
            r.cache = new HashMap<QName, Object>(this.cache);
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("clone failed");
        }
    }

    public TopLevelResolver inner() {
        return this.inner;
    }

    public String toString() {
        return "(cache " + this.inner.toString() + ")";
    }

    protected Collection<Named> cachedObjects() {
        ArrayList<Named> l = new ArrayList<Named>();
        for (Object o : this.cache.values()) {
            if (!(o instanceof Named)) continue;
            l.add((Named)o);
        }
        return l;
    }

    @Override
    public Named find(QName name) throws SemanticException {
        Object o;
        if (this.shouldReport(2)) {
            Report.report(2, "CachingResolver: find: " + name);
        }
        if ((o = this.cache.get(name)) instanceof SemanticException) {
            throw (SemanticException)o;
        }
        Named q = (Named)o;
        if (q == null) {
            if (this.shouldReport(3)) {
                Report.report(3, "CachingResolver: not cached: " + name);
            }
            try {
                q = this.inner.find(name);
            }
            catch (NoClassException e) {
                if (this.shouldReport(3)) {
                    Report.report(3, "CachingResolver: " + e.getMessage());
                    Report.report(3, "CachingResolver: installing " + name + "-> (not found) in resolver cache");
                }
                if (this.cacheNotFound) {
                    this.cache.put(name, e);
                }
                throw e;
            }
            this.addNamed(name, q);
            this.addNamed(QName.make(q.fullName()), q);
            if (this.shouldReport(3)) {
                Report.report(3, "CachingResolver: loaded: " + name);
            }
        } else if (this.shouldReport(3)) {
            Report.report(3, "CachingResolver: cached: " + name);
        }
        return q;
    }

    public Named check(QName name) {
        Object o = this.cache.get(name);
        if (o instanceof Throwable) {
            return null;
        }
        return (Named)o;
    }

    public void install(QName name, Named q) {
        Object old;
        if (this.shouldReport(3)) {
            Report.report(3, "CachingResolver: installing " + name + "->" + q + " in resolver cache");
        }
        if (this.shouldReport(5)) {
            new Exception().printStackTrace();
        }
        if ((old = this.cache.get(name)) != null && old != q && old instanceof Type) assert (false) : name + "->" + old + " " + old.getClass().getName() + " is already in the cache; cannot replace with " + q + " " + q.getClass().getName();
        this.cache.put(name, q);
    }

    public void addNamed(QName name, Named q) throws SemanticException {
        this.install(name, q);
    }

    public void dump() {
        Report.report(1, "Dumping " + this);
        for (Map.Entry<QName, Object> e : this.cache.entrySet()) {
            Report.report(2, e.toString());
        }
    }
}

