/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.List;
import polyglot.frontend.Globals;
import polyglot.frontend.Job;
import polyglot.types.AnotherCachingResolver;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.Matcher;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.ReferenceType_c;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassType_c
extends ReferenceType_c
implements ClassType {
    protected Ref<? extends ClassDef> def;
    protected transient Resolver memberCache;

    protected ClassType_c() {
    }

    public ClassType_c(TypeSystem ts, Position pos, Ref<? extends ClassDef> def) {
        super(ts, pos);
        this.def = def;
    }

    @Override
    public ClassDef def() {
        return this.def.get();
    }

    @Override
    public boolean equalsImpl(TypeObject t) {
        if (t instanceof ClassType_c) {
            Ref<? extends ClassDef> thisDef = this.def;
            Ref<? extends ClassDef> thatDef = ((ClassType_c)t).def;
            return thisDef.get() == thatDef.get();
        }
        return false;
    }

    @Override
    public Resolver resolver() {
        if (this.memberCache == null) {
            this.memberCache = new AnotherCachingResolver(this.ts.createClassContextResolver(this));
        }
        return this.memberCache;
    }

    @Override
    public Object copy() {
        ClassType_c n = (ClassType_c)super.copy();
        n.memberCache = null;
        return n;
    }

    public abstract Job job();

    @Override
    public abstract ClassDef.Kind kind();

    @Override
    public abstract ClassType outer();

    @Override
    public abstract Name name();

    @Override
    public StructType container() {
        if (!this.isMember()) {
            throw new InternalCompilerError("Non-member class " + this + " cannot have container classes.");
        }
        if (this.outer() == null) {
            throw new InternalCompilerError("Member class " + this + " must have an outer class.");
        }
        return this.outer();
    }

    @Override
    public QName fullName() {
        if (this.isTopLevel()) {
            Name name = this.name();
            return QName.make(this.package_() != null ? this.package_().fullName() : null, name);
        }
        if (this.isMember()) {
            Name name = this.name();
            return QName.make(this.container() instanceof Named ? ((Named)((Object)this.container())).fullName() : null, name);
        }
        if (this.isLocal()) {
            return QName.make(null, this.name());
        }
        if (this.isAnonymous()) {
            return QName.make(null, Name.make("<anonymous class>"));
        }
        return QName.make(null, Name.make("<unknown class>"));
    }

    @Override
    public boolean isTopLevel() {
        return this.kind() == ClassDef.TOP_LEVEL;
    }

    @Override
    public boolean isMember() {
        return this.kind() == ClassDef.MEMBER;
    }

    @Override
    public boolean isLocal() {
        return this.kind() == ClassDef.LOCAL;
    }

    @Override
    public boolean isAnonymous() {
        return this.kind() == ClassDef.ANONYMOUS;
    }

    @Override
    public boolean isGloballyAccessible() {
        return this.kind() == ClassDef.TOP_LEVEL || this.kind() == ClassDef.MEMBER && this.outer().isGloballyAccessible();
    }

    @Override
    public boolean isNested() {
        return this.kind() == ClassDef.MEMBER || this.kind() == ClassDef.LOCAL || this.kind() == ClassDef.ANONYMOUS;
    }

    @Override
    public boolean isInnerClass() {
        return !this.flags().isInterface() && this.isNested() && !this.flags().isStatic() && !this.inStaticContext();
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public ClassType toClass() {
        return this;
    }

    @Override
    public abstract Package package_();

    @Override
    public abstract Flags flags();

    @Override
    public abstract List<ConstructorInstance> constructors();

    @Override
    public abstract List<ClassType> memberClasses();

    @Override
    public abstract List<MethodInstance> methods();

    @Override
    public abstract List<FieldInstance> fields();

    @Override
    public abstract List<Type> interfaces();

    @Override
    public abstract Type superClass();

    @Override
    public List<MemberInstance<?>> members() {
        ArrayList l = new ArrayList();
        l.addAll(this.methods());
        l.addAll(this.fields());
        l.addAll(this.constructors());
        l.addAll(this.memberClasses());
        return l;
    }

    @Override
    public ClassType memberClassMatching(Matcher<Named> matcher) {
        for (ClassType t : this.memberClasses()) {
            try {
                Named n = matcher.instantiate(t);
                if (!(n instanceof ClassType)) continue;
                return (ClassType)n;
            }
            catch (SemanticException e) {
            }
        }
        return null;
    }

    @Override
    public Named memberTypeMatching(Matcher<Named> matcher) {
        return this.memberClassMatching(matcher);
    }

    @Override
    public String translate(Resolver c) {
        if (this.isTopLevel()) {
            if (this.package_() == null) {
                return this.name().toString();
            }
            if (c != null && !Globals.Options().fully_qualified_names) {
                try {
                    Named x = c.find(this.ts.TypeMatcher(this.name()));
                    if (x instanceof ClassType && this.def().equals(((ClassType)x).def())) {
                        return this.name().toString();
                    }
                }
                catch (SemanticException e) {
                    // empty catch block
                }
            }
            return this.package_().translate(c) + "." + this.name();
        }
        if (this.isMember()) {
            if (this.container().toClass().isAnonymous()) {
                return this.name().toString();
            }
            if (c != null && !Globals.Options().fully_qualified_names) {
                try {
                    Named x = c.find(this.ts.TypeMatcher(this.name()));
                    if (x instanceof ClassType && this.def().equals(((ClassType)x).def())) {
                        return this.name().toString();
                    }
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }
            return this.container().translate(c) + "." + this.name();
        }
        if (this.isLocal()) {
            return this.name().toString();
        }
        throw new InternalCompilerError("Cannot translate an anonymous class.");
    }

    @Override
    public String toString() {
        if (this.isTopLevel()) {
            if (this.package_() != null) {
                return this.package_() + "." + this.name();
            }
            return this.name().toString();
        }
        if (this.isMember()) {
            return this.container().toString() + "." + this.name();
        }
        if (this.isLocal()) {
            return this.name().toString();
        }
        if (this.isAnonymous()) {
            return "<anonymous class>";
        }
        return "<unknown class>";
    }

    @Override
    public void print(CodeWriter w) {
        if (this.isTopLevel()) {
            if (this.package_() != null) {
                this.package_().print(w);
                w.write(".");
                w.allowBreak(2, 3, "", 0);
            }
            w.write(this.name().toString());
        } else if (this.isMember()) {
            this.container().print(w);
            w.write(".");
            w.allowBreak(2, 3, "", 0);
            w.write(this.name().toString());
        } else if (this.isLocal()) {
            w.write(this.name().toString());
        } else if (this.isAnonymous()) {
            w.write("<anonymous class>");
        } else {
            w.write("<unknown class>");
        }
    }

    @Override
    public boolean isEnclosed(ClassType maybe_outer) {
        if (this.isTopLevel()) {
            return false;
        }
        if (this.outer() != null) {
            return this.outer().equals((Object)maybe_outer) || this.outer().isEnclosed(maybe_outer);
        }
        throw new InternalCompilerError("Non top-level classes must have outer classes.");
    }

    @Override
    public boolean hasEnclosingInstance(ClassType encl) {
        if (this.equals((Object)encl)) {
            return true;
        }
        if (!this.isInnerClass() || this.inStaticContext()) {
            return false;
        }
        return this.outer().hasEnclosingInstance(encl);
    }
}

