/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import polyglot.main.Report;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.CodeDef;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.ImportTable;
import polyglot.types.LocalInstance;
import polyglot.types.Matcher;
import polyglot.types.MemberDef;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.NoMemberException;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.types.Types;
import polyglot.types.VarInstance;
import polyglot.util.CollectionUtil;
import polyglot.util.Enum;
import polyglot.util.InternalCompilerError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context_c
implements Context {
    protected Context outer;
    protected TypeSystem ts;
    public static final Kind BLOCK = new Kind("block");
    public static final Kind CLASS = new Kind("class");
    public static final Kind CODE = new Kind("code");
    public static final Kind OUTER = new Kind("outer");
    public static final Kind SOURCE = new Kind("source");
    protected ImportTable it;
    protected Kind kind;
    protected ClassType type;
    protected ClassDef scope;
    protected CodeDef code;
    protected Map<Name, Named> types;
    protected Map<Name, VarInstance<?>> vars;
    protected boolean inCode;
    protected boolean staticContext;
    private static final Collection TOPICS = CollectionUtil.list("types", "context", new String[0]);

    public Context_c(TypeSystem ts) {
        this.ts = ts;
        this.outer = null;
        this.kind = OUTER;
    }

    public boolean isBlock() {
        return this.kind == BLOCK;
    }

    public boolean isClass() {
        return this.kind == CLASS;
    }

    public boolean isCode() {
        return this.kind == CODE;
    }

    public boolean isOuter() {
        return this.kind == OUTER;
    }

    public boolean isSource() {
        return this.kind == SOURCE;
    }

    @Override
    public TypeSystem typeSystem() {
        return this.ts;
    }

    @Override
    public Object copy() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    @Override
    public Context freeze() {
        Context_c c = (Context_c)this.copy();
        c.types = this.types != null ? new HashMap<Name, Named>(this.types) : null;
        c.vars = this.vars != null ? new HashMap(this.vars) : null;
        return c;
    }

    protected Context_c push() {
        Context_c v = (Context_c)this.copy();
        v.outer = this;
        v.types = null;
        v.vars = null;
        return v;
    }

    @Override
    public ImportTable importTable() {
        return this.it;
    }

    @Override
    public Package package_() {
        return Types.get(this.importTable().package_());
    }

    @Override
    public boolean isLocal(Name name) {
        if (this.isClass()) {
            return false;
        }
        if ((this.isBlock() || this.isCode()) && (this.findVariableInThisScope(name) != null || this.findInThisScope(this.ts.TypeMatcher(name)) != null)) {
            return true;
        }
        if (this.isCode()) {
            return false;
        }
        if (this.outer == null) {
            return false;
        }
        return this.outer.isLocal(name);
    }

    @Override
    public MethodInstance findMethod(TypeSystem_c.MethodMatcher matcher) throws SemanticException {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-method " + matcher.signature() + " in " + this);
        }
        if (this.currentClass() != null && this.ts.hasMethodNamed(this.currentClass(), matcher.name())) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-method " + matcher.signature() + " -> " + this.currentClass());
            }
            return this.ts.findMethod(this.currentClass(), matcher.container(this.currentClass()));
        }
        if (this.outer != null) {
            return this.outer.findMethod(matcher);
        }
        throw new SemanticException("Method " + matcher.signature() + " not found.");
    }

    @Override
    public LocalInstance findLocal(Name name) throws SemanticException {
        VarInstance<?> vi = this.findVariableSilent(name);
        if (vi instanceof LocalInstance) {
            return (LocalInstance)vi;
        }
        throw new SemanticException("Local " + name + " not found.");
    }

    @Override
    public ClassType findFieldScope(Name name) throws SemanticException {
        VarInstance<?> vi;
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-field-scope " + name + " in " + this);
        }
        if ((vi = this.findVariableInThisScope(name)) instanceof FieldInstance) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-field-scope " + name + " in " + vi);
            }
            return this.type;
        }
        if (vi == null && this.outer != null) {
            return this.outer.findFieldScope(name);
        }
        throw new SemanticException("Field " + name + " not found.");
    }

    @Override
    public ClassType findMethodScope(Name name) throws SemanticException {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-method-scope " + name + " in " + this);
        }
        if (this.currentClass() != null && this.ts.hasMethodNamed(this.currentClass(), name)) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-method-scope " + name + " -> " + this.currentClass());
            }
            return this.currentClass();
        }
        if (this.outer != null) {
            return this.outer.findMethodScope(name);
        }
        throw new SemanticException("Method " + name + " not found.");
    }

    @Override
    public FieldInstance findField(Name name) throws SemanticException {
        VarInstance<?> vi = this.findVariableSilent(name);
        if (vi instanceof FieldInstance) {
            FieldInstance fi = (FieldInstance)vi;
            if (!this.ts.isAccessible(fi, this)) {
                throw new SemanticException("Field " + name + " not accessible.");
            }
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-field " + name + " -> " + fi);
            }
            return fi;
        }
        throw new NoMemberException(3, "Field " + name + " not found.");
    }

    @Override
    public VarInstance<?> findVariable(Name name) throws SemanticException {
        VarInstance<?> vi = this.findVariableSilent(name);
        if (vi != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-var " + name + " -> " + vi);
            }
            return vi;
        }
        throw new SemanticException("Variable " + name + " not found.");
    }

    @Override
    public VarInstance<?> findVariableSilent(Name name) {
        VarInstance<?> vi;
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-var " + name + " in " + this);
        }
        if ((vi = this.findVariableInThisScope(name)) != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-var " + name + " -> " + vi);
            }
            return vi;
        }
        if (this.outer != null) {
            return this.outer.findVariableSilent(name);
        }
        return null;
    }

    protected String mapsToString() {
        return "types=" + this.types + " vars=" + this.vars;
    }

    public String toString() {
        return "(" + this.kind + " " + this.mapsToString() + " " + this.outer + ")";
    }

    @Override
    public Context pop() {
        return this.outer;
    }

    @Override
    public Named find(Matcher<Named> matcher) throws SemanticException {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-type " + matcher.signature() + " in " + this);
        }
        if (this.isOuter()) {
            return this.ts.systemResolver().find(QName.make(null, matcher.name()));
        }
        if (this.isSource()) {
            return this.it.find(matcher);
        }
        Named type = this.findInThisScope(matcher);
        if (type != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find " + matcher.signature() + " -> " + type);
            }
            return type;
        }
        if (this.outer != null) {
            return this.outer.find(matcher);
        }
        throw new SemanticException("Type " + matcher.signature() + " not found.");
    }

    @Override
    public Context pushSource(ImportTable it) {
        Context_c v = this.push();
        v.kind = SOURCE;
        v.it = it;
        v.inCode = false;
        v.staticContext = false;
        return v;
    }

    @Override
    public Context pushClass(ClassDef classScope, ClassType type) {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push class " + classScope + " " + classScope.position());
        }
        Context_c v = this.push();
        v.kind = CLASS;
        v.scope = classScope;
        v.type = type;
        v.inCode = false;
        v.staticContext = false;
        if (!type.isAnonymous()) {
            v.addNamed(type);
        }
        return v;
    }

    @Override
    public Context pushBlock() {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push block");
        }
        Context_c v = this.push();
        v.kind = BLOCK;
        return v;
    }

    @Override
    public Context pushStatic() {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push static");
        }
        Context_c v = this.push();
        v.staticContext = true;
        return v;
    }

    @Override
    public Context pushCode(CodeDef ci) {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push code " + ci + " " + ci.position());
        }
        Context_c v = this.push();
        v.kind = CODE;
        v.code = ci;
        v.inCode = true;
        v.staticContext = ci instanceof MemberDef && ((MemberDef)((Object)ci)).flags().isStatic();
        return v;
    }

    @Override
    public CodeDef currentCode() {
        return this.code;
    }

    @Override
    public boolean inCode() {
        return this.inCode;
    }

    @Override
    public boolean inStaticContext() {
        return this.staticContext;
    }

    @Override
    public ClassType currentClass() {
        return this.type;
    }

    @Override
    public ClassDef currentClassDef() {
        return this.scope;
    }

    @Override
    public void addVariable(VarInstance vi) {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "Adding " + vi + " to context.");
        }
        this.addVariableToThisScope(vi);
    }

    @Override
    public void addNamed(Named t) {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "Adding type " + t + " to context.");
        }
        this.addNamedToThisScope(t);
    }

    public Named findInThisScope(Matcher<Named> matcher) {
        Name name = matcher.name();
        Named t = null;
        if (this.types != null && (t = this.types.get(name)) != null) {
            try {
                t = matcher.instantiate(t);
            }
            catch (SemanticException e) {
                t = null;
            }
        }
        if (t == null && this.isClass() && this.type != null && !this.type.isAnonymous()) {
            try {
                t = matcher.instantiate(this.type);
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
        if (t == null && this.isClass()) {
            try {
                t = this.ts.classContextResolver(this.currentClass(), this).find(matcher);
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
        return t;
    }

    public void addNamedToThisScope(Named type) {
        if (this.types == null) {
            this.types = new HashMap<Name, Named>();
        }
        this.types.put(type.name(), type);
    }

    public ClassType findMethodContainerInThisScope(Name name) {
        if (this.isClass() && this.ts.hasMethodNamed(this.currentClass(), name)) {
            return this.type;
        }
        return null;
    }

    public VarInstance<?> findVariableInThisScope(Name name) {
        VarInstance<?> vi = null;
        if (this.vars != null) {
            vi = this.vars.get(name);
        }
        if (vi == null && this.isClass()) {
            try {
                return this.ts.findField(this.currentClass(), this.ts.FieldMatcher(this.currentClass(), name, this));
            }
            catch (SemanticException e) {
                return null;
            }
        }
        return vi;
    }

    public void addVariableToThisScope(VarInstance<?> var) {
        if (this.vars == null) {
            this.vars = new HashMap();
        }
        this.vars.put(var.name(), var);
    }

    public static class Kind
    extends Enum {
        public Kind(String name) {
            super(name);
        }
    }
}

