/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.AbstractAccessControlResolver;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Matcher;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageContextResolver
extends AbstractAccessControlResolver {
    protected Package p;

    public PackageContextResolver(TypeSystem ts, Package p) {
        super(ts);
        this.p = p;
    }

    public Package package_() {
        return this.p;
    }

    @Override
    public Named find(Matcher<Named> matcher, Context context) throws SemanticException {
        Named n;
        block4: {
            Name name = matcher.name();
            n = null;
            try {
                n = this.ts.systemResolver().find(QName.make(this.p.fullName(), name));
            }
            catch (NoClassException e) {
                if (e.getClassName().equals(this.p.fullName() + "." + name)) break block4;
                throw e;
            }
        }
        if (!this.canAccess(n, context)) {
            throw new SemanticException("Cannot access " + n + " from " + context.currentClassDef() + ".");
        }
        if (n != null) {
            n = matcher.instantiate(n);
        }
        return n;
    }

    protected boolean canAccess(Named n, Context context) {
        if (n instanceof ClassType) {
            return context == null || this.ts.classAccessible((ClassDef)((ClassType)n).def(), context);
        }
        return true;
    }

    public String toString() {
        return "(package-context " + this.p.toString() + ")";
    }
}

