/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.Serializable;
import java.util.HashMap;
import polyglot.types.Name;
import polyglot.util.StringUtil;

public class QName
implements Serializable {
    private static final long serialVersionUID = 4114000967641601437L;
    private QName qualifier;
    private Name name;
    private int hash;
    static HashMap<String, QName> internCache = new HashMap();

    private QName(QName qualifier, Name name, int hash) {
        this.qualifier = qualifier;
        this.name = name;
        this.hash = hash;
    }

    public Name name() {
        return this.name;
    }

    public QName qualifier() {
        return this.qualifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QName make(QName qualifier, Name name) {
        String shortName = name.toString();
        String fullName = qualifier == null ? shortName : qualifier.toString() + (shortName.startsWith("$") ? "" : ".") + shortName;
        HashMap<String, QName> hashMap = internCache;
        synchronized (hashMap) {
            QName q = internCache.get(fullName);
            if (q != null) {
                return q;
            }
            int hash = fullName.hashCode();
            q = new QName(qualifier, name, hash);
            internCache.put(fullName, q);
            return q;
        }
    }

    public boolean startsWith(QName name) {
        if (name == null) {
            return true;
        }
        if (this.equals(name)) {
            return true;
        }
        if (this.qualifier() != null) {
            return this.qualifier().startsWith(name);
        }
        return false;
    }

    public static QName make(QName q) {
        return q;
    }

    public static QName make(String qualifier, String name) {
        return QName.make(QName.make(qualifier), Name.make(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QName make(String fullName) {
        if (fullName == null) {
            return null;
        }
        if (fullName.equals("")) {
            return null;
        }
        HashMap<String, QName> hashMap = internCache;
        synchronized (hashMap) {
            QName q = internCache.get(fullName);
            if (q != null) {
                return q;
            }
            int hash = fullName.hashCode();
            if (StringUtil.isNameShort(fullName)) {
                q = new QName(null, Name.make(fullName), hash);
            } else {
                String container = StringUtil.getPackageComponent(fullName);
                String name = StringUtil.getShortNameComponent(fullName);
                q = new QName(QName.make(container), Name.make(name), hash);
            }
            internCache.put(fullName, q);
            return q;
        }
    }

    public final void equals(String s) {
    }

    public final void equals(Name s) {
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        if (this.qualifier == null) {
            return this.name.toString();
        }
        return this.qualifier.toString() + "." + this.name.toString();
    }
}

