/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.frontend.Compiler;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.Goal;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.main.Report;
import polyglot.types.BadSerializationException;
import polyglot.types.ClassDef;
import polyglot.types.LoadedClassResolver;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.util.InternalCompilerError;

public class SourceClassResolver
extends LoadedClassResolver {
    protected Compiler compiler;
    protected ExtensionInfo ext;
    protected boolean compileCommandLineOnly;
    protected boolean ignoreModTimes;

    public SourceClassResolver(Compiler compiler, ExtensionInfo ext, String classpath, ClassFileLoader loader, boolean allowRawClasses, boolean compileCommandLineOnly, boolean ignoreModTimes) {
        super(ext.typeSystem(), classpath, loader, ext.version(), allowRawClasses);
        this.compiler = compiler;
        this.ext = ext;
        this.compileCommandLineOnly = compileCommandLineOnly;
        this.ignoreModTimes = ignoreModTimes;
    }

    public boolean packageExists(QName name) {
        if (super.packageExists(name)) {
            return true;
        }
        return this.ext.sourceLoader().packageExists(name);
    }

    public Named find(QName name) throws SemanticException {
        if (Report.should_report(report_topics, 3)) {
            Report.report(3, "SourceCR.find(" + name + ")");
        }
        ClassFile clazz = null;
        ClassFile encodedClazz = null;
        FileSource source = null;
        clazz = this.loadFile(name);
        if (clazz != null && clazz.encodedClassType(this.version.name()) != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Class " + name + " has encoded type info");
            }
            encodedClazz = clazz;
        }
        if ((source = this.ext.sourceLoader().classSource(name)) != null && this.ext.scheduler().sourceHasJob(source)) {
            return this.getTypeFromSource(source, name);
        }
        if (Report.should_report(report_topics, 4)) {
            if (source == null) {
                Report.report(4, "Class " + name + " not found in source file");
            } else {
                Report.report(4, "Class " + name + " found in source " + source);
            }
        }
        if (encodedClazz != null || source != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Not using raw class file for " + name);
            }
            clazz = null;
        }
        if (encodedClazz != null && source != null) {
            long classModTime = encodedClazz.sourceLastModified(this.version.name());
            long sourceModTime = source.lastModified().getTime();
            int comp = this.checkCompilerVersion(encodedClazz.compilerVersion(this.version.name()));
            if (!this.ignoreModTimes && classModTime < sourceModTime) {
                if (Report.should_report(report_topics, 3)) {
                    Report.report(3, "Source file version is newer than compiled for " + name + ".");
                }
                encodedClazz = null;
            } else if (comp != 0) {
                if (Report.should_report(report_topics, 3)) {
                    Report.report(3, "Incompatible source file version for " + name + ".");
                }
                encodedClazz = null;
            }
        }
        Named result = null;
        if (encodedClazz != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using encoded class type for " + name);
            }
            try {
                result = this.getEncodedType(encodedClazz, name);
            }
            catch (BadSerializationException e) {
                throw e;
            }
            catch (SemanticException e) {
                if (Report.should_report(report_topics, 4)) {
                    Report.report(4, "Could not load encoded class " + name);
                }
                encodedClazz = null;
            }
        }
        if (result == null && clazz != null && this.allowRawClasses) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using raw class file for " + name);
            }
            ClassDef cd = this.ts.classFileLazyClassInitializer(clazz).type();
            result = this.ts.rawify(cd);
        }
        if (result == null && source != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using source file for " + name);
            }
            result = this.getTypeFromSource(source, name);
        }
        if (result != null) {
            return result;
        }
        if (clazz != null && !this.allowRawClasses) {
            throw new SemanticException("Class \"" + name + "\" not found." + " A class file was found, but it did not contain appropriate" + " information for the Polyglot-based compiler " + this.ext.compilerName() + ". Try using " + this.ext.compilerName() + " to recompile the source code.");
        }
        throw new NoClassException(name.toString());
    }

    protected Named getTypeFromSource(FileSource source, QName name) throws SemanticException {
        Scheduler scheduler = this.ext.scheduler();
        Job job = scheduler.loadSource(source, !this.compileCommandLineOnly);
        if (Report.should_report("sourceloader", 3)) {
            new Exception("loaded " + source).printStackTrace();
        }
        if (job != null) {
            Named n = this.ts.systemResolver().check(name);
            if (n != null) {
                return n;
            }
            Goal g = scheduler.PreTypeCheck(job);
            if (!scheduler.reached(g)) {
                try {
                    scheduler.attempt(g);
                }
                catch (CyclicDependencyException e) {
                    throw new InternalCompilerError("Could not initialize symbol table for " + source + "; cyclic dependency found.", e);
                }
            }
            if ((n = this.ts.systemResolver().check(name)) != null) {
                return n;
            }
        }
        throw new NoClassException("Could not find \"" + name + "\" in " + source + ".");
    }
}

