/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import polyglot.frontend.Globals;
import polyglot.main.Report;
import polyglot.types.ArrayType;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MemberDef;
import polyglot.types.MemberInstance;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.NoMemberException;
import polyglot.types.NullType;
import polyglot.types.ObjectType;
import polyglot.types.Package;
import polyglot.types.ProcedureDef;
import polyglot.types.ProcedureInstance;
import polyglot.types.ProcedureInstance_c;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeEnv;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.types.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeEnv_c
implements TypeEnv {
    protected Context context;
    protected TypeSystem ts;

    public TypeEnv_c(Context context) {
        if (context == null) {
            TypeSystem ts = Globals.TS();
            context = ts.emptyContext();
        }
        this.context = context;
        this.ts = context.typeSystem();
    }

    @Override
    public TypeEnv_c copy() {
        try {
            return (TypeEnv_c)super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    @Override
    public boolean canCoerceToString(Type t) {
        return !t.isVoid();
    }

    @Override
    public boolean typeEquals(Type type1, Type type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        if (type1 instanceof ArrayType && type2 instanceof ArrayType) {
            ArrayType at1 = (ArrayType)type1;
            ArrayType at2 = (ArrayType)type2;
            return this.typeEquals(at1.base(), at2.base());
        }
        return this.ts.equals((TypeObject)type1, (TypeObject)type2);
    }

    @Override
    public boolean packageEquals(Package type1, Package type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.packageEquals(type2);
    }

    @Override
    public boolean isCastValid(Type fromType, Type toType) {
        if (fromType instanceof NullType) {
            return toType.isNull() || toType.isReference();
        }
        if (fromType.isPrimitive() && toType.isPrimitive()) {
            if (fromType.isVoid() || toType.isVoid()) {
                return false;
            }
            if (this.ts.typeEquals(fromType, toType, this.context)) {
                return true;
            }
            return fromType.isNumeric() && toType.isNumeric();
        }
        if (fromType instanceof ArrayType && toType instanceof ArrayType) {
            ArrayType fromAT = (ArrayType)fromType;
            ArrayType toAT = (ArrayType)toType;
            Type fromBase = fromAT.base();
            Type toBase = toAT.base();
            if (fromBase.isPrimitive()) {
                return this.ts.typeEquals(toBase, fromBase, this.context);
            }
            if (toBase.isPrimitive()) {
                return false;
            }
            if (fromBase.isNull()) {
                return false;
            }
            if (toBase.isNull()) {
                return false;
            }
            return this.ts.isCastValid(fromBase, toBase, this.context);
        }
        if (fromType instanceof ArrayType && toType instanceof ReferenceType) {
            return this.ts.isSubtype(fromType, toType, this.context);
        }
        if (fromType instanceof ClassType && toType instanceof ArrayType) {
            return this.ts.isSubtype(toType, fromType, this.context);
        }
        if (fromType instanceof ClassType && toType instanceof ClassType) {
            ClassType fromCT = (ClassType)fromType;
            ClassType toCT = (ClassType)toType;
            boolean fromInterface = fromCT.flags().isInterface();
            boolean toInterface = toCT.flags().isInterface();
            boolean fromFinal = fromCT.flags().isFinal();
            boolean toFinal = toCT.flags().isFinal();
            if (fromInterface) {
                if (!toInterface && !toFinal) {
                    return true;
                }
                if (toFinal) {
                    return this.ts.isSubtype(toType, fromCT, this.context);
                }
                return true;
            }
            if (!toInterface) {
                return this.ts.isSubtype(fromCT, toType, this.context) || this.ts.isSubtype(toType, fromCT, this.context);
            }
            if (fromFinal) {
                return this.ts.isSubtype(fromCT, toType, this.context);
            }
            return true;
        }
        if (fromType instanceof ReferenceType) {
            if (!toType.isReference()) {
                return false;
            }
            return this.ts.isSubtype(fromType, toType, this.context) || this.ts.isSubtype(toType, fromType, this.context);
        }
        return false;
    }

    @Override
    public boolean isImplicitCastValid(Type fromType, Type toType) {
        if (fromType.isPrimitive() && toType.isPrimitive()) {
            if (toType.isVoid()) {
                return false;
            }
            if (fromType.isVoid()) {
                return false;
            }
            if (this.ts.typeEquals(toType, fromType, this.context)) {
                return true;
            }
            if (toType.isBoolean()) {
                return fromType.isBoolean();
            }
            if (fromType.isBoolean()) {
                return false;
            }
            if (!fromType.isNumeric() || !toType.isNumeric()) {
                return false;
            }
            if (toType.isDouble()) {
                return true;
            }
            if (fromType.isDouble()) {
                return false;
            }
            if (toType.isFloat()) {
                return true;
            }
            if (fromType.isFloat()) {
                return false;
            }
            if (toType.isLong()) {
                return true;
            }
            if (fromType.isLong()) {
                return false;
            }
            if (toType.isInt()) {
                return true;
            }
            if (fromType.isInt()) {
                return false;
            }
            if (toType.isShort()) {
                return fromType.isShort() || fromType.isByte();
            }
            if (fromType.isShort()) {
                return false;
            }
            if (toType.isChar()) {
                return fromType.isChar();
            }
            if (fromType.isChar()) {
                return false;
            }
            if (toType.isByte()) {
                return fromType.isByte();
            }
            if (fromType.isByte()) {
                return false;
            }
            return false;
        }
        if (fromType instanceof ArrayType && toType instanceof ArrayType) {
            ArrayType fromAT = (ArrayType)fromType;
            Type fromBase = fromAT.base();
            ArrayType toAT = (ArrayType)toType;
            Type toBase = toAT.base();
            if (fromBase.isPrimitive() || toBase.isPrimitive()) {
                return this.ts.typeEquals(fromBase, toBase, this.context);
            }
            return this.isImplicitCastValid(fromBase, toBase);
        }
        if (fromType instanceof NullType) {
            return toType.isNull() || toType.isReference();
        }
        if (fromType instanceof ReferenceType) {
            return this.ts.isSubtype(fromType, toType, this.context);
        }
        return false;
    }

    @Override
    public boolean numericConversionValid(Type t, Object value) {
        long v;
        if (value instanceof Float || value instanceof Double) {
            return false;
        }
        if (value instanceof Number) {
            v = ((Number)value).longValue();
        } else if (value instanceof Character) {
            v = ((Character)value).charValue();
        } else {
            return false;
        }
        if (t.isLong()) {
            return true;
        }
        if (t.isInt()) {
            return Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE;
        }
        if (t.isChar()) {
            return 0L <= v && v <= 65535L;
        }
        if (t.isShort()) {
            return -32768L <= v && v <= 32767L;
        }
        if (t.isByte()) {
            return -128L <= v && v <= 127L;
        }
        return false;
    }

    @Override
    public boolean isAccessible(MemberInstance<? extends MemberDef> mi) {
        ClassDef contextClass = this.context.currentClassDef();
        StructType target = mi.container();
        Flags flags = mi.flags();
        if (!target.isClass()) {
            return flags.isPublic();
        }
        if (contextClass == null) {
            return flags.isPublic();
        }
        ClassType contextClassType = contextClass.asType();
        ClassType targetClass = target.toClass();
        if (!this.classAccessible((ClassDef)targetClass.def())) {
            return false;
        }
        if (this.ts.equals((TypeObject)targetClass.def(), (TypeObject)contextClass)) {
            return true;
        }
        if (this.ts.isEnclosed(contextClass, (ClassDef)targetClass.def()) || this.ts.isEnclosed((ClassDef)targetClass.def(), contextClass)) {
            return true;
        }
        ClassDef cd = contextClass;
        while (!cd.isTopLevel()) {
            cd = cd.outer().get();
            if (!this.ts.isEnclosed((ClassDef)targetClass.def(), cd)) continue;
            return true;
        }
        if (flags.isProtected()) {
            if (this.ts.descendsFrom(this.ts.classDefOf(contextClassType), this.ts.classDefOf(targetClass))) {
                return true;
            }
            ClassType ct = contextClassType;
            while (!ct.isTopLevel()) {
                if (!this.ts.descendsFrom(this.ts.classDefOf(ct = ct.outer()), this.ts.classDefOf(targetClass))) continue;
                return true;
            }
        }
        return this.accessibleFromPackage(flags, targetClass.package_(), contextClassType.package_());
    }

    @Override
    public boolean isAccessibleTarget(MemberInstance<? extends MemberDef> mi, Type target) {
        ClassDef contextClass = this.context.currentClassDef();
        Flags flags = mi.flags();
        if (!target.isClass()) {
            return flags.isPublic();
        }
        if (contextClass == null) {
            return flags.isPublic();
        }
        ClassType contextClassType = contextClass.asType();
        ClassType targetClass = target.toClass();
        if (!this.classAccessible((ClassDef)targetClass.def())) {
            return false;
        }
        if (this.ts.equals((TypeObject)targetClass.def(), (TypeObject)contextClass)) {
            return true;
        }
        if (this.ts.isEnclosed(contextClass, (ClassDef)targetClass.def()) || this.ts.isEnclosed((ClassDef)targetClass.def(), contextClass)) {
            return true;
        }
        ClassDef cd = contextClass;
        while (!cd.isTopLevel()) {
            cd = cd.outer().get();
            if (!this.ts.isEnclosed((ClassDef)targetClass.def(), cd)) continue;
            return true;
        }
        if (flags.isProtected()) {
            if (this.ts.descendsFrom(this.ts.classDefOf(contextClassType), this.ts.classDefOf(targetClass))) {
                return true;
            }
            ClassType ct = contextClassType;
            while (!ct.isTopLevel()) {
                if (!this.ts.descendsFrom(this.ts.classDefOf(ct = ct.outer()), this.ts.classDefOf(targetClass))) continue;
                return true;
            }
        }
        return this.accessibleFromPackage(flags, targetClass.package_(), contextClassType.package_());
    }

    @Override
    public boolean classAccessible(ClassDef targetClass) {
        ClassDef contextClass = this.context.currentClassDef();
        if (contextClass == null) {
            return this.classAccessibleFromPackage(targetClass, this.context.package_());
        }
        if (targetClass.isMember()) {
            return this.isAccessible(targetClass.asType());
        }
        ClassType contextClassType = contextClass.asType();
        if (!targetClass.isTopLevel()) {
            return true;
        }
        if (this.ts.equals((TypeObject)targetClass, (TypeObject)contextClass)) {
            return true;
        }
        if (this.ts.isEnclosed(contextClass, targetClass)) {
            return true;
        }
        return this.classAccessibleFromPackage(targetClass, contextClassType.package_());
    }

    @Override
    public boolean classAccessibleFromPackage(ClassDef targetClass, Package pkg) {
        if (!targetClass.isTopLevel() && !targetClass.isMember()) {
            return false;
        }
        Flags flags = targetClass.flags();
        if (targetClass.isMember()) {
            if (!targetClass.container().get().isClass()) {
                return flags.isPublic();
            }
            if (!this.classAccessibleFromPackage((ClassDef)targetClass.container().get().toClass().def(), pkg)) {
                return false;
            }
        }
        return this.accessibleFromPackage(flags, Types.get(targetClass.package_()), pkg);
    }

    @Override
    public boolean accessibleFromPackage(Flags flags, Package pkg1, Package pkg2) {
        if (flags.isPublic()) {
            return true;
        }
        if (flags.isPackage() || flags.isProtected()) {
            if (pkg1 == null && pkg2 == null) {
                return true;
            }
            if (pkg1 == null || pkg2 == null) {
                return false;
            }
            if (pkg1.packageEquals(pkg2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSubtype(Type t1, Type t2) {
        if (this.typeEquals(t1, t2)) {
            return true;
        }
        if (t1.isNull()) {
            return t2.isNull() || t2.isReference();
        }
        if (t1.isReference() && t2.isNull()) {
            return false;
        }
        Type child = t1;
        Type ancestor = t2;
        if (child instanceof ObjectType) {
            ObjectType childRT = (ObjectType)child;
            if (this.typeEquals(ancestor, this.ts.Object())) {
                return true;
            }
            if (this.typeEquals(childRT, this.ts.Object())) {
                return false;
            }
            if (childRT.superClass() != null && this.isSubtype(childRT.superClass(), ancestor)) {
                return true;
            }
            for (Type parentType : childRT.interfaces()) {
                if (!this.isSubtype(parentType, ancestor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends ProcedureDef> boolean moreSpecific(ProcedureInstance<T> p1, ProcedureInstance<T> p2) {
        return p1.moreSpecific(p2, this.context);
    }

    @Override
    public Type leastCommonAncestor(Type type1, Type type2) throws SemanticException {
        if (this.typeEquals(type1, type2)) {
            return type1;
        }
        if (type1.isNumeric() && type2.isNumeric()) {
            if (this.isImplicitCastValid(type1, type2)) {
                return type2;
            }
            if (this.isImplicitCastValid(type2, type1)) {
                return type1;
            }
            if (type1.isChar() && type2.isByte() || type1.isByte() && type2.isChar()) {
                return this.ts.Int();
            }
            if (type1.isChar() && type2.isShort() || type1.isShort() && type2.isChar()) {
                return this.ts.Int();
            }
        }
        if (type1.isArray() && type2.isArray()) {
            if (type1.toArray().base().isReference() && type2.toArray().base().isReference()) {
                return this.ts.arrayOf(this.leastCommonAncestor(type1.toArray().base(), type2.toArray().base()));
            }
            return this.ts.Object();
        }
        if (type1.isReference() && type2.isNull()) {
            return type1;
        }
        if (type2.isReference() && type1.isNull()) {
            return type2;
        }
        if (type1.isClass() && type1.toClass().flags().isInterface()) {
            return this.ts.Object();
        }
        if (type2.isClass() && type2.toClass().flags().isInterface()) {
            return this.ts.Object();
        }
        if (this.typeEquals(type1, this.ts.Object())) {
            return type1;
        }
        if (this.typeEquals(type2, this.ts.Object())) {
            return type2;
        }
        if (this.isSubtype(type1, type2)) {
            return type2;
        }
        if (this.isSubtype(type2, type1)) {
            return type1;
        }
        if (type1 instanceof ObjectType && type2 instanceof ObjectType) {
            Type t2;
            Type t1 = this.leastCommonAncestor(((ObjectType)type1).superClass(), type2);
            if (this.typeEquals(t1, t2 = this.leastCommonAncestor(((ObjectType)type2).superClass(), type1))) {
                return t1;
            }
            return this.ts.Object();
        }
        throw new SemanticException("No least common ancestor found for types \"" + type1 + "\" and \"" + type2 + "\".");
    }

    @Override
    public boolean hasMethod(Type t, MethodInstance mi) {
        return t instanceof StructType && ((StructType)t).hasMethod(mi, this.context);
    }

    @Override
    public boolean hasFormals(ProcedureInstance<? extends ProcedureDef> pi, List<Type> formalTypes) {
        return ((ProcedureInstance_c)pi).hasFormals(formalTypes, this.context);
    }

    @Override
    public List<MethodInstance> overrides(MethodInstance mi) {
        ArrayList<MethodInstance> l = new ArrayList<MethodInstance>();
        StructType rt = mi.container();
        while (rt != null) {
            ObjectType ot;
            l.addAll(rt.methods(mi.name(), mi.formalTypes(), this.context));
            StructType sup = null;
            if (rt instanceof ObjectType && (ot = (ObjectType)rt).superClass() instanceof StructType) {
                sup = (StructType)ot.superClass();
            }
            rt = sup;
        }
        return l;
    }

    @Override
    public List<MethodInstance> implemented(MethodInstance mi) {
        return this.implemented(mi, mi.container());
    }

    @Override
    public List<MethodInstance> implemented(MethodInstance mi, StructType st) {
        if (st == null) {
            return Collections.emptyList();
        }
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        l.addAll(st.methods(mi.name(), mi.formalTypes(), this.context));
        if (st instanceof ObjectType) {
            ObjectType rt = (ObjectType)st;
            Type superType = rt.superClass();
            if (superType instanceof StructType) {
                l.addAll(this.implemented(mi, (StructType)superType));
            }
            List<Type> ints = rt.interfaces();
            for (Type t : ints) {
                if (!(t instanceof StructType)) continue;
                StructType rt2 = (StructType)t;
                l.addAll(this.implemented(mi, rt2));
            }
        }
        return l;
    }

    @Override
    public void checkClassConformance(ClassType ct) throws SemanticException {
        if (ct.flags().isAbstract()) {
            return;
        }
        List<Type> superInterfaces = this.ts.abstractSuperInterfaces(ct);
        for (Type it : superInterfaces) {
            if (!(it instanceof StructType)) continue;
            StructType rt = (StructType)it;
            for (MethodInstance mi : rt.methods()) {
                if (!mi.flags().isAbstract()) continue;
                MethodInstance mj = this.ts.findImplementingMethod(ct, mi, this.context);
                if (mj == null) {
                    if (ct.flags().isAbstract()) continue;
                    throw new SemanticException(ct.fullName() + " should be declared abstract; it does not define " + mi.signature() + ", which is declared in " + rt.toClass().fullName(), ct.position());
                }
                if (this.typeEquals(ct, mj.container()) || this.typeEquals(ct, mi.container())) continue;
                try {
                    this.checkOverride(mj, mi);
                }
                catch (SemanticException e) {
                    throw new SemanticException(e.getMessage(), ct.position());
                }
            }
        }
    }

    @Override
    public boolean canOverride(MethodInstance mi, MethodInstance mj) {
        try {
            this.checkOverride(mi, mj);
            return true;
        }
        catch (SemanticException e) {
            return false;
        }
    }

    @Override
    public void checkOverride(MethodInstance mi, MethodInstance mj) throws SemanticException {
        ClassType ct;
        boolean allowCovariantReturn = false;
        if (mj.container() instanceof ClassType && ((ClassDef)(ct = (ClassType)mj.container()).def()).fromJavaClassFile()) {
            allowCovariantReturn = true;
        }
        this.checkOverride(mi, mj, allowCovariantReturn);
    }

    @Override
    public void checkOverride(MethodInstance mi, MethodInstance mj, boolean allowCovariantReturn) throws SemanticException {
        if (mi == mj) {
            return;
        }
        if (!mi.name().equals(mj.name()) || !mi.hasFormals(mj.formalTypes(), this.context)) {
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; incompatible " + "parameter types", mi.position());
        }
        if (allowCovariantReturn ? !this.isSubtype(mi.returnType(), mj.returnType()) : !this.typeEquals(mi.returnType(), mj.returnType())) {
            if (Report.should_report("types", 3)) {
                Report.report(3, "return type " + mi.returnType() + " != " + mj.returnType());
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; attempting to use incompatible " + "return type\n" + "found: " + mi.returnType() + "\n" + "required: " + mj.returnType(), mi.position());
        }
        if (!this.ts.throwsSubset(mi, mj)) {
            if (Report.should_report("types", 3)) {
                Report.report(3, mi.throwTypes() + " not subset of " + mj.throwTypes());
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; the throw set " + mi.throwTypes() + " is not a subset of the " + "overridden method's throw set " + mj.throwTypes() + ".", mi.position());
        }
        if (mi.flags().moreRestrictiveThan(mj.flags())) {
            if (Report.should_report("types", 3)) {
                Report.report(3, mi.flags() + " more restrictive than " + mj.flags());
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; attempting to assign weaker " + "access privileges", mi.position());
        }
        if (mi.flags().isStatic() != mj.flags().isStatic()) {
            if (Report.should_report("types", 3)) {
                Report.report(3, mi.signature() + " is " + (mi.flags().isStatic() ? "" : "not") + " static but " + mj.signature() + " is " + (mj.flags().isStatic() ? "" : "not") + " static");
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; overridden method is " + (mj.flags().isStatic() ? "" : "not") + "static", mi.position());
        }
        if (!((MethodDef)mi.def()).equals(mj.def()) && mj.flags().isFinal()) {
            if (Report.should_report("types", 3)) {
                Report.report(3, mj.flags() + " final");
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; overridden method is final", mi.position());
        }
    }

    @Override
    public boolean isSameMethod(MethodInstance m1, MethodInstance m2) {
        return m1.name().equals(m2.name()) && m1.hasFormals(m2.formalTypes(), this.context);
    }

    @Override
    public boolean callValid(ProcedureInstance<? extends ProcedureDef> prototype, Type thisType, List<Type> argTypes) {
        return ((ProcedureInstance_c)prototype).callValid(thisType, argTypes, this.context);
    }

    @Override
    public Type findMemberType(Type container, Name name) throws SemanticException {
        Named n = this.ts.classContextResolver(container, this.context).find(this.ts.MemberTypeMatcher(container, name, this.context));
        if (n instanceof ClassType) {
            return (ClassType)n;
        }
        throw new NoClassException(name.toString(), container);
    }

    @Override
    public List<ConstructorInstance> findAcceptableConstructors(Type container, TypeSystem_c.ConstructorMatcher matcher) throws SemanticException {
        NoMemberException error = null;
        ArrayList<ConstructorInstance> acceptable = new ArrayList<ConstructorInstance>();
        if (Report.should_report("types", 2)) {
            Report.report(2, "Searching type " + container + " for constructor " + matcher.signature());
        }
        if (!(container instanceof ClassType)) {
            return Collections.EMPTY_LIST;
        }
        for (ConstructorInstance ci : ((ClassType)container).constructors()) {
            if (Report.should_report("types", 3)) {
                Report.report(3, "Trying " + ci);
            }
            try {
                if ((ci = matcher.instantiate(ci)) == null) continue;
                if (this.isAccessible(ci)) {
                    if (Report.should_report("types", 3)) {
                        Report.report(3, "->acceptable: " + ci);
                    }
                    acceptable.add(ci);
                    continue;
                }
                if (error != null) continue;
                error = new NoMemberException(2, "Constructor " + ci.signature() + " is inaccessible.");
            }
            catch (SemanticException e) {
                if (error != null) continue;
                error = new NoMemberException(2, "Constructor " + ci.signature() + " cannot be invoked with arguments " + matcher.argumentString() + ".");
            }
        }
        if (acceptable.size() == 0) {
            if (error == null) {
                error = new NoMemberException(2, "No valid constructor found in " + container + " for " + matcher.signature() + ".");
            }
            throw error;
        }
        return acceptable;
    }
}

